/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.core.instmgr.InstMgrResourceDefinition;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.installationmanager.InstallationManagerFinder;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public final class InstMgrInitialization
implements ModelControllerServiceInitialization {
    public void initializeStandalone(ServiceTarget target, ManagementModel managementModel, ProcessType processType) {
        if (processType == ProcessType.EMBEDDED_SERVER) {
            return;
        }
        Optional im = InstallationManagerFinder.reloadAndFind();
        if (im.isPresent()) {
            InstallationManagerFactory imf = (InstallationManagerFactory)im.get();
            InstMgrService imService = this.createImService(target, imf);
            managementModel.getRootResource().registerChild(InstMgrResourceDefinition.getPath("installer"), (Resource)PlaceholderResource.INSTANCE);
            managementModel.getRootResourceRegistration().registerSubModel((ResourceDefinition)new InstMgrResourceDefinition(imf, imService));
        }
    }

    public void initializeDomain(ServiceTarget target, ManagementModel managementModel) {
    }

    public void initializeHost(ServiceTarget target, ManagementModel managementModel, String hostName, ProcessType processType) {
        if (processType == ProcessType.EMBEDDED_HOST_CONTROLLER) {
            return;
        }
        Optional im = InstallationManagerFinder.reloadAndFind();
        if (im.isPresent()) {
            PathElement host = PathElement.pathElement((String)"host", (String)hostName);
            ManagementResourceRegistration hostRegistration = managementModel.getRootResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{host}));
            Resource hostResource = managementModel.getRootResource().getChild(host);
            if (hostResource == null) {
                return;
            }
            InstallationManagerFactory imf = (InstallationManagerFactory)im.get();
            InstMgrService imService = this.createImService(target, imf);
            hostResource.registerChild(InstMgrResourceDefinition.getPath("installer"), (Resource)PlaceholderResource.INSTANCE);
            hostRegistration.registerSubModel((ResourceDefinition)new InstMgrResourceDefinition(imf, imService));
        }
    }

    private InstMgrService createImService(ServiceTarget target, InstallationManagerFactory imf) {
        ServiceName serviceName = InstMgrResourceDefinition.INSTALLATION_MANAGER_CAPABILITY.getCapabilityServiceName();
        ServiceBuilder serviceBuilder = target.addService(serviceName);
        Consumer consumer = serviceBuilder.provides(new ServiceName[]{serviceName});
        Supplier pathManagerSupplier = serviceBuilder.requires(AbstractControllerService.PATH_MANAGER_CAPABILITY.getCapabilityServiceName());
        Supplier executorSupplier = serviceBuilder.requires(AbstractControllerService.EXECUTOR_CAPABILITY.getCapabilityServiceName());
        InstMgrService imService = new InstMgrService(imf, pathManagerSupplier, executorSupplier, consumer);
        serviceBuilder.setInstance((Service)imService).setInitialMode(ServiceController.Mode.PASSIVE).install();
        return imService;
    }
}

