/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.metacommand.ChooseScriptAction;
import org.jboss.as.cli.gui.metacommand.OpenScriptAction;

public class ScriptMenu
extends JMenu {
    private static final Preferences prefs = Preferences.userNodeForPackage(ScriptMenu.class);
    private static final int SCRIPT_LIST_SIZE = 15;
    private CliGuiContext cliGuiCtx;
    private LinkedList<File> previouslyRun = new LinkedList();

    public ScriptMenu(CliGuiContext cliGuiCtx) {
        super("Scripts");
        this.cliGuiCtx = cliGuiCtx;
        this.setMnemonic(83);
        JMenuItem chooseScript = new JMenuItem(new ChooseScriptAction(this, cliGuiCtx));
        chooseScript.setMnemonic(67);
        this.add(chooseScript);
        this.addSeparator();
        this.readPreviouslyRun();
    }

    private void readPreviouslyRun() {
        for (int i = 0; i < 15; ++i) {
            File file;
            String filePath = prefs.get("Script" + i, null);
            if (filePath == null || !(file = new File(filePath)).exists()) continue;
            this.previouslyRun.add(file);
            this.add(new OpenScriptAction(this, this.cliGuiCtx, file));
        }
    }

    private void writePreviouslyRun() {
        int i = 0;
        for (File file : this.previouslyRun) {
            if (!file.exists()) continue;
            try {
                prefs.put("Script" + i, file.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        for (int j = i; j < 15; ++j) {
            prefs.put("Script" + j, "");
        }
    }

    public void addScript(File scriptFile) {
        this.previouslyRun.remove(scriptFile);
        this.previouslyRun.addFirst(scriptFile);
        for (int i = this.getItemCount() - 1; i > 1; --i) {
            this.remove(i);
        }
        if (this.previouslyRun.size() > 15) {
            this.previouslyRun.removeLast();
        }
        for (File file : this.previouslyRun) {
            if (!file.exists()) continue;
            this.add(new OpenScriptAction(this, this.cliGuiCtx, file));
        }
        this.writePreviouslyRun();
    }
}

