/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Iterator;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.JMSEndpointResolver;

public class DefaultJMSEndpointResolver
implements JMSEndpointResolver {
    private String fromName;

    public void setDestination(Destination destination) {
        if (destination instanceof Queue) {
            this.setFromName(destination, true);
        } else if (destination instanceof Topic) {
            this.setFromName(destination, false);
        }
    }

    protected void setFromName(Destination destination, boolean queue) {
        try {
            this.fromName = queue ? "queue/" + ((Queue)destination).getQueueName() : "topic/" + ((Topic)destination).getTopicName();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public Endpoint query(Iterator<Endpoint> endpoints) {
        Endpoint endpoint = null;
        while (endpoints.hasNext()) {
            Endpoint aux = endpoints.next();
            String jmsProp = aux.getName().getKeyProperty("jms");
            if (jmsProp == null || !jmsProp.equals(this.fromName)) continue;
            endpoint = aux;
            break;
        }
        return endpoint;
    }
}

