/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.remoting.transport.Address;

class DistributedIterator<T>
implements CloseableIterator<T> {
    private final AdvancedCache<Object, Object> cache;
    private int currentIndex = -1;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;
    private final NodeTopDocs[] partialResults;
    private final int[] partialPositionNext;
    private final TopDocs mergedResults;
    private final LocalQueryStatistics queryStatistics;
    private int valueIndex;
    private final int batchSize;
    private final List<T> values;

    DistributedIterator(LocalQueryStatistics queryStatistics, Sort sort, int resultSize, int maxResults, int firstResult, Map<Address, NodeTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.queryStatistics = queryStatistics;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        int parallels = topDocsResponses.size();
        this.partialResults = new NodeTopDocs[parallels];
        boolean isFieldDocs = DistributedIterator.expectTopFieldDocs(topDocsResponses);
        TopFieldDocs[] partialTopDocs = isFieldDocs ? new TopFieldDocs[parallels] : new TopDocs[parallels];
        this.partialPositionNext = new int[parallels];
        int i = 0;
        for (Map.Entry<Address, NodeTopDocs> entry : topDocsResponses.entrySet()) {
            this.partialResults[i] = entry.getValue();
            partialTopDocs[i] = this.partialResults[i].topDocs;
            ++i;
        }
        this.mergedResults = isFieldDocs ? TopDocs.merge((Sort)sort, (int)firstResult, (int)maxResults, (TopFieldDocs[])partialTopDocs, (boolean)true) : TopDocs.merge((int)firstResult, (int)maxResults, (TopDocs[])partialTopDocs, (boolean)true);
        this.batchSize = Math.min(maxResults, cache.getCacheConfiguration().clustering().stateTransfer().chunkSize());
        this.values = new ArrayList<T>(this.batchSize);
    }

    private static boolean expectTopFieldDocs(Map<Address, NodeTopDocs> topDocsResponses) {
        Iterator<NodeTopDocs> it = topDocsResponses.values().iterator();
        if (it.hasNext()) {
            return it.next().topDocs instanceof TopFieldDocs;
        }
        return false;
    }

    public void close() {
    }

    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (!this.values.isEmpty());
        assert (this.valueIndex < this.values.size());
        return this.values.get(this.valueIndex++);
    }

    protected T decorate(Object key, Object value) {
        return (T)value;
    }

    public final boolean hasNext() {
        if (this.valueIndex == this.values.size()) {
            this.fetchBatch();
        }
        return this.valueIndex < this.values.size();
    }

    private void fetchBatch() {
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(this.batchSize);
        this.values.clear();
        this.valueIndex = 0;
        for (int i = 0; i < this.batchSize && this.hasMoreKeys(); ++i) {
            Object key = this.nextKey();
            if (key == null) continue;
            keys.add(this.cache.getKeyDataConversion().fromStorage(key));
        }
        if (keys.isEmpty()) {
            return;
        }
        if (!this.queryStatistics.isEnabled()) {
            this.getAllAndStore(keys);
            return;
        }
        TimeService timeService = this.cache.getComponentRegistry().getTimeService();
        long start = timeService.time();
        this.getAllAndStore(keys);
        this.queryStatistics.entityLoaded(timeService.timeDuration(start, TimeUnit.NANOSECONDS));
    }

    private void getAllAndStore(Set<Object> keys) {
        Map map = this.cache.getAll(keys);
        keys.stream().map(key -> this.decorate(key, map.get(key))).forEach(this.values::add);
    }

    private boolean hasMoreKeys() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }

    private Object nextKey() {
        ++this.currentIndex;
        ScoreDoc scoreDoc = this.mergedResults.scoreDocs[this.currentIndex];
        int index = scoreDoc.shardIndex;
        NodeTopDocs nodeTopDocs = this.partialResults[index];
        if (this.partialPositionNext[index] == 0) {
            int docId = scoreDoc.doc;
            ScoreDoc[] scoreDocs = nodeTopDocs.topDocs.scoreDocs;
            for (int i = 0; i < scoreDocs.length; ++i) {
                if (scoreDocs[i].doc != docId) continue;
                this.partialPositionNext[index] = i;
                break;
            }
        }
        int n = index;
        int n2 = this.partialPositionNext[n];
        this.partialPositionNext[n] = n2 + 1;
        int pos = n2;
        if (nodeTopDocs.keys == null || nodeTopDocs.keys.length == 0) {
            this.values.add(nodeTopDocs.projections[pos]);
            return null;
        }
        return nodeTopDocs.keys[pos];
    }
}

