/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class InterfaceGen
implements com.sun.tools.corba.se.idl.InterfaceGen,
JavaGenerator {
    protected int emit = 0;
    protected Factories factories = null;
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected static final int SIGNATURE = 1;
    protected static final int OPERATIONS = 2;
    protected int intfType = 0;

    @Override
    public void generate(Hashtable symbolTable, InterfaceEntry i, PrintWriter stream) {
        if (!this.isPseudo(i)) {
            this.symbolTable = symbolTable;
            this.i = i;
            this.init();
            if (!i.isLocalSignature()) {
                if (!i.isLocal()) {
                    this.generateSkeleton();
                    Arguments theArguments = (Arguments)Compile.compiler.arguments;
                    if (theArguments.TIEServer) {
                        if (theArguments.emit == 3) {
                            theArguments.TIEServer = false;
                            this.generateSkeleton();
                            theArguments.TIEServer = true;
                        }
                    }
                    this.generateStub();
                }
                this.generateHolder();
                this.generateHelper();
            }
            this.intfType = 1;
            this.generateInterface();
            this.intfType = 2;
            this.generateInterface();
            this.intfType = 0;
        }
    }

    protected void init() {
        this.emit = ((Arguments)Compile.compiler.arguments).emit;
        this.factories = (Factories)Compile.compiler.factories();
    }

    protected void generateSkeleton() {
        if (this.emit != 1) {
            this.factories.skeleton().generate(this.symbolTable, this.i);
        }
    }

    protected void generateStub() {
        if (this.emit != 2) {
            this.factories.stub().generate(this.symbolTable, this.i);
        }
    }

    protected void generateHelper() {
        if (this.emit != 2) {
            this.factories.helper().generate(this.symbolTable, this.i);
        }
    }

    protected void generateHolder() {
        if (this.emit != 2) {
            this.factories.holder().generate(this.symbolTable, this.i);
        }
    }

    protected void generateInterface() {
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        if (this.intfType == 2) {
            this.writeOperationsBody();
        }
        if (this.intfType == 1) {
            this.writeSignatureBody();
        }
        this.writeClosing();
        this.closeStream();
    }

    protected void openStream() {
        if (this.i.isAbstract() || this.intfType == 1) {
            this.stream = Util.stream(this.i, ".java");
        } else if (this.intfType == 2) {
            this.stream = Util.stream(this.i, "Operations.java");
        }
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)0);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        String className = this.i.name();
        if (this.intfType == 1) {
            this.writeSignatureHeading();
        } else if (this.intfType == 2) {
            this.writeOperationsHeading();
        }
        this.stream.println();
        this.stream.println('{');
    }

    protected void writeSignatureHeading() {
        String className = this.i.name();
        this.stream.print("public interface " + className + " extends " + className + "Operations, ");
        boolean firstTime = true;
        boolean hasNonAbstractParent = false;
        for (int k = 0; k < this.i.derivedFrom().size(); ++k) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.stream.print(", ");
            }
            InterfaceEntry parent = (InterfaceEntry)this.i.derivedFrom().elementAt(k);
            this.stream.print(Util.javaName(parent));
            if (parent.isAbstract()) continue;
            hasNonAbstractParent = true;
        }
        if (!hasNonAbstractParent) {
            this.stream.print(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity ");
        } else if (this.i.derivedFrom().size() == 1) {
            this.stream.print(", org.omg.CORBA.portable.IDLEntity ");
        }
    }

    protected void writeOperationsHeading() {
        this.stream.print("public interface " + this.i.name());
        if (!this.i.isAbstract()) {
            this.stream.print("Operations ");
        } else if (this.i.derivedFrom().size() == 0) {
            this.stream.print(" extends org.omg.CORBA.portable.IDLEntity");
        }
        boolean firstTime = true;
        for (int k = 0; k < this.i.derivedFrom().size(); ++k) {
            InterfaceEntry parent = (InterfaceEntry)this.i.derivedFrom().elementAt(k);
            String parentName = Util.javaName(parent);
            if (parentName.equals("org.omg.CORBA.Object")) continue;
            if (firstTime) {
                firstTime = false;
                this.stream.print(" extends ");
            } else {
                this.stream.print(", ");
            }
            if (parent.isAbstract() || this.i.isAbstract()) {
                this.stream.print(parentName);
                continue;
            }
            this.stream.print(parentName + "Operations");
        }
    }

    protected void writeOperationsBody() {
        Enumeration e = this.i.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry contained = (SymtabEntry)e.nextElement();
            if (contained instanceof MethodEntry) {
                MethodEntry element = (MethodEntry)contained;
                ((MethodGen)element.generator()).interfaceMethod(this.symbolTable, element, this.stream);
                continue;
            }
            if (contained instanceof ConstEntry) continue;
            contained.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeSignatureBody() {
        Enumeration e = this.i.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry contained = (SymtabEntry)e.nextElement();
            if (!(contained instanceof ConstEntry)) continue;
            contained.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeClosing() {
        Object intfName = this.i.name();
        if (!this.i.isAbstract() && this.intfType == 2) {
            intfName = (String)intfName + "Operations";
        }
        this.stream.println("} // interface " + (String)intfName);
    }

    protected void closeStream() {
        this.stream.close();
    }

    @Override
    public int helperType(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        InterfaceEntry i = (InterfaceEntry)entry;
        tcoffsets.set(entry);
        if (entry.fullName().equals("org/omg/CORBA/Object")) {
            stream.println(indent + name + " = org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_objref);");
        } else {
            stream.println(indent + name + " = org.omg.CORBA.ORB.init ().create_interface_tc (" + Util.helperName(i, true) + ".id (), \"" + Util.stripLeadingUnderscores(entry.name()) + "\");");
        }
        return index;
    }

    @Override
    public int type(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        stream.println(indent + name + " = " + Util.helperName(entry, true) + ".type ();");
        return index;
    }

    @Override
    public void helperRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        InterfaceEntry i = (InterfaceEntry)entry;
        if (i.isAbstract()) {
            stream.println("    return narrow (((org.omg.CORBA_2_3.portable.InputStream)istream).read_abstract_interface (_" + i.name() + "Stub.class));");
        } else {
            stream.println("    return narrow (istream.read_Object (_" + i.name() + "Stub.class));");
        }
    }

    @Override
    public void helperWrite(SymtabEntry entry, PrintWriter stream) {
        this.write(0, "    ", "value", entry, stream);
    }

    @Override
    public int read(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        InterfaceEntry i = (InterfaceEntry)entry;
        if (entry.fullName().equals("org/omg/CORBA/Object")) {
            stream.println(indent + name + " = istream.read_Object (_" + i.name() + "Stub.class);");
        } else {
            stream.println(indent + name + " = " + Util.helperName(entry, false) + ".narrow (istream.read_Object (_" + i.name() + "Stub.class));");
        }
        return index;
    }

    @Override
    public int write(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        InterfaceEntry i = (InterfaceEntry)entry;
        if (i.isAbstract()) {
            stream.println(indent + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_abstract_interface ((java.lang.Object) " + name + ");");
        } else {
            stream.println(indent + "ostream.write_Object ((org.omg.CORBA.Object) " + name + ");");
        }
        return index;
    }

    private boolean isPseudo(InterfaceEntry i) {
        String fullname = i.fullName();
        if (fullname.equalsIgnoreCase("CORBA/TypeCode")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/Principal")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/ORB")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/Any")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/Context")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/ContextList")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/DynamicImplementation")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/Environment")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/ExceptionList")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/NVList")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/NamedValue")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/Request")) {
            return true;
        }
        if (fullname.equalsIgnoreCase("CORBA/ServerRequest")) {
            return true;
        }
        return fullname.equalsIgnoreCase("CORBA/UserException");
    }
}

