/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.ql.parse;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.objectfilter.impl.antlr.runtime.CommonToken;
import org.infinispan.objectfilter.impl.antlr.runtime.EarlyExitException;
import org.infinispan.objectfilter.impl.antlr.runtime.FailedPredicateException;
import org.infinispan.objectfilter.impl.antlr.runtime.MismatchedNotSetException;
import org.infinispan.objectfilter.impl.antlr.runtime.MismatchedSetException;
import org.infinispan.objectfilter.impl.antlr.runtime.MismatchedTokenException;
import org.infinispan.objectfilter.impl.antlr.runtime.MismatchedTreeNodeException;
import org.infinispan.objectfilter.impl.antlr.runtime.NoViableAltException;
import org.infinispan.objectfilter.impl.antlr.runtime.Parser;
import org.infinispan.objectfilter.impl.antlr.runtime.RecognitionException;
import org.infinispan.objectfilter.impl.antlr.runtime.RecognizerSharedState;
import org.infinispan.objectfilter.impl.antlr.runtime.Token;
import org.infinispan.objectfilter.impl.antlr.runtime.TokenStream;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.CommonTree;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.Tree;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.TreeAdaptor;

abstract class ParserBase
extends Parser {
    private PrintStream errStream;
    private final Deque<Boolean> enableParameterUsage = new ArrayDeque<Boolean>();
    private final List<String> errorMessages = new LinkedList<String>();
    private int unaliasedCount = 0;

    protected ParserBase(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    protected abstract TreeAdaptor getTreeAdaptor();

    protected final Tree generatePersisterSpacesTree(List<?> persisterSpaces) {
        TreeAdaptor adaptor = this.getTreeAdaptor();
        ArrayList<Tree> persisterSpaceList = new ArrayList<Tree>();
        for (Tree persistenceSpaceData : persisterSpaces) {
            if (persistenceSpaceData.getType() == 105 || persistenceSpaceData.getType() == 110) {
                adaptor.addChild(persisterSpaceList.get(persisterSpaceList.size() - 1), persistenceSpaceData);
                continue;
            }
            Tree persistenceSpaceTree = (Tree)adaptor.becomeRoot(adaptor.create(106, "PERSISTER_SPACE"), adaptor.nil());
            adaptor.addChild(persistenceSpaceTree, persistenceSpaceData);
            persisterSpaceList.add(persistenceSpaceTree);
        }
        Tree resultTree = (Tree)adaptor.nil();
        for (Tree persistenceElement : persisterSpaceList) {
            adaptor.addChild(resultTree, persistenceElement);
        }
        return resultTree;
    }

    protected final Tree generateImplicitSelectFrom(Tree selectClause, Tree fromClause, List<String> aliasList) {
        Tree selectTree;
        CommonTree result = new CommonTree(new CommonToken(123, "SELECT_FROM"));
        result.addChild(fromClause);
        if (selectClause == null && aliasList != null && aliasList.size() > 0) {
            selectTree = new CommonTree(new CommonToken(122, "SELECT"));
            CommonTree selectList = new CommonTree(new CommonToken(125, "SELECT_LIST"));
            for (String aliasName : aliasList) {
                CommonTree selectElement = new CommonTree(new CommonToken(124, "SELECT_ITEM"));
                CommonTree aliasElement = new CommonTree(new CommonToken(5, aliasName));
                selectElement.addChild(aliasElement);
                selectList.addChild(selectElement);
            }
            selectTree.addChild(selectList);
        } else {
            selectTree = selectClause;
        }
        result.addChild(selectTree);
        return result;
    }

    protected final String buildUniqueImplicitAlias() {
        return "<gen:" + this.unaliasedCount++ + ">";
    }

    protected final boolean isParameterUsageEnabled() {
        return !this.enableParameterUsage.isEmpty() && this.enableParameterUsage.peek() != false;
    }

    protected final void pushEnableParameterUsage(boolean enable) {
        this.enableParameterUsage.push(enable);
    }

    protected final void popEnableParameterUsage() {
        this.enableParameterUsage.pop();
    }

    protected final boolean validateSoftKeyword(String text) {
        return this.validateSoftKeyword(1, text);
    }

    protected final boolean validateSoftKeyword(int offset, String text) {
        if (this.input == null) {
            return false;
        }
        Token token = this.input.LT(offset);
        return token != null && text.equalsIgnoreCase(token.getText());
    }

    public final boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public final List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public final void reportError(RecognitionException e) {
        this.errorMessages.add(this.generateErrorMessage(ParserBase.getRuleInvocationStack(e, this.getClass().getName()), this.getTokenNames(), e));
        super.reportError(e);
    }

    public void setErrStream(PrintStream errStream) {
        this.errStream = errStream;
    }

    @Override
    public final void emitErrorMessage(String msg) {
        if (this.errStream != null) {
            this.errStream.println(msg);
        }
    }

    private String generateErrorMessage(List<?> invocationStack, String[] tokenNames, RecognitionException e) {
        String localization = String.valueOf(invocationStack) + ": line " + e.line + ":" + e.charPositionInLine + " ";
        return this.generateErrorMessage(localization, tokenNames, e);
    }

    private String generateErrorMessage(String localization, String[] tokenNames, RecognitionException e) {
        Object message = "";
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String tokenName = "<unknown>";
            if (mte.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mte.expecting];
            }
            message = localization + "mismatched token: " + String.valueOf(e.token) + "; expecting type " + tokenName;
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            String tokenName = "<unknown>";
            if (mtne.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mtne.expecting];
            }
            message = localization + "mismatched tree node: " + String.valueOf(mtne.node) + "; expecting type " + tokenName;
        } else if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            message = localization + "state " + nvae.stateNumber + " (decision=" + nvae.decisionNumber + ") no viable alt; token=" + String.valueOf(e.token);
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            message = localization + "required (...)+ loop (decision=" + eee.decisionNumber + ") did not match anything; token=" + String.valueOf(e.token);
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            message = localization + "mismatched token: " + String.valueOf(e.token) + "; expecting set " + String.valueOf(mse.expecting);
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            message = localization + "mismatched token: " + String.valueOf(e.token) + "; expecting set " + String.valueOf(mse.expecting);
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            message = localization + "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
        return message;
    }
}

