/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager;

import java.util.Objects;

public class ManifestVersion {
    private final String channelId;
    private final String description;
    private final String version;
    private final Type type;

    public ManifestVersion(String channelId, String description, String version, Type type) {
        Objects.requireNonNull(channelId);
        Objects.requireNonNull(version);
        Objects.requireNonNull(type);
        this.channelId = channelId;
        this.description = description;
        this.version = version;
        this.type = type;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "ManifestVersion{channelId='" + this.channelId + "', description='" + this.description + "', version='" + this.version + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestVersion that = (ManifestVersion)o;
        return Objects.equals(this.channelId, that.channelId) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.channelId, this.description, this.version);
    }

    public static enum Type {
        MAVEN,
        URL;

    }
}

