/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionEntityByNonIdPropertyLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.DocumentIdSourceProperty;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmNonEntityIdPropertyEntityLoadingStrategy<E, I>
extends AbstractHibernateOrmLoadingStrategy<E, I> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String entityName;
    private final TypeQueryFactory<E, I> queryFactory;
    private final String documentIdSourcePropertyName;
    private final ValueReadHandle<? extends I> documentIdSourceHandle;

    public static <I> HibernateOrmEntityLoadingStrategy<?, ? super I> create(PersistentClass persistentClass, DocumentIdSourceProperty<I> documentIdSourceProperty) {
        return HibernateOrmNonEntityIdPropertyEntityLoadingStrategy.create(persistentClass, HibernateOrmUtils.entityClass(persistentClass), documentIdSourceProperty.clazz, documentIdSourceProperty.name, documentIdSourceProperty.handle);
    }

    private static <E, I> HibernateOrmNonEntityIdPropertyEntityLoadingStrategy<E, I> create(PersistentClass persistentClass, Class<E> mappedClass, Class<I> documentIdSourcePropertyClass, String documentIdSourcePropertyName, ValueReadHandle<? extends I> documentIdSourceHandle) {
        Property idProperty = persistentClass.getIdentifierProperty();
        TypeQueryFactory<E, I> queryFactory = TypeQueryFactory.create(mappedClass, persistentClass.getEntityName(), documentIdSourcePropertyClass, documentIdSourcePropertyName, idProperty != null && documentIdSourcePropertyName.equals(idProperty.getName()));
        return new HibernateOrmNonEntityIdPropertyEntityLoadingStrategy<E, I>(persistentClass.getRootClass().getEntityName(), persistentClass.getEntityName(), queryFactory, documentIdSourcePropertyName, documentIdSourceHandle);
    }

    private HibernateOrmNonEntityIdPropertyEntityLoadingStrategy(String rootEntityName, String entityName, TypeQueryFactory<E, I> queryFactory, String documentIdSourcePropertyName, ValueReadHandle<? extends I> documentIdSourceHandle) {
        super(rootEntityName, queryFactory);
        this.entityName = entityName;
        this.queryFactory = queryFactory;
        this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        this.documentIdSourceHandle = documentIdSourceHandle;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HibernateOrmNonEntityIdPropertyEntityLoadingStrategy other = (HibernateOrmNonEntityIdPropertyEntityLoadingStrategy)obj;
        return this.entityName.equals(other.entityName) && this.documentIdSourcePropertyName.equals(other.documentIdSourcePropertyName) && this.documentIdSourceHandle.equals(other.documentIdSourceHandle);
    }

    public int hashCode() {
        return Objects.hash(this.entityName, this.documentIdSourcePropertyName, this.documentIdSourceHandle);
    }

    @Override
    public PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> targetEntityTypeContexts, HibernateOrmSelectionLoadingContext loadingContext) {
        if (targetEntityTypeContexts.size() != 1) {
            throw this.multipleTypesException(targetEntityTypeContexts);
        }
        return this.doCreate(targetEntityTypeContexts.iterator().next(), loadingContext.sessionContext(), loadingContext.cacheLookupStrategy(), loadingContext.loadingOptions());
    }

    private PojoSelectionEntityLoader<E> doCreate(PojoLoadingTypeContext<? extends E> targetEntityTypeContext, HibernateOrmLoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (!this.entityName.equals(targetEntityTypeContext.secondaryEntityName())) {
            throw this.invalidTypeException(targetEntityTypeContext);
        }
        SessionFactoryImplementor sessionFactory = sessionContext.session().getSessionFactory();
        EntityMappingType entityMapping = HibernateOrmUtils.entityMappingType(sessionFactory, targetEntityTypeContext.secondaryEntityName());
        HibernateOrmSelectionEntityByNonIdPropertyLoader<? extends E> result = new HibernateOrmSelectionEntityByNonIdPropertyLoader<E>(entityMapping, targetEntityTypeContext, this.queryFactory, this.documentIdSourcePropertyName, this.documentIdSourceHandle, sessionContext, loadingOptions);
        if (!EntityLoadingCacheLookupStrategy.SKIP.equals((Object)cacheLookupStrategy)) {
            log.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(targetEntityTypeContext.entityName(), cacheLookupStrategy);
        }
        return result;
    }

    private AssertionFailure invalidTypeException(PojoLoadingTypeContext<?> otherType) {
        throw new AssertionFailure("Attempt to use a criteria-based entity loader with an unexpected target entity type. Expected entity name: " + this.entityName + " Targeted entity name: " + otherType.secondaryEntityName());
    }

    private AssertionFailure multipleTypesException(Set<? extends PojoLoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Attempt to use a criteria-based entity loader with multiple target entity types. Expected entity name: " + this.entityName + " Targeted entity names: " + targetEntityTypeContexts.stream().map(PojoLoadingTypeContext::secondaryEntityName).collect(Collectors.toUnmodifiableList()));
    }
}

