/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ASYNC_TRANSPORT_EXECUTOR("async-executor"),
    AUTHENTICATION("authentication"),
    AUTH_PLAIN("plain"),
    AUTH_DIGEST("digest"),
    AUTH_EXTERNAL("external"),
    CACHE("cache"),
    CONNECTION_POOL("connection-pool"),
    ENCRYPTION("encryption"),
    KEYSTORE("keystore"),
    PROPERTIES("properties"),
    REMOTE_STORE("remote-store"),
    SECURITY("security"),
    SERVERS("servers"),
    REMOTE_SERVER("remote-server"),
    TRUSTSTORE("truststore");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

