/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class LockingServiceConfigurator
extends ComponentServiceConfigurator<LockingConfiguration> {
    private volatile long timeout;
    private volatile int concurrency;
    private volatile IsolationLevel isolation;
    private volatile boolean striping;

    LockingServiceConfigurator(PathAddress address) {
        super(CacheComponent.LOCKING, address);
    }

    @Override
    public LockingConfiguration get() {
        return new ConfigurationBuilder().locking().lockAcquisitionTimeout(this.timeout).concurrencyLevel(this.concurrency).isolationLevel(this.isolation).useLockStriping(this.striping).create();
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.timeout = LockingResourceDefinition.Attribute.ACQUIRE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.concurrency = LockingResourceDefinition.Attribute.CONCURRENCY.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.isolation = IsolationLevel.valueOf((String)LockingResourceDefinition.Attribute.ISOLATION.resolveModelAttribute((ExpressionResolver)context, model).asString());
        this.striping = LockingResourceDefinition.Attribute.STRIPING.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        return this;
    }
}

