/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonRequirement;
import org.wildfly.extension.clustering.singleton.AliasServiceBuilder;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyServiceConfigurator;
import org.wildfly.service.capture.ServiceValueRegistry;

public class SingletonPolicyServiceHandler
implements ResourceServiceHandler {
    private final ServiceValueRegistry<Singleton> registry;

    SingletonPolicyServiceHandler(ServiceValueRegistry<Singleton> registry) {
        this.registry = registry;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        ServiceConfigurator configurator = new SingletonPolicyServiceConfigurator(address, this.registry).configure(context, model);
        configurator.build(target).install();
        new AliasServiceBuilder(SingletonPolicyResourceDefinition.Capability.LEGACY_POLICY.getServiceName(address), configurator.getServiceName(), SingletonRequirement.SINGLETON_POLICY.getType()).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (SingletonPolicyResourceDefinition.Capability capability : EnumSet.allOf(SingletonPolicyResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
    }
}

