/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLEnumJdbcType
implements JdbcType {
    @Override
    public int getJdbcTypeCode() {
        return 6001;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> appender.appendSql("'" + ((Enum)value).name() + "'::" + dialect.getEnumTypeDeclaration((Class)javaType.getJavaType()));
    }

    @Override
    public String getFriendlyName() {
        return "ENUM";
    }

    public String toString() {
        return "EnumTypeDescriptor";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 1111);
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 1111);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, (Object)((Enum)value).name(), 1111);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)((Enum)value).name(), 1111);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getObject(name), options);
            }
        };
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, TypeConfiguration typeConfiguration) {
        Dialect dialect = database.getDialect();
        Class enumClass = (Class)javaType.getJavaType();
        String[] create = dialect.getCreateEnumTypeCommand(enumClass);
        String[] drop = dialect.getDropEnumTypeCommand(enumClass);
        if (create != null && create.length > 0) {
            database.addAuxiliaryDatabaseObject(new NamedAuxiliaryDatabaseObject(enumClass.getSimpleName(), database.getDefaultNamespace(), create, drop, Collections.emptySet(), true));
        }
    }
}

