/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.filters;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeMarshaller;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;

public class FilterResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "filter";
    public static final SimpleMapAttributeDefinition CONSTRUCTOR_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("constructor-properties", true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)PropertyAttributeMarshaller.INSTANCE)).setXmlName("constructor-properties")).build();
    private static final PathElement PATH = PathElement.pathElement((String)"filter");
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.CLASS, CommonAttributes.MODULE, CONSTRUCTOR_PROPERTIES, CommonAttributes.PROPERTIES};
    private static final OperationStepHandler ADD = new LoggingOperations.LoggingAddOperationStepHandler(ATTRIBUTES){
        private final List<String> reservedNames = Arrays.asList("accept", "deny", "not", "all", "any", "levelChange", "levels", "levelRange", "match", "substitute", "substituteAll");

        @Override
        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            if (this.reservedNames.contains(name)) {
                throw LoggingLogger.ROOT_LOGGER.reservedFilterName(name, this.reservedNames);
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                throw LoggingLogger.ROOT_LOGGER.invalidFilterNameStart(name, name.charAt(0));
            }
            for (char c : name.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                throw LoggingLogger.ROOT_LOGGER.invalidFilterName(name, c);
            }
            super.populateModel(context, operation, resource);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            FilterConfiguration configuration = logContextConfiguration.getFilterConfiguration(name);
            String className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
            ModelNode moduleNameNode = CommonAttributes.MODULE.resolveModelAttribute(context, model);
            String moduleName = moduleNameNode.isDefined() ? moduleNameNode.asString() : null;
            ModelNode properties = CommonAttributes.PROPERTIES.resolveModelAttribute(context, model);
            ModelNode constructorProperties = CONSTRUCTOR_PROPERTIES.resolveModelAttribute(context, model);
            LinkedHashMap<String, String> constProps = new LinkedHashMap<String, String>();
            if (constructorProperties.isDefined()) {
                for (Property property : constructorProperties.asPropertyList()) {
                    constProps.put(property.getName(), property.getValue().asString());
                }
            }
            boolean replaceConfiguration = false;
            if (configuration != null) {
                if (!className.equals(configuration.getClassName()) || (moduleName == null ? configuration.getModuleName() != null : !moduleName.equals(configuration.getModuleName()))) {
                    replaceConfiguration = true;
                }
                List configuredConstProps = configuration.getConstructorProperties();
                for (Map.Entry entry : constProps.entrySet()) {
                    if (configuredConstProps.contains(entry.getKey())) {
                        if (configuration.getPropertyValueString((String)entry.getKey()).equals(entry.getValue())) continue;
                        replaceConfiguration = true;
                    } else {
                        replaceConfiguration = true;
                    }
                    break;
                }
            } else {
                LoggingLogger.ROOT_LOGGER.tracef("Adding filter '%s' at '%s'", name, context.getCurrentAddress());
                configuration = logContextConfiguration.addFilterConfiguration(moduleName, className, name, constProps.keySet().toArray(new String[0]));
            }
            if (replaceConfiguration) {
                LoggingLogger.ROOT_LOGGER.tracef("Replacing filter '%s' at '%s'", name, context.getCurrentAddress());
                logContextConfiguration.removeFilterConfiguration(name);
                configuration = logContextConfiguration.addFilterConfiguration(moduleName, className, name, constProps.keySet().toArray(new String[0]));
            }
            for (Map.Entry entry : constProps.entrySet()) {
                configuration.setPropertyValueString((String)entry.getKey(), (String)entry.getValue());
            }
            if (properties.isDefined()) {
                for (Property property : properties.asPropertyList()) {
                    configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                }
            }
        }
    };
    private static final OperationStepHandler WRITE = new LoggingOperations.LoggingWriteAttributeHandler(ATTRIBUTES){

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            block4: {
                FilterConfiguration configuration = logContextConfiguration.getFilterConfiguration(addressName);
                String modelClass = CommonAttributes.CLASS.resolveModelAttribute(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel()).asString();
                if (!CommonAttributes.PROPERTIES.getName().equals(attributeName) || !configuration.getClassName().equals(modelClass)) break block4;
                if (value.isDefined()) {
                    for (Property property : value.asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                } else {
                    List names = configuration.getPropertyNames();
                    for (String name : names) {
                        configuration.removeProperty(name);
                    }
                }
            }
            return CommonAttributes.CLASS.getName().equals(attributeName) || CommonAttributes.MODULE.getName().equals(attributeName) || CONSTRUCTOR_PROPERTIES.getName().equals(attributeName);
        }
    };
    private static final OperationStepHandler REMOVE = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            FilterConfiguration configuration = logContextConfiguration.getFilterConfiguration(name);
            if (configuration == null) {
                throw LoggingLogger.ROOT_LOGGER.filterNotFound(name);
            }
            logContextConfiguration.removeFilterConfiguration(name);
        }
    };
    public static final FilterResourceDefinition INSTANCE = new FilterResourceDefinition();

    private FilterResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setAddHandler(ADD).setRemoveHandler(REMOVE).addCapabilities(new RuntimeCapability[]{Capabilities.FILTER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, WRITE);
        }
    }

    public static final class TransformerDefinition
    extends TransformerResourceDefinition {
        public TransformerDefinition() {
            super(PATH);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
            if (modelVersion == KnownModelVersion.VERSION_8_0_0) {
                rootResourceBuilder.rejectChildResource(this.getPathElement());
                loggingProfileBuilder.rejectChildResource(this.getPathElement());
            }
        }
    }
}

