/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.io.IOException;
import java.util.List;
import org.aesh.command.impl.internal.ParsedCommand;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.core.cli.command.aesh.activator.AbstractCommandActivator;

public final class InstMgrActivator
extends AbstractCommandActivator {
    private static final Logger LOG = Logger.getLogger(InstMgrActivator.class);

    public boolean isActivated(ParsedCommand command) {
        try {
            CommandContext ctx = this.getCommandContext();
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client != null) {
                ModelNode op = new ModelNode();
                op.get("operation").set("query");
                ModelNode select = new ModelNode().addEmptyList();
                select.add("core-service");
                op.get("select").set(select);
                if (ctx.isDomainMode()) {
                    op.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)"*")}).toModelNode());
                    ModelNode response = client.execute(op);
                    List hosts = response.get("result").asListOrEmpty();
                    for (ModelNode hostResult : hosts) {
                        if (!hostResult.get(new String[]{"result", "core-service"}).has("installer")) continue;
                        return true;
                    }
                } else {
                    op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
                    ModelNode response = client.execute(op);
                    ModelNode result = response.get("result");
                    if (result.get("core-service").has("installer")) {
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"An error occurred inspecting the server resources. Installation Manager Commands cannot be activated", (Throwable)e);
            return false;
        }
        return false;
    }
}

