/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.loggers.LoggerAttributes;
import org.jboss.as.logging.loggers.LoggerOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LoggerResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "logger";
    private static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    private static final String LEGACY_ADD_HANDLER_OPERATION_NAME = "assign-handler";
    private static final String LEGACY_REMOVE_HANDLER_OPERATION_NAME = "unassign-handler";
    private static final PathElement LOGGER_PATH = PathElement.pathElement((String)"logger");
    private static final ResourceDescriptionResolver LOGGER_RESOLVER = LoggingExtension.getResourceDescriptionResolver("logger");
    public static final OperationDefinition CHANGE_LEVEL_OPERATION = new SimpleOperationDefinitionBuilder("change-log-level", LOGGER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.LEVEL}).build();
    public static final OperationDefinition LEGACY_ADD_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("assign-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    public static final OperationDefinition LEGACY_REMOVE_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("unassign-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    public static final OperationDefinition ADD_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("add-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build();
    public static final OperationDefinition REMOVE_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("remove-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build();
    public static final PropertyAttributeDefinition USE_PARENT_HANDLERS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("use-parent-handlers", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setPropertyName("useParentHandlers").build();
    public static final SimpleAttributeDefinition CATEGORY = SimpleAttributeDefinitionBuilder.create((String)"category", (ModelType)ModelType.STRING, (boolean)true).build();
    private static final AttributeDefinition[] WRITABLE_ATTRIBUTES = new AttributeDefinition[]{LoggerAttributes.FILTER_SPEC, CommonAttributes.LEVEL, LoggerAttributes.HANDLERS, USE_PARENT_HANDLERS};
    private final boolean includeLegacy;

    public LoggerResourceDefinition(boolean includeLegacy) {
        super(new SimpleResourceDefinition.Parameters(LOGGER_PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setAddHandler(LoggerOperations.LoggerAddOperationStepHandler.INSTANCE).setRemoveHandler(LoggerOperations.REMOVE_LOGGER).setAccessConstraints(new AccessConstraintDefinition[]{new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("logging", NAME))}).setCapabilities(new RuntimeCapability[]{Capabilities.LOGGER_CAPABILITY}));
        this.includeLegacy = includeLegacy;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : WRITABLE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, LoggerOperations.LoggerWriteAttributeHandler.INSTANCE);
        }
        if (this.includeLegacy) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.FILTER, (OperationStepHandler)LoggingOperations.ReadFilterOperationStepHandler.INSTANCE, LoggerOperations.LoggerWriteAttributeHandler.INSTANCE);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CATEGORY, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler(CHANGE_LEVEL_OPERATION, LoggerOperations.CHANGE_LEVEL);
        registration.registerOperationHandler(ADD_HANDLER_OPERATION, LoggerOperations.ADD_HANDLER);
        registration.registerOperationHandler(REMOVE_HANDLER_OPERATION, LoggerOperations.REMOVE_HANDLER);
        registration.registerOperationHandler(LEGACY_ADD_HANDLER_OPERATION, LoggerOperations.ADD_HANDLER);
        registration.registerOperationHandler(LEGACY_REMOVE_HANDLER_OPERATION, LoggerOperations.REMOVE_HANDLER);
    }

    public static final class TransformerDefinition
    extends TransformerResourceDefinition {
        public TransformerDefinition() {
            super(LOGGER_PATH);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        }
    }
}

