/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.JsonStructure;
import jakarta.json.bind.JsonbException;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.eclipse.yasson.YassonJsonb;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.JsonBindingBuilder;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.SerializationContextImpl;
import org.eclipse.yasson.internal.jsonstructure.JsonGeneratorToStructureAdapter;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureToParserAdapter;

public class JsonBinding
implements YassonJsonb {
    private final JsonbContext jsonbContext;

    JsonBinding(JsonBindingBuilder builder) {
        this.jsonbContext = new JsonbContext(builder.getConfig(), builder.getProvider().orElseGet(JsonProvider::provider));
        Set<Class<?>> eagerInitClasses = this.jsonbContext.getConfigProperties().getEagerInitClasses();
        for (Class<?> eagerInitClass : eagerInitClasses) {
            this.jsonbContext.getChainModelCreator().deserializerChain(eagerInitClass);
            this.jsonbContext.getSerializationModelCreator().serializerChain(eagerInitClass, true, true);
        }
    }

    private <T> T deserialize(Type type, JsonParser parser, DeserializationContextImpl unmarshaller) {
        return unmarshaller.deserialize(type, parser);
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        JsonParser parser = this.jsonbContext.getJsonProvider().createParser((Reader)new StringReader(str));
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(String str, Type type) throws JsonbException {
        JsonParser parser = this.jsonbContext.getJsonProvider().createParser((Reader)new StringReader(str));
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        JsonParser parser = this.jsonbContext.getJsonProvider().createParser(reader);
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonbException {
        JsonParser parser = this.jsonbContext.getJsonProvider().createParser(reader);
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(type, parser, unmarshaller);
    }

    public <T> T fromJson(InputStream stream, Class<T> clazz) throws JsonbException {
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(clazz, this.inputStreamParser(stream), unmarshaller);
    }

    public <T> T fromJson(InputStream stream, Type type) throws JsonbException {
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return this.deserialize(type, this.inputStreamParser(stream), unmarshaller);
    }

    @Override
    public <T> T fromJsonStructure(JsonStructure jsonStructure, Class<T> type) throws JsonbException {
        JsonStructureToParserAdapter parser = new JsonStructureToParserAdapter(jsonStructure);
        return this.deserialize(type, parser, new DeserializationContextImpl(this.jsonbContext));
    }

    @Override
    public <T> T fromJsonStructure(JsonStructure jsonStructure, Type runtimeType) throws JsonbException {
        JsonStructureToParserAdapter parser = new JsonStructureToParserAdapter(jsonStructure);
        return this.deserialize(runtimeType, parser, new DeserializationContextImpl(this.jsonbContext));
    }

    private JsonParser inputStreamParser(InputStream stream) {
        return this.jsonbContext.getJsonParserFactory().createParser(stream, Charset.forName(this.jsonbContext.getConfig().getProperty("jsonb.encoding").orElse("UTF-8")));
    }

    public String toJson(Object object) throws JsonbException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.writerGenerator(writer);
        new SerializationContextImpl(this.jsonbContext).marshall(object, generator);
        return writer.toString();
    }

    public String toJson(Object object, Type type) throws JsonbException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.writerGenerator(writer);
        new SerializationContextImpl(this.jsonbContext, type).marshall(object, generator);
        return writer.toString();
    }

    public void toJson(Object object, Writer writer) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext);
        marshaller.marshallWithoutClose(object, this.writerGenerator(writer));
    }

    public void toJson(Object object, Type type, Writer writer) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext, type);
        marshaller.marshallWithoutClose(object, this.writerGenerator(writer));
    }

    private JsonGenerator writerGenerator(Writer writer) {
        Map<String, ?> factoryProperties = this.jsonbContext.createJsonpProperties(this.jsonbContext.getConfig());
        if (factoryProperties.isEmpty()) {
            return this.jsonbContext.getJsonProvider().createGenerator(writer);
        }
        return this.jsonbContext.getJsonProvider().createGeneratorFactory(factoryProperties).createGenerator(writer);
    }

    public void toJson(Object object, OutputStream stream) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext);
        marshaller.marshall(object, this.streamGenerator(stream));
    }

    public void toJson(Object object, Type type, OutputStream stream) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext, type);
        marshaller.marshall(object, this.streamGenerator(stream));
    }

    @Override
    public <T> T fromJson(JsonParser jsonParser, Class<T> type) throws JsonbException {
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return unmarshaller.deserialize(type, jsonParser);
    }

    @Override
    public <T> T fromJson(JsonParser jsonParser, Type runtimeType) throws JsonbException {
        DeserializationContextImpl unmarshaller = new DeserializationContextImpl(this.jsonbContext);
        return unmarshaller.deserialize(runtimeType, jsonParser);
    }

    @Override
    public void toJson(Object object, JsonGenerator jsonGenerator) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext);
        marshaller.marshallWithoutClose(object, jsonGenerator);
    }

    @Override
    public void toJson(Object object, Type runtimeType, JsonGenerator jsonGenerator) throws JsonbException {
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext, runtimeType);
        marshaller.marshallWithoutClose(object, jsonGenerator);
    }

    @Override
    public JsonStructure toJsonStructure(Object object) throws JsonbException {
        JsonGeneratorToStructureAdapter structureGenerator = new JsonGeneratorToStructureAdapter(this.jsonbContext.getJsonProvider());
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext);
        marshaller.marshall(object, structureGenerator);
        return structureGenerator.getRootStructure();
    }

    @Override
    public JsonStructure toJsonStructure(Object object, Type runtimeType) throws JsonbException {
        JsonGeneratorToStructureAdapter structureGenerator = new JsonGeneratorToStructureAdapter(this.jsonbContext.getJsonProvider());
        SerializationContextImpl marshaller = new SerializationContextImpl(this.jsonbContext, runtimeType);
        marshaller.marshall(object, structureGenerator);
        return structureGenerator.getRootStructure();
    }

    private JsonGenerator streamGenerator(OutputStream stream) {
        Map<String, ?> factoryProperties = this.jsonbContext.createJsonpProperties(this.jsonbContext.getConfig());
        String encoding = this.jsonbContext.getConfig().getProperty("jsonb.encoding").orElse("UTF-8");
        return this.jsonbContext.getJsonProvider().createGeneratorFactory(factoryProperties).createGenerator(stream, Charset.forName(encoding));
    }

    public void close() throws Exception {
        this.jsonbContext.getComponentInstanceCreator().close();
    }
}

