/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.time.Duration;
import java.util.List;
import org.jboss.logging.Logger;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public interface Invoker {
    public <R, E extends Exception> R invoke(ExceptionSupplier<R, E> var1) throws E;

    default public <E extends Exception> void invoke(final ExceptionRunnable<E> action) throws E {
        ExceptionSupplier adapter = new ExceptionSupplier<Void, E>(this){
            final /* synthetic */ Invoker this$0;
            {
                this.this$0 = this$0;
            }

            public Void get() throws Exception {
                action.run();
                return null;
            }
        };
        this.invoke(adapter);
    }

    public static Invoker direct() {
        return new Invoker(){

            @Override
            public <R, E extends Exception> R invoke(ExceptionSupplier<R, E> action) throws E {
                return (R)action.get();
            }

            @Override
            public <E extends Exception> void invoke(ExceptionRunnable<E> action) throws E {
                action.run();
            }
        };
    }

    public static Invoker retrying(final List<Duration> intervals) {
        return new Invoker(){
            private final Logger logger = Logger.getLogger(Invoker.class);

            @Override
            public <R, E extends Exception> R invoke(ExceptionSupplier<R, E> task) throws E {
                int attempt = 0;
                for (Duration delay : intervals) {
                    if (Thread.currentThread().isInterrupted()) break;
                    try {
                        return (R)task.get();
                    }
                    catch (Exception e) {
                        this.logger.debugf((Throwable)e, "Attempt #%d failed", ++attempt);
                        if (delay.isZero() || delay.isNegative()) {
                            Thread.yield();
                            continue;
                        }
                        try {
                            Thread.sleep(delay.toMillis(), delay.getNano() % 1000000);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return (R)task.get();
            }
        };
    }
}

