/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchNestablePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchCommonMinimumShouldMatchConstraints;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.CommonQueryStringPredicateBuilder;

abstract class ElasticsearchCommonQueryStringPredicate
extends AbstractElasticsearchNestablePredicate {
    private static final JsonAccessor<String> QUERY_ACCESSOR = JsonAccessor.root().property("query").asString();
    private static final JsonAccessor<JsonElement> DEFAULT_OPERATOR_ACCESSOR = JsonAccessor.root().property("default_operator");
    private static final JsonAccessor<JsonArray> FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asArray();
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private static final JsonAccessor<String> MINIMUM_SHOULD_MATCH_ACCESSOR = JsonAccessor.root().property("minimum_should_match").asString();
    private static final JsonPrimitive AND_OPERATOR_KEYWORD_JSON = new JsonPrimitive("and");
    private static final JsonPrimitive OR_OPERATOR_KEYWORD_JSON = new JsonPrimitive("or");
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final List<JsonPrimitive> fieldNameAndBoosts;
    private final JsonPrimitive defaultOperator;
    private final String queryString;
    private final String analyzer;
    private final ElasticsearchCommonMinimumShouldMatchConstraints minimumShouldMatchConstraints;

    ElasticsearchCommonQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.firstFieldState.field().nestedPathHierarchy();
        this.fieldPaths = new ArrayList<String>(builder.fieldStates.size());
        for (ElasticsearchCommonQueryStringPredicateBuilderFieldState state : builder.fieldStates.values()) {
            this.fieldPaths.add(state.field().absolutePath());
        }
        this.fieldNameAndBoosts = new ArrayList<JsonPrimitive>();
        for (ElasticsearchCommonQueryStringPredicateBuilderFieldState fieldContext : builder.fieldStates.values()) {
            this.fieldNameAndBoosts.add(fieldContext.build());
        }
        this.defaultOperator = builder.defaultOperator;
        this.queryString = builder.queryString;
        this.analyzer = builder.analyzer;
        this.minimumShouldMatchConstraints = builder.minimumShouldMatchConstraints;
        builder.minimumShouldMatchConstraints = null;
    }

    @Override
    protected final JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY_ACCESSOR.set(innerObject, this.queryString);
        DEFAULT_OPERATOR_ACCESSOR.set(innerObject, (JsonElement)this.defaultOperator);
        JsonArray fieldArray = new JsonArray();
        for (JsonPrimitive fieldNameAndBoost : this.fieldNameAndBoosts) {
            fieldArray.add((JsonElement)fieldNameAndBoost);
        }
        FIELDS_ACCESSOR.set(innerObject, fieldArray);
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        if (!this.minimumShouldMatchConstraints.isEmpty()) {
            MINIMUM_SHOULD_MATCH_ACCESSOR.set(innerObject, this.minimumShouldMatchConstraints.formatMinimumShouldMatchConstraints());
        }
        this.addSpecificProperties(context, outerObject, innerObject);
        this.queryNameAccessor().set(outerObject, innerObject);
        return outerObject;
    }

    protected abstract void addSpecificProperties(PredicateRequestContext var1, JsonObject var2, JsonObject var3);

    protected abstract JsonObjectAccessor queryNameAccessor();

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    public static abstract class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements CommonQueryStringPredicateBuilder {
        protected ElasticsearchCommonQueryStringPredicateBuilderFieldState firstFieldState;
        protected final Map<String, ElasticsearchCommonQueryStringPredicateBuilderFieldState> fieldStates = new LinkedHashMap<String, ElasticsearchCommonQueryStringPredicateBuilderFieldState>();
        protected JsonPrimitive defaultOperator = OR_OPERATOR_KEYWORD_JSON;
        protected String queryString;
        protected String analyzer;
        private ElasticsearchCommonMinimumShouldMatchConstraints minimumShouldMatchConstraints = new ElasticsearchCommonMinimumShouldMatchConstraints();

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public final void defaultOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    this.defaultOperator = AND_OPERATOR_KEYWORD_JSON;
                    break;
                }
                case OR: {
                    this.defaultOperator = OR_OPERATOR_KEYWORD_JSON;
                }
            }
        }

        public final void queryString(String queryString) {
            this.queryString = queryString;
        }

        public final CommonQueryStringPredicateBuilder.FieldState field(String fieldPath) {
            ElasticsearchCommonQueryStringPredicateBuilderFieldState fieldState = this.fieldStates.get(fieldPath);
            if (fieldState == null) {
                fieldState = (ElasticsearchCommonQueryStringPredicateBuilderFieldState)this.scope.fieldQueryElement(fieldPath, this.typeKey());
                if (this.firstFieldState == null) {
                    this.firstFieldState = fieldState;
                } else {
                    SearchIndexSchemaElementContextHelper.checkNestedDocumentPathCompatibility(this.firstFieldState.field(), fieldState.field());
                }
                this.fieldStates.put(fieldPath, fieldState);
            }
            return fieldState;
        }

        public final void analyzer(String analyzerName) {
            this.analyzer = analyzerName;
        }

        public final void skipAnalysis() {
            this.analyzer("keyword");
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.minimumShouldMatchConstraints.minimumShouldMatchNumber(ignoreConstraintCeiling, matchingClausesNumber);
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.minimumShouldMatchConstraints.minimumShouldMatchPercent(ignoreConstraintCeiling, matchingClausesPercent);
        }

        public final SearchPredicate build() {
            if (this.analyzer == null) {
                for (ElasticsearchCommonQueryStringPredicateBuilderFieldState field : this.fieldStates.values()) {
                    field.checkAnalyzerOrNormalizerCompatibleAcrossIndexes();
                }
            }
            return this.doBuild(this);
        }

        protected abstract SearchPredicate doBuild(Builder var1);

        protected abstract SearchQueryElementTypeKey<ElasticsearchCommonQueryStringPredicateBuilderFieldState> typeKey();
    }
}

