/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.manager.Service;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;
import org.wildfly.clustering.singleton.SingletonState;
import org.wildfly.clustering.singleton.election.SingletonElectionListener;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.server.PrimaryProviderCommand;
import org.wildfly.clustering.singleton.server.SingletonContext;
import org.wildfly.clustering.singleton.server.SingletonContextRegistration;
import org.wildfly.clustering.singleton.server.SingletonElectionCommand;
import org.wildfly.clustering.singleton.server.SingletonLogger;
import org.wildfly.clustering.singleton.server.SingletonServiceContext;
import org.wildfly.clustering.singleton.server.StartCommand;
import org.wildfly.clustering.singleton.server.StopCommand;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractSingletonContext<C extends SingletonContext, S extends Service>
implements SingletonContextRegistration<C>,
Supplier<C>,
ServiceProviderListener<GroupMember> {
    private final ServiceName name;
    private final AtomicBoolean primary = new AtomicBoolean(false);
    private final S service;
    private final SingletonElectionListener electionListener;
    private final SingletonElectionPolicy electionPolicy;
    private final int quorum;
    private final Group<GroupMember> group;
    private final CommandDispatcher<GroupMember, C> dispatcher;
    private final ServiceProviderRegistration<ServiceName, GroupMember> registration;

    public AbstractSingletonContext(SingletonServiceContext context, S service) {
        this.name = context.getServiceName();
        this.service = service;
        this.electionListener = context.getElectionListener();
        this.electionPolicy = context.getElectionPolicy();
        this.quorum = context.getQuorum();
        this.group = context.getCommandDispatcherFactory().getGroup();
        this.dispatcher = context.getCommandDispatcherFactory().createCommandDispatcher((Object)this.name, (Object)((SingletonContext)this.get()), WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()));
        this.registration = context.getServiceProviderRegistrar().register((Object)this.name, (ServiceProviderListener)this);
    }

    @Override
    public CommandDispatcher<GroupMember, C> getCommandDispatcher() {
        return this.dispatcher;
    }

    @Override
    public ServiceProviderRegistration<ServiceName, GroupMember> getServiceProviderRegistration() {
        return this.registration;
    }

    public synchronized void start() {
        if (this.primary.compareAndSet(false, true)) {
            this.service.start();
        }
    }

    public synchronized void stop() {
        if (this.primary.compareAndSet(true, false)) {
            this.service.stop();
        }
    }

    public void elected(List<GroupMember> candidates, GroupMember elected) {
        try {
            this.electionListener.elected(candidates, elected);
        }
        catch (Throwable e) {
            SingletonLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    public SingletonState getSingletonState() {
        LinkedList<GroupMember> primaryMembers = new LinkedList<GroupMember>();
        try {
            final Map results = this.dispatcher.dispatchToGroup((Command)PrimaryProviderCommand.INSTANCE);
            Iterator entries = results.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                try {
                    if (!((Boolean)((CompletionStage)entry.getValue()).toCompletableFuture().join()).booleanValue()) continue;
                    primaryMembers.add((GroupMember)entry.getKey());
                }
                catch (CancellationException e) {
                    entries.remove();
                }
            }
            if (primaryMembers.size() > 1) {
                throw SingletonLogger.ROOT_LOGGER.multiplePrimaryProvidersDetected(this.name.getCanonicalName(), primaryMembers);
            }
            final GroupMember localMember = this.group.getLocalMember();
            final Optional<GroupMember> primaryMember = Optional.ofNullable((GroupMember)primaryMembers.peek());
            return new SingletonState(){

                public boolean isPrimaryProvider() {
                    return primaryMember.filter(localMember::equals).isPresent();
                }

                public Optional<GroupMember> getPrimaryProvider() {
                    return primaryMember;
                }

                public Set<GroupMember> getProviders() {
                    return Collections.unmodifiableSet(results.keySet());
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isPrimaryProvider() {
        return this.primary.get();
    }

    public synchronized void providersChanged(Set<GroupMember> providers) {
        ArrayList<GroupMember> candidates = new ArrayList<GroupMember>(this.group.getMembership().getMembers());
        candidates.retainAll(providers);
        if (candidates.isEmpty() || ((GroupMember)candidates.get(0)).equals(this.group.getLocalMember())) {
            boolean quorumMet;
            int size = candidates.size();
            boolean bl = quorumMet = size >= this.quorum;
            if (this.quorum > 1 && size == this.quorum) {
                SingletonLogger.ROOT_LOGGER.quorumJustReached(this.name.getCanonicalName(), this.quorum);
            }
            GroupMember elected = quorumMet ? this.electionPolicy.elect(candidates) : null;
            try {
                Throwable cause;
                if (elected != null) {
                    for (Map.Entry entry : this.dispatcher.dispatchToGroup((Command)StopCommand.INSTANCE, Set.of(elected)).entrySet()) {
                        try {
                            ((CompletionStage)entry.getValue()).toCompletableFuture().join();
                        }
                        catch (CancellationException e) {
                            SingletonLogger.ROOT_LOGGER.tracef("%s is not installed on %s", this.name, ((GroupMember)entry.getKey()).getName());
                        }
                        catch (CompletionException e) {
                            cause = e.getCause();
                            if (cause instanceof IllegalStateException && cause.getCause() instanceof ServiceNotFoundException) {
                                SingletonLogger.ROOT_LOGGER.debugf("%s is no longer installed on %s", this.name, ((GroupMember)entry.getKey()).getName());
                                continue;
                            }
                            throw e;
                        }
                    }
                    try {
                        this.dispatcher.dispatchToMember((Command)StartCommand.INSTANCE, elected).toCompletableFuture().join();
                    }
                    catch (CancellationException e) {
                        SingletonLogger.ROOT_LOGGER.debugf("%s could not be started on the elected primary singleton provider (%s) because it left the cluster.  A new primary provider election will take place.", this.name, elected.getName());
                    }
                    catch (CompletionException e) {
                        Throwable cause2 = e.getCause();
                        if (cause2 instanceof IllegalStateException && cause2.getCause() instanceof ServiceNotFoundException) {
                            SingletonLogger.ROOT_LOGGER.debugf("%s is no longer installed on the elected primary singleton provider (%s). A new primary provider election will take place.", this.name, elected.getName());
                        }
                        throw e;
                    }
                } else {
                    if (!quorumMet) {
                        SingletonLogger.ROOT_LOGGER.quorumNotReached(this.name.getCanonicalName(), this.quorum);
                    }
                    for (Map.Entry entry : this.dispatcher.dispatchToGroup((Command)StopCommand.INSTANCE).entrySet()) {
                        try {
                            ((CompletionStage)entry.getValue()).toCompletableFuture().join();
                        }
                        catch (CancellationException e) {
                            SingletonLogger.ROOT_LOGGER.tracef("%s is not installed on %s", this.name, ((GroupMember)entry.getKey()).getName());
                        }
                        catch (CompletionException e) {
                            cause = e.getCause();
                            if (cause instanceof IllegalStateException && cause.getCause() instanceof ServiceNotFoundException) {
                                SingletonLogger.ROOT_LOGGER.debugf("%s is no longer installed on %s", this.name, ((GroupMember)entry.getKey()).getName());
                                continue;
                            }
                            throw e;
                        }
                    }
                }
                if (this.electionListener != null) {
                    for (CompletionStage stage : this.dispatcher.dispatchToGroup((Command)new SingletonElectionCommand(candidates, elected)).values()) {
                        try {
                            stage.toCompletableFuture().join();
                        }
                        catch (CancellationException cancellationException) {}
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

