/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.server.DefaultSingletonServiceBuilderContext;
import org.wildfly.clustering.singleton.server.DistributedSingletonServiceBuilder;
import org.wildfly.clustering.singleton.server.LegacyDistributedSingletonService;
import org.wildfly.clustering.singleton.server.LegacySingletonServiceBuilder;
import org.wildfly.clustering.singleton.server.SingletonReference;
import org.wildfly.clustering.singleton.server.SingletonServiceContext;
import org.wildfly.clustering.singleton.server.SingletonServiceTargetContext;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;

public class DistributedSingletonServiceTarget
extends DelegatingServiceTarget
implements SingletonServiceTarget {
    private final SingletonServiceTargetContext context;
    private final Function<ServiceBuilder<?>, Consumer<Singleton>> singletonFactory;

    public DistributedSingletonServiceTarget(ServiceTarget target, SingletonServiceTargetContext context, Function<ServiceBuilder<?>, Consumer<Singleton>> singletonFactory) {
        super(target);
        this.context = context;
        this.singletonFactory = singletonFactory;
    }

    public SingletonServiceBuilder<?> addService() {
        return new DistributedSingletonServiceBuilder(this.getDelegate().addService(), ServiceTarget::addService, new DefaultSingletonServiceBuilderContext(this.context), this.singletonFactory);
    }

    @Deprecated
    public SingletonServiceBuilder<?> addService(ServiceName name) {
        return new DistributedSingletonServiceBuilder(this.getDelegate().addService(), target -> target.addService(name), new DefaultSingletonServiceBuilderContext(name, this.context), this.singletonFactory);
    }

    @Deprecated
    public <T> SingletonServiceBuilder<T> addService(ServiceName name, Service<T> service) {
        SingletonReference reference = new SingletonReference();
        DefaultSingletonServiceBuilderContext context = new DefaultSingletonServiceBuilderContext(name, this.context);
        LegacyDistributedSingletonService<T> singletonService = new LegacyDistributedSingletonService<T>((SingletonServiceContext)context, service, null, (Consumer<Singleton>)reference);
        return new LegacySingletonServiceBuilder(reference, context, this.getDelegate().addService(name, singletonService));
    }

    public SingletonServiceTarget subTarget() {
        return new DistributedSingletonServiceTarget(super.subTarget(), this.context, this.singletonFactory);
    }
}

