/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.wildfly.extension.metrics.Metric;
import org.wildfly.extension.metrics.MetricID;
import org.wildfly.extension.metrics.MetricMetadata;
import org.wildfly.extension.metrics.MetricRegistry;

public class WildFlyMetricRegistry
implements Closeable,
MetricRegistry {
    private Map<String, MetricMetadata> metadataMap = new HashMap<String, MetricMetadata>();
    private Map<MetricID, Metric> metricMap = new TreeMap<MetricID, Metric>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            this.metricMap.clear();
            this.metadataMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Map<MetricID, Metric> getMetrics() {
        return this.metricMap;
    }

    Map<String, MetricMetadata> getMetricMetadata() {
        return this.metadataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerMetric(Metric metric, MetricMetadata metadata) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(metric);
        this.lock.writeLock().lock();
        try {
            MetricID metricID = metadata.getMetricID();
            if (!this.metadataMap.containsKey(metadata.getMetricName())) {
                this.metadataMap.put(metadata.getMetricName(), metadata);
            }
            this.metricMap.put(metricID, metric);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void unregister(MetricID metricID) {
        this.lock.writeLock().lock();
        try {
            this.metricMap.remove(metricID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void unlock() {
        this.lock.readLock().unlock();
    }
}

