/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.ComponentResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ConnectionPoolResourceDefinition
extends ComponentResourceDefinition {
    public static final PathElement PATH = ConnectionPoolResourceDefinition.pathElement("connection-pool");
    static final UnaryServiceDescriptor<ConnectionPoolConfiguration> SERVICE_DESCRIPTOR = ConnectionPoolResourceDefinition.serviceDescriptor(PATH, ConnectionPoolConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();

    ConnectionPoolResourceDefinition() {
        super(PATH);
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(CAPABILITY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final ExhaustedAction exhaustedAction = ExhaustedAction.valueOf((String)Attribute.EXHAUSTED_ACTION.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final int maxActive = Attribute.MAX_ACTIVE.resolveModelAttribute((ExpressionResolver)context, model).asInt(-1);
        final long maxWait = Attribute.MAX_WAIT.resolveModelAttribute((ExpressionResolver)context, model).asLong(-1L);
        final long minEvictableIdleTime = Attribute.MIN_EVICTABLE_IDLE_TIME.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        final int minIdle = Attribute.MIN_IDLE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        Supplier<ConnectionPoolConfiguration> configurationFactory = new Supplier<ConnectionPoolConfiguration>(){

            @Override
            public ConnectionPoolConfiguration get() {
                return new ConfigurationBuilder().connectionPool().exhaustedAction(exhaustedAction).maxActive(maxActive).maxWait(maxWait).minEvictableIdleTime(minEvictableIdleTime).minIdle(minIdle).create();
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)configurationFactory).build();
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        EXHAUSTED_ACTION("exhausted-action", ModelType.STRING, new ModelNode(ExhaustedAction.WAIT.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)EnumValidator.create(ExhaustedAction.class));
            }
        }
        ,
        MAX_ACTIVE("max-active", ModelType.INT, null),
        MAX_WAIT("max-wait", ModelType.LONG, null),
        MIN_EVICTABLE_IDLE_TIME("min-evictable-idle-time", ModelType.LONG, new ModelNode(TimeUnit.MINUTES.toMillis(30L))),
        MIN_IDLE("min-idle", ModelType.INT, new ModelNode(1));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

