/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBMetaData;
import jakarta.ejb.EJBObject;
import java.io.Serializable;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.wildfly.common.Assert;

public abstract class AbstractEJBMetaData<T extends EJBObject, H extends EJBHome>
implements EJBMetaData,
Serializable {
    private static final long serialVersionUID = -5391231161942555933L;
    private final Class<T> remoteInterfaceClass;
    private final EJBHomeLocator<H> homeLocator;

    AbstractEJBMetaData(Class<T> remoteInterfaceClass, EJBHomeLocator<H> homeLocator) {
        Assert.checkNotNullParam((String)"remoteInterfaceClass", remoteInterfaceClass);
        Assert.checkNotNullParam((String)"homeLocator", homeLocator);
        this.remoteInterfaceClass = remoteInterfaceClass;
        this.homeLocator = homeLocator;
    }

    public H getEJBHome() {
        return (H)((EJBHome)EJBClient.createProxy(this.homeLocator));
    }

    public Class<T> getRemoteInterfaceClass() {
        return this.remoteInterfaceClass;
    }

    public Class<H> getHomeInterfaceClass() {
        return this.homeLocator.getViewType();
    }

    public Class<?> getPrimaryKeyClass() {
        throw Logs.MAIN.primaryKeyNotRelevantForSessionBeans();
    }

    public boolean isSession() {
        return true;
    }

    public boolean isStatelessSession() {
        return false;
    }

    public EJBHomeLocator<H> getHomeLocator() {
        return this.homeLocator;
    }
}

