/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;

final class Projections {
    private List<ProjectionSubscription> subscriptions = new ArrayList<ProjectionSubscription>();

    Projections() {
    }

    void addProjection(FilterSubscriptionImpl filterSubscription, int position) {
        this.subscriptions.add(new ProjectionSubscription(filterSubscription, position));
    }

    void removeProjections(FilterSubscriptionImpl filterSubscription) {
        Iterator<ProjectionSubscription> it = this.subscriptions.iterator();
        while (it.hasNext()) {
            ProjectionSubscription s = it.next();
            if (s.filterSubscription != filterSubscription) continue;
            it.remove();
        }
    }

    void processProjections(MatcherEvalContext<?, ?, ?> ctx, Object attributeValue) {
        for (int i = 0; i < this.subscriptions.size(); ++i) {
            ProjectionSubscription s = this.subscriptions.get(i);
            FilterEvalContext c = ctx.getFilterEvalContext(s.filterSubscription);
            c.processProjection(s.position, attributeValue);
        }
    }

    boolean hasProjections() {
        return !this.subscriptions.isEmpty();
    }

    private static class ProjectionSubscription {
        private final FilterSubscriptionImpl filterSubscription;
        private final int position;

        private ProjectionSubscription(FilterSubscriptionImpl filterSubscription, int position) {
            this.filterSubscription = filterSubscription;
            this.position = position;
        }
    }
}

