/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.logging.Handler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.handlers.HandlerOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractHandlerDefinition
extends SimpleResourceDefinition {
    public static final String UPDATE_OPERATION_NAME = "update-properties";
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    public static final PropertyAttributeDefinition FILTER_SPEC = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("filter-spec", ModelType.STRING, true).addAlternatives(new String[]{"filter"})).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setCapabilityReference(Capabilities.HANDLER_FILTER_REFERENCE_RECORDER)).build();
    public static final PropertyAttributeDefinition FORMATTER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("formatter", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"named-formatter"})).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                writer.writeStartElement(PatternFormatterResourceDefinition.PATTERN_FORMATTER.getXmlName());
                String pattern = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(PatternFormatterResourceDefinition.PATTERN.getXmlName(), pattern);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).setDefaultValue(new ModelNode("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n"))).build();
    public static final SimpleAttributeDefinition NAMED_FORMATTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"named-formatter", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setAlternatives(new String[]{"formatter"})).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(FORMATTER.getXmlName());
                writer.writeStartElement(attribute.getXmlName());
                String content = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(CommonAttributes.NAME.getName(), content);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).setCapabilityReference(Capabilities.HANDLER_FORMATTER_REFERENCE_RECORDER)).build();
    static final AttributeDefinition[] DEFAULT_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.LEVEL, CommonAttributes.ENABLED, CommonAttributes.ENCODING, FORMATTER, FILTER_SPEC};
    static final AttributeDefinition[] LEGACY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER};
    private final AttributeDefinition[] writableAttributes;
    private final AttributeDefinition[] readOnlyAttributes;
    private final boolean registerLegacyOps;

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes) {
        this(AbstractHandlerDefinition.createParameters(path, type, new ConfigurationProperty[0]), true, null, attributes);
    }

    protected AbstractHandlerDefinition(PathElement path, boolean registerLegacyOps, Class<? extends Handler> type, AttributeDefinition[] attributes) {
        this(AbstractHandlerDefinition.createParameters(path, type, new ConfigurationProperty[0]), registerLegacyOps, null, attributes);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
        this(AbstractHandlerDefinition.createParameters(path, type, constructionProperties), true, null, attributes);
    }

    protected AbstractHandlerDefinition(SimpleResourceDefinition.Parameters parameters, boolean registerLegacyOps, AttributeDefinition[] readOnlyAttributes, AttributeDefinition[] writableAttributes) {
        super(parameters);
        this.registerLegacyOps = registerLegacyOps;
        this.writableAttributes = writableAttributes;
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : this.writableAttributes) {
            if (def.getName().equals(CommonAttributes.FILTER.getName())) {
                resourceRegistration.registerReadWriteAttribute(def, (OperationStepHandler)LoggingOperations.ReadFilterOperationStepHandler.INSTANCE, HandlerOperations.LogHandlerWriteAttributeHandler.INSTANCE);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(def, null, HandlerOperations.LogHandlerWriteAttributeHandler.INSTANCE);
        }
        if (this.readOnlyAttributes != null) {
            for (AttributeDefinition def : this.readOnlyAttributes) {
                resourceRegistration.registerReadOnlyAttribute(def, null);
            }
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        if (this.registerLegacyOps) {
            ResourceDescriptionResolver resourceDescriptionResolver = this.getResourceDescriptionResolver();
            registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("enable", resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build(), (OperationStepHandler)HandlerOperations.ENABLE_HANDLER);
            registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("disable", resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build(), (OperationStepHandler)HandlerOperations.DISABLE_HANDLER);
            registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(CHANGE_LEVEL_OPERATION_NAME, resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.LEVEL}).build(), HandlerOperations.CHANGE_LEVEL);
            SimpleOperationDefinition updateProperties = new SimpleOperationDefinitionBuilder(UPDATE_OPERATION_NAME, resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(this.writableAttributes).build();
            registration.registerOperationHandler((OperationDefinition)updateProperties, (OperationStepHandler)new HandlerOperations.HandlerUpdateOperationStepHandler(this.writableAttributes));
        }
    }

    static SimpleResourceDefinition.Parameters createParameters(PathElement path, Class<? extends Handler> type, ConfigurationProperty<?> ... constructionProperties) {
        return new SimpleResourceDefinition.Parameters(path, LoggingExtension.getResourceDescriptionResolver(path.getKey())).setAddHandler((OperationStepHandler)new HandlerOperations.HandlerAddOperationStepHandler(type, constructionProperties)).setRemoveHandler(HandlerOperations.REMOVE_HANDLER).setCapabilities(new RuntimeCapability[]{Capabilities.HANDLER_CAPABILITY});
    }

    static class AbstractHandlerTransformerDefinition
    extends TransformerResourceDefinition {
        AbstractHandlerTransformerDefinition(PathElement pathElement) {
            super(pathElement);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
            if (modelVersion.hasTransformers()) {
                PathElement pathElement = this.getPathElement();
                ResourceTransformationDescriptionBuilder resourceBuilder = rootResourceBuilder.addChildResource(pathElement);
                ResourceTransformationDescriptionBuilder loggingProfileResourceBuilder = loggingProfileBuilder.addChildResource(pathElement);
                this.registerResourceTransformers(modelVersion, resourceBuilder, loggingProfileResourceBuilder);
            }
        }

        void registerResourceTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder resourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        }
    }
}

