/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;

public class CommandTimeoutHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (ctx, buffer, cursor, candidates) -> CommandTimeoutHandler.doComplete(ACTIONS, buffer, candidates), 0, "--action");
    private final ArgumentWithValue value;
    private static final List<String> ACTIONS = new ArrayList<String>();
    private static final List<String> VALUES = new ArrayList<String>();
    private static final String GET = "get";
    private static final String RESET = "reset";
    private static final String SET = "set";

    public CommandTimeoutHandler() {
        super("command-timeout");
        CommandLineCompleter valueCompleter = (ctx, buffer, cursor, candidates) -> {
            String act;
            try {
                if (!this.action.isPresent(ctx.getParsedCommandLine())) {
                    return -1;
                }
            }
            catch (CommandFormatException ex) {
                return -1;
            }
            switch (act = this.action.getValue(ctx.getParsedCommandLine())) {
                case "reset": {
                    return CommandTimeoutHandler.doComplete(VALUES, buffer, candidates);
                }
            }
            return -1;
        };
        this.value = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, 1, "--value");
        this.value.addRequiredPreceding(this.action);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        String act;
        if (!this.action.isPresent(ctx.getParsedCommandLine())) {
            throw new CommandLineException("No command-timeout action, must be one of " + ACTIONS);
        }
        switch (act = this.action.getValue(ctx.getParsedCommandLine())) {
            case "get": {
                ctx.printLine("" + ctx.getCommandTimeout());
                break;
            }
            case "set": {
                if (!this.value.isPresent(ctx.getParsedCommandLine())) {
                    throw new CommandLineException("No value to set");
                }
                try {
                    ctx.setCommandTimeout(Integer.parseInt(this.value.getValue(ctx.getParsedCommandLine())));
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new CommandLineException("Invalid command timeout value " + this.value.getValue(ctx.getParsedCommandLine()));
                }
            }
            case "reset": {
                if (!this.value.isPresent(ctx.getParsedCommandLine())) {
                    throw new CommandLineException("No reset value");
                }
                String v = this.value.getValue(ctx.getParsedCommandLine());
                CommandContext.TIMEOUT_RESET_VALUE resetValue = Enum.valueOf(CommandContext.TIMEOUT_RESET_VALUE.class, v.toUpperCase(Locale.ENGLISH));
                ctx.resetTimeout(resetValue);
                break;
            }
            default: {
                throw new CommandLineException("Unknown command-timeout action, must be one of " + ACTIONS);
            }
        }
    }

    private static int doComplete(List<String> values, String buffer, List<String> candidates) {
        if (buffer == null || buffer.isEmpty()) {
            candidates.addAll(values);
        } else {
            for (String v : values) {
                if (v.equals(buffer)) {
                    candidates.add(v + " ");
                    break;
                }
                if (!v.startsWith(buffer)) continue;
                candidates.add(v);
            }
        }
        return 0;
    }

    static {
        ACTIONS.add(GET);
        ACTIONS.add(RESET);
        ACTIONS.add(SET);
        for (CommandContext.TIMEOUT_RESET_VALUE tr : CommandContext.TIMEOUT_RESET_VALUE.values()) {
            VALUES.add(tr.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

