/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanThreadInfosHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-thread-infos", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.IDS, CommonAttributes.MAX_DEPTH, CommonAttributes.LOCKED_MONITORS_FLAG, CommonAttributes.LOCKED_SYNCHRONIZERS_FLAG}).setReplyType(ModelType.LIST).setReplyParameters(CommonAttributes.THREAD_INFO_ATTRIBUTES).setReadOnly().setRuntimeOnly().build();
    public static final ThreadMXBeanThreadInfosHandler INSTANCE = new ThreadMXBeanThreadInfosHandler();
    private final ParametersValidator idsValidator = new ParametersValidator();
    private final ParametersValidator depthValidator = new ParametersValidator();
    private final ParametersValidator lockedValidator = new ParametersValidator();

    private ThreadMXBeanThreadInfosHandler() {
        this.idsValidator.registerValidator("ids", (ParameterValidator)new ListValidator(LongRangeValidator.POSITIVE));
        this.depthValidator.registerValidator("max-depth", (ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, false, false));
        this.lockedValidator.registerValidator("locked-monitors", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.lockedValidator.registerValidator("locked-synchronizers", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            ThreadInfo[] infos;
            long[] ids = this.getIds(operation);
            ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
            if (operation.hasDefined("locked-monitors")) {
                this.lockedValidator.validate(operation);
                infos = mbean.getThreadInfo(ids, operation.require("locked-monitors").asBoolean(), operation.require("locked-synchronizers").asBoolean());
            } else if (operation.hasDefined("max-depth")) {
                this.depthValidator.validate(operation);
                infos = mbean.getThreadInfo(ids, operation.require("max-depth").asInt());
            } else {
                infos = mbean.getThreadInfo(ids);
            }
            ModelNode result = context.getResult();
            if (infos != null) {
                result.setEmptyList();
                for (ThreadInfo info : infos) {
                    if (info != null) {
                        result.add(PlatformMBeanUtil.getDetypedThreadInfo(info, mbean.isThreadCpuTimeSupported()));
                        continue;
                    }
                    result.add();
                }
            }
        }
        catch (SecurityException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    private long[] getIds(ModelNode operation) throws OperationFailedException {
        this.idsValidator.validate(operation);
        List idNodes = operation.require("ids").asList();
        long[] ids = new long[idNodes.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((ModelNode)idNodes.get(i)).asLong();
        }
        return ids;
    }
}

