/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public enum CacheServiceInstallerFactory implements Function<BinaryServiceConfiguration, ServiceInstaller>
{
    INSTANCE;


    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency container = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        final String cacheName = configuration.getChildName();
        Supplier cache = new Supplier<Cache<?, ?>>(){

            @Override
            public Cache<?, ?> get() {
                return ((EmbeddedCacheManager)container.get()).getCache(cacheName);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(ManagedCache::new, (Supplier)cache).blocking()).provides(configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE))).requires(List.of(container, configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION)))).onStart(Lifecycle::start)).onStop(Cache::stop)).build();
    }

    private static class ManagedCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        ManagedCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        private ManagedCache(AdvancedCache<K, V> cache) {
            super(cache.getAdvancedCache());
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new ManagedCache<K, V>(delegate);
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

