/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.spec.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import org.wildfly.clustering.session.ImmutableSession;

public abstract class AbstractHttpSession
implements HttpSession {
    private final ImmutableSession session;
    private final ServletContext context;

    protected AbstractHttpSession(ImmutableSession session, ServletContext context) {
        this.session = session;
        this.context = context;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getId() {
        return this.session.getId();
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().toEpochMilli();
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getTimeout().getSeconds();
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessTime().toEpochMilli();
    }

    public boolean isNew() {
        return this.session.getMetaData().isNew();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.session.getAttributes().keySet());
    }

    public Object getAttribute(String name) {
        return this.session.getAttributes().get(name);
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractHttpSession)) {
            return false;
        }
        AbstractHttpSession session = (AbstractHttpSession)object;
        return Objects.equals(this.session, session.session);
    }

    public String toString() {
        return this.session.toString();
    }
}

