/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.EnumSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.dmr.ModelNode;

public class ServerDomainProcessShutdownHandler
implements OperationStepHandler {
    public static final AtomicReference<CompletionStage<Void>> SUSPEND_STAGE = new AtomicReference();
    public static final SimpleOperationDefinition DOMAIN_DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setParameters(new AttributeDefinition[]{ServerRootResourceDefinition.TIMEOUT, ServerRootResourceDefinition.SUSPEND_TIMEOUT}).setPrivateEntry().withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY, OperationEntry.Flag.RUNTIME_ONLY}).build();
    private final ServerSuspendController suspendController;

    public ServerDomainProcessShutdownHandler(ServerSuspendController suspendController) {
        this.suspendController = suspendController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        ServerRootResourceDefinition.renameTimeoutToSuspendTimeout(operation);
        final int seconds = ServerRootResourceDefinition.SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            ServerLogger.ROOT_LOGGER.suspendingServer(seconds, TimeUnit.SECONDS);
                            CompletionStage<Void> suspend = ServerDomainProcessShutdownHandler.this.suspendController.suspend(ServerSuspendController.Context.SHUTDOWN);
                            SUSPEND_STAGE.set(seconds >= 0 ? suspend.toCompletableFuture().completeOnTimeout(null, seconds, TimeUnit.SECONDS) : suspend);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

