/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerShutdownHandler
implements OperationStepHandler {
    protected static final SimpleAttributeDefinition RESTART = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("restart", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setAlternatives(new String[]{"perform-installation"})).setRequired(false)).build();
    protected static final SimpleAttributeDefinition PERFORM_INSTALLATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("perform-installation", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setAlternatives(new String[]{"restart"})).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", ServerDescriptions.getResourceDescriptionResolver("server")).setParameters(new AttributeDefinition[]{RESTART, ServerRootResourceDefinition.TIMEOUT, ServerRootResourceDefinition.SUSPEND_TIMEOUT, PERFORM_INSTALLATION}).setRuntimeOnly().build();
    private final ControlledProcessState processState;
    private final ServerEnvironment environment;
    private final ServerSuspendController suspendController;

    public ServerShutdownHandler(ControlledProcessState processState, ServerEnvironment serverEnvironment, ServerSuspendController suspendController) {
        this.processState = processState;
        this.environment = serverEnvironment;
        this.suspendController = suspendController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServerRootResourceDefinition.renameTimeoutToSuspendTimeout(operation);
        final boolean restart = RESTART.resolveModelAttribute(context, operation).asBoolean();
        final int seconds = ServerRootResourceDefinition.SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
        final boolean performInstallation = PERFORM_INSTALLATION.resolveModelAttribute(context, operation).asBoolean();
        if (performInstallation) {
            String productName = this.environment.getProductConfig().getProductName();
            try (FileInputStream in = new FileInputStream(this.environment.getHomeDir().toPath().resolve("bin").resolve("installation-manager.properties").toFile());){
                Properties prop = new Properties();
                prop.load(in);
                String current = (String)prop.get("INST_MGR_STATUS");
                if (current == null || !current.trim().equals("PREPARED")) {
                    throw ServerLogger.ROOT_LOGGER.noServerInstallationPrepared(productName);
                }
            }
            catch (Exception e) {
                throw ServerLogger.ROOT_LOGGER.noServerInstallationPrepared(productName);
            }
            Path cliMarker = this.environment.getHomeDir().toPath().resolve("bin").resolve("cli-marker");
            try (BufferedReader reader = new BufferedReader(new FileReader(cliMarker.toFile()));){
                String line = reader.readLine();
                if (line != null) {
                    context.getResult().set("cli-marker-value", line);
                }
            }
            catch (Exception e) {
                ServerLogger.ROOT_LOGGER.debug("Shutdown will not return a file marker due to an exception that has been explicitly ignored.", e);
            }
        }
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                AuthorizationResult authorizationResult = context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                    throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")), authorizationResult.getExplanation());
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            ShutdownAction shutdown = new ShutdownAction(ServerShutdownHandler.getOperationName(operation), restart, performInstallation);
                            ServerSuspendController suspendController = ServerShutdownHandler.this.suspendController;
                            ServerLogger.ROOT_LOGGER.suspendingServer(seconds, TimeUnit.SECONDS);
                            CompletableFuture<Void> suspend = suspendController.suspend(ServerSuspendController.Context.SHUTDOWN).toCompletableFuture();
                            if (seconds >= 0) {
                                suspend.completeOnTimeout(null, seconds, TimeUnit.SECONDS);
                            }
                            try {
                                suspend.join();
                                shutdown.shutdown();
                            }
                            catch (CancellationException e) {
                                shutdown.cancel();
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static String getOperationName(ModelNode op) {
        return op.hasDefined("operation") ? op.get("operation").asString() : "shutdown";
    }

    private final class ShutdownAction
    extends AtomicBoolean {
        private final String op;
        private final boolean restart;
        private final boolean performInstallation;

        private ShutdownAction(String op, boolean restart, boolean performInstallation) {
            this.op = op;
            this.restart = restart;
            this.performInstallation = performInstallation;
        }

        void cancel() {
            this.compareAndSet(false, true);
        }

        void shutdown() {
            if (this.compareAndSet(false, true)) {
                ServerShutdownHandler.this.processState.setStopping();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int exitCode = ShutdownAction.this.restart ? 10 : (ShutdownAction.this.performInstallation ? 20 : 0);
                        SystemExiter.logAndExit(new SystemExiter.ExitLogger(){

                            @Override
                            public void logExit() {
                                ServerLogger.ROOT_LOGGER.shuttingDownInResponseToManagementRequest(ShutdownAction.this.op);
                            }
                        }, exitCode);
                    }
                });
                thread.setName("Management Triggered Shutdown");
                thread.start();
            }
        }
    }
}

