/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.executor;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.executor.RuntimeOperation;
import org.wildfly.subsystem.resource.executor.RuntimeOperationExecutor;

public class RuntimeOperationStepHandler<C>
extends AbstractRuntimeOnlyHandler
implements ManagementResourceRegistrar {
    private final Map<String, RuntimeOperation<C>> operations = new HashMap<String, RuntimeOperation<C>>();
    private final RuntimeOperationExecutor<C> executor;

    public <E extends Enum<E>> RuntimeOperationStepHandler(RuntimeOperationExecutor<C> executor, Class<E> operationClass) {
        this(executor, EnumSet.allOf(operationClass));
    }

    public RuntimeOperationStepHandler(RuntimeOperationExecutor<C> executor, Iterable<? extends RuntimeOperation<C>> operations) {
        this.executor = executor;
        for (RuntimeOperation<C> executable : operations) {
            this.operations.put(executable.getName(), executable);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (RuntimeOperation<C> operation : this.operations.values()) {
            registration.registerOperationHandler(operation.getOperationDefinition(), (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        String name = operation.get("operation").asString();
        RuntimeOperation<C> executable = this.operations.get(name);
        try {
            ModelNode result = this.executor.execute(context, operation, executable);
            if (result != null) {
                context.getResult().set(result);
            }
        }
        catch (OperationFailedException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

