/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPEntityIDRequestURLBuilder
implements Function<CriteriaSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPEntityIDRequestURLBuilder.class);

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        Constraint.isNotNull((Object)criteria, (String)"Criteria was null");
        if (!criteria.contains(EntityIdCriterion.class)) {
            this.log.trace("Criteria did not contain entity ID, unable to build request URL");
            return null;
        }
        String entityID = ((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId();
        Constraint.isNotNull((Object)entityID, (String)"Entity ID was null");
        if (entityID.toLowerCase().startsWith("http:") || entityID.toLowerCase().startsWith("https:")) {
            this.log.debug("Saw entityID with HTTP/HTTPS URL syntax, returning the entityID itself as request URL");
            return entityID;
        }
        this.log.debug("EntityID was not an HTTP or HTTPS URL, could not construct request URL on that basis");
        return null;
    }
}

