/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;

public class EarMessageDestinationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            EarMetaData metadata = (EarMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA);
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            if (metadata != null && metadata.getEarEnvironmentRefsGroup() != null && metadata.getEarEnvironmentRefsGroup().getMessageDestinations() != null) {
                for (MessageDestinationMetaData destination : metadata.getEarEnvironmentRefsGroup().getMessageDestinations()) {
                    if (destination.getJndiName() != null) {
                        eeModuleDescription.addMessageDestination(destination.getName(), destination.getJndiName());
                        continue;
                    }
                    if (destination.getLookupName() == null) continue;
                    eeModuleDescription.addMessageDestination(destination.getName(), destination.getLookupName());
                }
            }
        }
    }
}

