/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.InterceptorChainFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.async.AsyncNonBlockingStore;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceStatus;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.StoreUnavailableException;
import org.infinispan.persistence.support.DelegatingNonBlockingStore;
import org.infinispan.persistence.support.NonBlockingStoreAdapter;
import org.infinispan.persistence.support.SegmentPublisherWrapper;
import org.infinispan.persistence.support.SingleSegmentPublisher;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.function.TriPredicate;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    Configuration configuration;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    ComponentRef<AdvancedCache<Object, Object>> cache;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    TimeService timeService;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    PersistenceMarshaller persistenceMarshaller;
    @Inject
    ByteBufferFactory byteBufferFactory;
    @Inject
    CacheNotifier<Object, Object> cacheNotifier;
    @Inject
    InternalEntryFactory internalEntryFactory;
    @Inject
    MarshallableEntryFactory<?, ?> marshallableEntryFactory;
    @ComponentName(value="org.infinispan.executors.non-blocking")
    @Inject
    Executor nonBlockingExecutor;
    @Inject
    BlockingManager blockingManager;
    @Inject
    NonBlockingManager nonBlockingManager;
    @Inject
    ComponentRef<InternalExpirationManager<Object, Object>> expirationManager;
    @Inject
    DistributionManager distributionManager;
    @Inject
    InterceptorChainFactory interceptorChainFactory;
    private final StampedLock lock = new StampedLock();
    private volatile boolean enabled;
    private volatile boolean clearOnStop;
    private volatile AutoCloseable availabilityTask;
    private volatile String unavailableExceptionMessage;
    private boolean isInvalidationCache;
    private boolean allSegmentedOrShared;
    private int segmentCount;
    @GuardedBy(value="lock")
    private List<StoreStatus> stores = null;
    private final List<PersistenceManager.StoreChangeListener> listeners = new CopyOnWriteArrayList<PersistenceManager.StoreChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> NonBlockingStore<K, V> getStore(Predicate<StoreStatus> predicate) {
        long stamp = this.lock.tryOptimisticRead();
        NonBlockingStore<K, V> store = this.getStoreLocked(predicate);
        if (!this.lock.validate(stamp)) {
            stamp = this.acquireReadLock();
            try {
                store = this.getStoreLocked(predicate);
            }
            finally {
                this.releaseReadLock(stamp);
            }
        }
        return store;
    }

    @GuardedBy(value="lock#readLock")
    private <K, V> NonBlockingStore<K, V> getStoreLocked(Predicate<StoreStatus> predicate) {
        if (this.stores == null) {
            return null;
        }
        for (StoreStatus storeStatus : this.stores) {
            if (!predicate.test(storeStatus)) continue;
            return storeStatus.store();
        }
        return null;
    }

    @GuardedBy(value="lock#readLock")
    private StoreStatus getStoreStatusLocked(Predicate<? super StoreStatus> predicate) {
        for (StoreStatus storeStatus : this.stores) {
            if (!predicate.test(storeStatus)) continue;
            return storeStatus;
        }
        return null;
    }

    @Start
    public void start() {
        this.enabled = this.configuration.persistence().usingStores();
        this.segmentCount = this.configuration.clustering().hash().numSegments();
        this.isInvalidationCache = this.configuration.clustering().cacheMode().isInvalidation();
        if (!this.enabled) {
            return;
        }
        Completable.using(this::acquireWriteLock, __ -> this.startManagerAndStores(this.configuration.persistence().stores()), this::releaseWriteLock).blockingAwait();
    }

    @GuardedBy(value="lock#writeLock")
    private Completable startManagerAndStores(Collection<StoreConfiguration> storeConfigurations) {
        if (storeConfigurations.isEmpty()) {
            throw new IllegalArgumentException("Store configurations require at least one configuration");
        }
        this.enabled = true;
        if (this.stores == null) {
            this.stores = new ArrayList<StoreStatus>(storeConfigurations.size());
        }
        Completable storeStartup = this.startStoresOnly(storeConfigurations);
        long interval = this.configuration.persistence().availabilityInterval();
        if (interval > 0L && this.availabilityTask == null) {
            storeStartup = storeStartup.doOnComplete(() -> {
                this.availabilityTask = this.nonBlockingManager.scheduleWithFixedDelay(this::pollStoreAvailability, interval, interval, TimeUnit.MILLISECONDS, t -> !(t instanceof Error));
            });
        }
        return storeStartup.doOnComplete(() -> {
            boolean hasLifespan;
            boolean hasMaxIdle = this.configuration.expiration().maxIdle() > 0L;
            boolean bl = hasLifespan = this.configuration.expiration().lifespan() > 0L;
            if (hasLifespan || hasMaxIdle) {
                this.stores.stream().forEach(status -> {
                    if (status.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY)) {
                        return;
                    }
                    if (hasMaxIdle) {
                        if (!this.configuration.persistence().passivation()) {
                            throw Log.CONFIG.maxIdleNotAllowedWithoutPassivation();
                        }
                        Log.CONFIG.maxIdleNotTestedWithPassivation();
                    }
                    if (!status.hasCharacteristic(NonBlockingStore.Characteristic.EXPIRATION)) {
                        throw Log.CONFIG.expirationNotAllowedWhenStoreDoesNotSupport(status.store.getClass().getName());
                    }
                });
            }
            this.allSegmentedOrShared = this.allStoresSegmentedOrShared();
        });
    }

    private Completable startStoresOnly(Iterable<StoreConfiguration> storeConfigurations) {
        return Flowable.fromIterable(storeConfigurations).concatMapSingle(storeConfiguration -> {
            NonBlockingStore actualStore = PersistenceUtil.storeFromConfiguration(storeConfiguration);
            NonBlockingStore nonBlockingStore = storeConfiguration.async().enabled() ? new AsyncNonBlockingStore(actualStore) : actualStore;
            InitializationContextImpl ctx = new InitializationContextImpl((StoreConfiguration)storeConfiguration, this.cache.wired(), this.keyPartitioner, this.persistenceMarshaller, this.timeService, this.byteBufferFactory, this.marshallableEntryFactory, this.nonBlockingExecutor, this.globalConfiguration, this.blockingManager, this.nonBlockingManager);
            CompletionStage<Void> stage = nonBlockingStore.start(ctx).whenComplete((ignore, t) -> {
                if (t != null) {
                    this.stores.add(new StoreStatus(nonBlockingStore, null, null));
                }
            });
            return Completable.fromCompletionStage(stage).toSingle(() -> new StoreStatus(nonBlockingStore, (StoreConfiguration)storeConfiguration, this.updateCharacteristics(nonBlockingStore, nonBlockingStore.characteristics(), (StoreConfiguration)storeConfiguration)));
        }).doOnNext(this.stores::add).delay(status -> {
            if (!this.configuration.clustering().cacheMode().needsStateTransfer() && status.config.purgeOnStartup()) {
                return Flowable.fromCompletable((CompletableSource)Completable.fromCompletionStage(status.store.clear()));
            }
            return Flowable.empty();
        }).ignoreElements();
    }

    @GuardedBy(value="lock")
    private boolean allStoresSegmentedOrShared() {
        return this.getStoreLocked(storeStatus -> !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SEGMENTABLE) || !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SHAREABLE)) != null;
    }

    private Set<NonBlockingStore.Characteristic> updateCharacteristics(NonBlockingStore<?, ?> store, Set<NonBlockingStore.Characteristic> characteristics, StoreConfiguration storeConfiguration) {
        if (storeConfiguration.ignoreModifications()) {
            if (characteristics.contains((Object)NonBlockingStore.Characteristic.WRITE_ONLY)) {
                throw log.storeConfiguredHasBothReadAndWriteOnly(store.getClass().getName(), NonBlockingStore.Characteristic.WRITE_ONLY, NonBlockingStore.Characteristic.READ_ONLY);
            }
            characteristics.add(NonBlockingStore.Characteristic.READ_ONLY);
            characteristics.remove((Object)NonBlockingStore.Characteristic.TRANSACTIONAL);
        }
        if (storeConfiguration.writeOnly()) {
            if (characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY)) {
                throw log.storeConfiguredHasBothReadAndWriteOnly(store.getClass().getName(), NonBlockingStore.Characteristic.READ_ONLY, NonBlockingStore.Characteristic.WRITE_ONLY);
            }
            characteristics.add(NonBlockingStore.Characteristic.WRITE_ONLY);
            characteristics.remove((Object)NonBlockingStore.Characteristic.BULK_READ);
        }
        if (storeConfiguration.segmented()) {
            if (!characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE)) {
                throw log.storeConfiguredSegmentedButCharacteristicNotPresent(store.getClass().getName());
            }
        } else {
            characteristics.remove((Object)NonBlockingStore.Characteristic.SEGMENTABLE);
        }
        if (storeConfiguration.transactional()) {
            if (!characteristics.contains((Object)NonBlockingStore.Characteristic.TRANSACTIONAL)) {
                throw log.storeConfiguredTransactionalButCharacteristicNotPresent(store.getClass().getName());
            }
        } else {
            characteristics.remove((Object)NonBlockingStore.Characteristic.TRANSACTIONAL);
        }
        if (storeConfiguration.shared()) {
            if (!characteristics.contains((Object)NonBlockingStore.Characteristic.SHAREABLE)) {
                throw log.storeConfiguredSharedButCharacteristicNotPresent(store.getClass().getName());
            }
        } else {
            characteristics.remove((Object)NonBlockingStore.Characteristic.SHAREABLE);
        }
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStage<Void> pollStoreAvailability() {
        if (log.isTraceEnabled()) {
            log.trace("Polling Store availability");
        }
        AtomicReference firstUnavailableStore = new AtomicReference();
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Void> completionStage;
            AggregateCompletionStage<Void> stageBuilder = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                CompletionStage availableStage;
                try {
                    availableStage = storeStatus.store.isAvailable();
                }
                catch (Throwable t) {
                    log.storeIsAvailableCheckThrewException(t, storeStatus.store.getClass().getName());
                    availableStage = CompletableFutures.booleanStage((boolean)false);
                }
                availableStage = availableStage.exceptionally(throwable -> {
                    log.storeIsAvailableCompletedExceptionally((Throwable)throwable, storeStatus.store.getClass().getName());
                    return false;
                });
                stageBuilder.dependsOn(availableStage.thenCompose(isAvailable -> {
                    storeStatus.availability = isAvailable;
                    if (!isAvailable.booleanValue()) {
                        firstUnavailableStore.compareAndSet(null, storeStatus.store);
                        return this.updatePersistenceAvailability(storeStatus.store);
                    }
                    return CompletableFutures.completedNull();
                }));
            }
            CompletionStage<Void> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = this.updatePersistenceAvailability((NonBlockingStore)firstUnavailableStore.get());
                return completionStage;
            }
            release = false;
            completionStage = stage.thenCompose(__ -> this.updatePersistenceAvailability((NonBlockingStore)firstUnavailableStore.get())).whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    private CompletionStage<Void> updatePersistenceAvailability(NonBlockingStore<?, ?> unavailableStore) {
        if (unavailableStore != null) {
            if (this.unavailableExceptionMessage == null) {
                log.persistenceUnavailable(unavailableStore.getClass().getName());
                this.unavailableExceptionMessage = "Store " + String.valueOf(unavailableStore) + " is unavailable";
                return this.cacheNotifier.notifyPersistenceAvailabilityChanged(false);
            }
        } else if (this.unavailableExceptionMessage != null) {
            log.persistenceAvailable();
            this.unavailableExceptionMessage = null;
            return this.cacheNotifier.notifyPersistenceAvailabilityChanged(true);
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop
    public void stop() {
        AggregateCompletionStage<Void> allStage = CompletionStages.aggregateCompletionStage();
        long stamp = this.acquireWriteLock();
        try {
            this.stopAvailabilityTask();
            if (this.stores == null) {
                return;
            }
            for (StoreStatus storeStatus : this.stores) {
                NonBlockingStore store = storeStatus.store();
                CompletionStage<Void> storeStage = this.clearOnStop && !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) ? store.clear().thenCompose(__ -> store.stop()) : store.stop();
                allStage.dependsOn(storeStage);
            }
            this.stores = null;
        }
        finally {
            this.releaseWriteLock(stamp);
        }
        CompletionStages.join(allStage.freeze());
    }

    private void stopAvailabilityTask() {
        AutoCloseable taskToClose = this.availabilityTask;
        if (taskToClose != null) {
            try {
                taskToClose.close();
            }
            catch (Exception e) {
                log.warn("There was a problem stopping availability task", e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isReadOnly() {
        return this.getStore(storeStatus -> !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY)) == null;
    }

    @Override
    public boolean hasWriter() {
        return this.getStore(storeStatus -> !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY)) != null;
    }

    @Override
    public boolean hasStore(Predicate<StoreConfiguration> test) {
        return this.getStore(storeStatus -> test.test(storeStatus.config)) != null;
    }

    @Override
    public Flowable<MarshallableEntry<Object, Object>> preloadPublisher() {
        long stamp = this.acquireReadLock();
        NonBlockingStore nonBlockingStore = this.getStoreLocked(status -> status.config.preload());
        if (nonBlockingStore == null) {
            this.releaseReadLock(stamp);
            return Flowable.empty();
        }
        Publisher publisher = nonBlockingStore.publishEntries(IntSets.immutableRangeSet((int)this.segmentCount), null, true);
        return Flowable.fromPublisher(publisher).doFinally(() -> this.releaseReadLock(stamp));
    }

    @Override
    public void addStoreListener(PersistenceManager.StoreChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeStoreListener(PersistenceManager.StoreChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public CompletionStage<Void> addStore(StoreConfiguration storeConfiguration) {
        return Single.fromCompletionStage((CompletionStage)this.cache.wired().sizeAsync()).doOnSuccess(l -> {
            if (l > 0L) {
                throw log.cannotAddStore(this.cache.wired().getName());
            }
        }).concatMapCompletable(v -> Completable.using(this::acquireWriteLock, lock -> this.startManagerAndStores(Collections.singletonList(storeConfiguration)).doOnComplete(() -> {
            AsyncInterceptorChain chain = this.cache.wired().getAsyncInterceptorChain();
            this.interceptorChainFactory.addPersistenceInterceptors(chain, this.configuration, Collections.singletonList(storeConfiguration));
            this.listeners.forEach(l -> l.storeChanged(this.createStatus()));
        }), this::releaseWriteLock)).toCompletionStage(null);
    }

    private PersistenceStatus createStatus() {
        boolean usingSharedStore = false;
        boolean usingSharedAsync = false;
        boolean usingSegments = false;
        boolean usingAsync = false;
        boolean usingReadOnly = false;
        boolean usingTransactionalStore = false;
        for (StoreStatus storeStatus : this.stores) {
            if (storeStatus.config.shared()) {
                usingSharedStore = true;
            }
            if (storeStatus.config.async().enabled()) {
                usingSharedAsync |= storeStatus.config.shared();
                usingAsync = true;
            }
            if (storeStatus.config.segmented()) {
                usingSegments = true;
            }
            if (storeStatus.config.ignoreModifications()) {
                usingReadOnly = true;
            }
            if (!storeStatus.config.transactional()) continue;
            usingTransactionalStore = true;
        }
        return new PersistenceStatus(this.enabled, usingSegments, usingAsync, usingSharedStore, usingSharedAsync, usingReadOnly, usingTransactionalStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> disableStore(String storeType) {
        boolean stillHasAStore = false;
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        long stamp = this.lock.writeLock();
        try {
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            boolean allAvailable = true;
            Iterator<StoreStatus> statusIterator = this.stores.iterator();
            while (statusIterator.hasNext()) {
                StoreStatus status = statusIterator.next();
                NonBlockingStore nonBlockingStore = this.unwrapStore(status.store());
                if (nonBlockingStore.getClass().getName().equals(storeType) || this.containedInAdapter(nonBlockingStore, storeType)) {
                    statusIterator.remove();
                    aggregateCompletionStage.dependsOn(nonBlockingStore.stop().whenComplete((v, t) -> {
                        if (t != null) {
                            log.warn("There was an error stopping the store", (Throwable)t);
                        }
                    }));
                    continue;
                }
                stillHasAStore = true;
                allAvailable = allAvailable && status.availability;
            }
            if (!stillHasAStore) {
                this.unavailableExceptionMessage = null;
                this.enabled = false;
                this.stopAvailabilityTask();
            } else if (allAvailable) {
                this.unavailableExceptionMessage = null;
            }
            this.allSegmentedOrShared = this.allStoresSegmentedOrShared();
            this.listeners.forEach(l -> l.storeChanged(this.createStatus()));
            if (!stillHasAStore) {
                AsyncInterceptorChain chain = this.cache.wired().getAsyncInterceptorChain();
                CacheLoaderInterceptor loaderInterceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
                if (loaderInterceptor == null) {
                    Log.PERSISTENCE.persistenceWithoutCacheLoaderInterceptor();
                } else {
                    chain.removeInterceptor(loaderInterceptor.getClass());
                }
                DDAsyncInterceptor writerInterceptor = chain.findInterceptorExtending(CacheWriterInterceptor.class);
                if (writerInterceptor == null) {
                    writerInterceptor = chain.findInterceptorWithClass(TransactionalStoreInterceptor.class);
                    if (writerInterceptor == null) {
                        Log.PERSISTENCE.persistenceWithoutCacheWriteInterceptor();
                    } else {
                        chain.removeInterceptor(writerInterceptor.getClass());
                    }
                } else {
                    chain.removeInterceptor(writerInterceptor.getClass());
                }
            }
            CompletionStage<Void> completionStage = aggregateCompletionStage.freeze();
            return completionStage;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private <K, V> NonBlockingStore<K, V> unwrapStore(NonBlockingStore<K, V> store) {
        if (store instanceof DelegatingNonBlockingStore) {
            return ((DelegatingNonBlockingStore)store).delegate();
        }
        return store;
    }

    private Object unwrapOldSPI(NonBlockingStore<?, ?> store) {
        if (store instanceof NonBlockingStoreAdapter) {
            return ((NonBlockingStoreAdapter)store).getActualStore();
        }
        return store;
    }

    private boolean containedInAdapter(NonBlockingStore<?, ?> nonBlockingStore, String adaptedClassName) {
        return nonBlockingStore instanceof NonBlockingStoreAdapter && ((NonBlockingStoreAdapter)nonBlockingStore).getActualStore().getClass().getName().equals(adaptedClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        long stamp = this.acquireReadLock();
        try {
            if (!this.checkStoreAvailability()) {
                Set set = Collections.emptySet();
                return set;
            }
            Set set = this.stores.stream().map(StoreStatus::store).map(this::unwrapStore).map(this::unwrapOldSPI).filter(storeClass::isInstance).map(storeClass::cast).collect(Collectors.toCollection(HashSet::new));
            return set;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStoresAsString() {
        long stamp = this.acquireReadLock();
        try {
            if (!this.checkStoreAvailability()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection collection = this.stores.stream().map(StoreStatus::store).map(this::unwrapStore).map(this::unwrapOldSPI).map(c -> c.getClass().getName()).collect(Collectors.toCollection(ArrayList::new));
            return collection;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    @Override
    public CompletionStage<Void> purgeExpired() {
        long stamp = this.acquireReadLock();
        try {
            if (!this.checkStoreAvailability()) {
                this.releaseReadLock(stamp);
                return CompletableFutures.completedNull();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Purging entries from stores on cache %s", this.cache.getName());
            }
            AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (!storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.EXPIRATION)) continue;
                Flowable flowable = Flowable.fromPublisher(storeStatus.store().purgeExpired());
                Completable completable = flowable.concatMapCompletable(me -> Completable.fromCompletionStage(this.expirationManager.running().handleInStoreExpirationInternal((MarshallableEntry<Object, Object>)me)));
                aggregateCompletionStage.dependsOn(completable.toCompletionStage(null));
            }
            return aggregateCompletionStage.freeze().whenComplete((v, t) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t2) {
            this.releaseReadLock(stamp);
            throw t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> clearAllStores(Predicate<? super StoreConfiguration> predicate) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Void> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Clearing all stores", new Object[0]);
            }
            AggregateCompletionStage<Void> stageBuilder = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) || !predicate.test(storeStatus.config)) continue;
                stageBuilder.dependsOn(storeStatus.store.clear());
            }
            CompletionStage<Void> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Boolean> deleteFromAllStores(Object key, int segment, Predicate<? super StoreConfiguration> predicate) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Boolean> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedFalse();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Deleting entry for key %s from stores", key);
            }
            if (this.stores.isEmpty()) {
                CompletableFuture completableFuture = CompletableFutures.completedFalse();
                return completableFuture;
            }
            AtomicBoolean removedAny = new AtomicBoolean();
            AggregateCompletionStage<AtomicBoolean> stageBuilder = CompletionStages.aggregateCompletionStage(removedAny);
            for (StoreStatus storeStatus : this.stores) {
                if (storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) || !predicate.test(storeStatus.config)) continue;
                stageBuilder.dependsOn(storeStatus.store.delete(segment, key).thenAccept(removed -> {
                    if (removed == null || removed.booleanValue()) {
                        removedAny.set(true);
                    }
                }));
            }
            CompletionStage<AtomicBoolean> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = CompletableFutures.booleanStage((boolean)removedAny.get());
                return completionStage;
            }
            release = false;
            completionStage = stage.handle((removed, throwable) -> {
                this.releaseReadLock(stamp);
                if (throwable != null) {
                    throw CompletableFutures.asCompletionException((Throwable)throwable);
                }
                return removed.get();
            });
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(k -> true, fetchValue, fetchMetadata, k -> true);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return this.publishEntries(IntSets.immutableRangeSet((int)this.segmentCount), filter, fetchValue, fetchMetadata, predicate);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return Flowable.using(this::acquireReadLock, ignore -> {
            if (!this.checkStoreAvailability()) {
                return Flowable.empty();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Publishing entries for segments %s", segments);
            }
            for (StoreStatus storeStatus : this.stores) {
                Set<NonBlockingStore.Characteristic> characteristics = storeStatus.characteristics;
                if (!characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ) || !predicate.test(storeStatus.config)) continue;
                Predicate filterToUse = !characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) && !segments.containsAll(IntSets.immutableRangeSet((int)this.segmentCount)) ? PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter) : filter;
                return storeStatus.store().publishEntries(segments, filterToUse, fetchValue);
            }
            return Flowable.empty();
        }, this::releaseReadLock);
    }

    @Override
    public <K> Publisher<K> publishKeys(Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return this.publishKeys(IntSets.immutableRangeSet((int)this.segmentCount), filter, predicate);
    }

    @Override
    public <K> Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return Flowable.using(this::acquireReadLock, ignore -> {
            if (!this.checkStoreAvailability()) {
                return Flowable.empty();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Publishing keys for segments %s", segments);
            }
            for (StoreStatus storeStatus : this.stores) {
                Set<NonBlockingStore.Characteristic> characteristics = storeStatus.characteristics;
                if (!characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ) || !predicate.test(storeStatus.config)) continue;
                Predicate filterToUse = !characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) && !segments.containsAll(IntSets.immutableRangeSet((int)this.segmentCount)) ? PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter) : filter;
                return storeStatus.store().publishKeys(segments, filterToUse);
            }
            return Flowable.empty();
        }, this::releaseReadLock);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, boolean localInvocation, boolean includeStores) {
        return this.loadFromAllStores(key, this.keyPartitioner.getSegment(key), localInvocation, includeStores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            Iterator<StoreStatus> iterator;
            CompletionStage<MarshallableEntry<K, V>> stage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Loading entry for key %s with segment %d", key, segment);
            }
            if (CompletionStages.isCompletedSuccessfully(stage = this.loadFromStoresIterator(key, segment, iterator = this.stores.iterator(), localInvocation, includeStores))) {
                CompletionStage<MarshallableEntry<K, V>> completionStage = stage;
                return completionStage;
            }
            release = false;
            CompletionStage<MarshallableEntry<K, V>> completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    private <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromStoresIterator(Object key, int segment, Iterator<StoreStatus> iterator, boolean localInvocation, boolean includeStores) {
        while (iterator.hasNext()) {
            StoreStatus storeStatus = iterator.next();
            NonBlockingStore store = storeStatus.store();
            if (!this.allowLoad(storeStatus, localInvocation, includeStores)) continue;
            CompletionStage loadStage = store.load(this.segmentOrZero(storeStatus, segment), key);
            return loadStage.thenCompose(e -> {
                if (e != null) {
                    if (storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) && this.configuration.expiration().lifespan() > 0L) {
                        e = this.marshallableEntryFactory.cloneWithExpiration((MarshallableEntry<?, ?>)e, this.timeService.wallClockTime(), this.configuration.expiration().lifespan());
                    }
                    return CompletableFuture.completedFuture(e);
                }
                return this.loadFromStoresIterator(key, segment, iterator, localInvocation, includeStores);
            });
        }
        return CompletableFutures.completedNull();
    }

    private boolean allowLoad(StoreStatus storeStatus, boolean localInvocation, boolean includeStores) {
        return !(storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.WRITE_ONLY) || !localInvocation && this.isLocalOnlyLoader(storeStatus.store) || !includeStores && !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) && !storeStatus.config.ignoreModifications());
    }

    private boolean isLocalOnlyLoader(NonBlockingStore<?, ?> store) {
        if (store instanceof LocalOnlyCacheLoader) {
            return true;
        }
        NonBlockingStore<Object, Object> unwrappedStore = store instanceof DelegatingNonBlockingStore ? ((DelegatingNonBlockingStore)store).delegate() : store;
        if (unwrappedStore instanceof LocalOnlyCacheLoader) {
            return true;
        }
        if (unwrappedStore instanceof NonBlockingStoreAdapter) {
            return ((NonBlockingStoreAdapter)unwrappedStore).getActualStore() instanceof LocalOnlyCacheLoader;
        }
        return false;
    }

    @Override
    public CompletionStage<Long> approximateSize(Predicate<? super StoreConfiguration> predicate, IntSet segments) {
        if (!this.isEnabled()) {
            return NonBlockingStore.SIZE_UNAVAILABLE_FUTURE;
        }
        long stamp = this.acquireReadLock();
        try {
            if (!this.isAvailable()) {
                this.releaseReadLock(stamp);
                return NonBlockingStore.SIZE_UNAVAILABLE_FUTURE;
            }
            if (this.stores == null) {
                throw new IllegalLifecycleStateException();
            }
            StoreStatus firstStoreStatus = this.getStoreStatusLocked(storeStatus -> storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.BULK_READ) && predicate.test(storeStatus.config));
            if (firstStoreStatus == null) {
                this.releaseReadLock(stamp);
                return NonBlockingStore.SIZE_UNAVAILABLE_FUTURE;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Obtaining approximate size from store %s", firstStoreStatus.store);
            }
            CompletionStage<Long> stage = firstStoreStatus.hasCharacteristic(NonBlockingStore.Characteristic.SEGMENTABLE) ? firstStoreStatus.store.approximateSize(segments) : firstStoreStatus.store.approximateSize(IntSets.immutableRangeSet((int)this.segmentCount)).thenApply(size -> {
                if (this.distributionManager == null) {
                    return size;
                }
                LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
                int storeSegments = firstStoreStatus.hasCharacteristic(NonBlockingStore.Characteristic.SHAREABLE) ? this.segmentCount : cacheTopology.getLocalWriteSegmentsCount();
                return storeSegments > 0 ? size * (long)segments.size() / (long)storeSegments : size;
            });
            return stage.whenComplete((ignore, ignoreT) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t) {
            this.releaseReadLock(stamp);
            throw t;
        }
    }

    @Override
    public CompletionStage<Long> size(Predicate<? super StoreConfiguration> predicate, IntSet segments) {
        long stamp = this.acquireReadLock();
        try {
            NonBlockingStore nonBlockingStore;
            this.checkStoreAvailability();
            if (log.isTraceEnabled()) {
                log.tracef("Obtaining size from stores", new Object[0]);
            }
            if ((nonBlockingStore = this.getStoreLocked(storeStatus -> storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.BULK_READ) && predicate.test(storeStatus.config))) == null) {
                this.releaseReadLock(stamp);
                return NonBlockingStore.SIZE_UNAVAILABLE_FUTURE;
            }
            if (segments == null) {
                segments = IntSets.immutableRangeSet((int)this.segmentCount);
            }
            return nonBlockingStore.size(segments).whenComplete((ignore, ignoreT) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t) {
            this.releaseReadLock(stamp);
            throw t;
        }
    }

    @Override
    public CompletionStage<Long> size(Predicate<? super StoreConfiguration> predicate) {
        return this.size(predicate, null);
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.clearOnStop = clearOnStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate, long flags) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Void> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Writing entry %s for with segment: %d", marshalledEntry, segment);
            }
            AggregateCompletionStage<Void> stageBuilder = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (!this.shouldWrite(storeStatus, predicate, flags)) continue;
                stageBuilder.dependsOn(storeStatus.store.write(segment, marshalledEntry));
            }
            CompletionStage<Void> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    private int segmentOrZero(StoreStatus storeStatus, int segment) {
        return storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SEGMENTABLE) ? segment : 0;
    }

    private boolean shouldWrite(StoreStatus storeStatus, Predicate<? super StoreConfiguration> userPredicate) {
        return !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY) && userPredicate.test(storeStatus.config);
    }

    private boolean shouldWrite(StoreStatus storeStatus, Predicate<? super StoreConfiguration> userPredicate, long flags) {
        return this.shouldWrite(storeStatus, userPredicate) && !storeStatus.store.ignoreCommandWithFlags(flags);
    }

    @Override
    public CompletionStage<Void> prepareAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) throws PersistenceException {
        Flowable mvccEntryFlowable = this.toMvccEntryFlowable(txInvocationContext, null);
        return this.batchOperation(mvccEntryFlowable, txInvocationContext, (stores, segmentCount, removeFlowable, putFlowable) -> stores.prepareWithModifications(txInvocationContext.getTransaction(), segmentCount, (Publisher<NonBlockingStore.SegmentedPublisher<Object>>)removeFlowable, putFlowable)).thenApply(CompletableFutures.toNullFunction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> commitAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Void> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Committing transaction %s to stores", txInvocationContext);
            }
            AggregateCompletionStage<Void> stageBuilder = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (!this.shouldPerformTransactionOperation(storeStatus, predicate)) continue;
                stageBuilder.dependsOn(storeStatus.store.commit(txInvocationContext.getTransaction()));
            }
            CompletionStage<Void> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> rollbackAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Void> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Rolling back transaction %s for stores", txInvocationContext);
            }
            AggregateCompletionStage<Void> stageBuilder = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (!this.shouldPerformTransactionOperation(storeStatus, predicate)) continue;
                stageBuilder.dependsOn(storeStatus.store.rollback(txInvocationContext.getTransaction()));
            }
            CompletionStage<Void> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    private boolean shouldPerformTransactionOperation(StoreStatus storeStatus, Predicate<? super StoreConfiguration> predicate) {
        return storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.TRANSACTIONAL) && predicate.test(storeStatus.config);
    }

    @Override
    public <K, V> CompletionStage<Void> writeEntries(Iterable<MarshallableEntry<K, V>> iterable, Predicate<? super StoreConfiguration> predicate) {
        return Completable.using(this::acquireReadLock, ignore -> {
            if (!this.checkStoreAvailability()) {
                return Completable.complete();
            }
            if (log.isTraceEnabled()) {
                log.trace("Writing entries to stores");
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.shouldWrite((StoreStatus)storeStatus, predicate) && !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.TRANSACTIONAL)).flatMapCompletable(storeStatus -> {
                boolean segmented = storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SEGMENTABLE);
                Flowable flowable = segmented ? Flowable.fromIterable((Iterable)iterable).groupBy(this.groupingFunction(MarshallableEntry::getKey)).map(SegmentPublisherWrapper::wrap) : Flowable.just(SingleSegmentPublisher.singleSegment(Flowable.fromIterable((Iterable)iterable)));
                return Completable.fromCompletionStage(storeStatus.store().batch(this.segmentCount(segmented), (Publisher<NonBlockingStore.SegmentedPublisher<Object>>)Flowable.empty(), flowable));
            });
        }, this::releaseReadLock).toCompletionStage(null);
    }

    @Override
    public CompletionStage<Long> writeMapCommand(PutMapCommand putMapCommand, InvocationContext ctx, BiPredicate<? super PutMapCommand, Object> commandKeyPredicate) {
        Flowable mvccEntryFlowable = this.entriesFromCommand(putMapCommand, ctx, (c, k, e) -> commandKeyPredicate.test((PutMapCommand)c, k));
        return this.batchOperation(mvccEntryFlowable, ctx, NonBlockingStore::batch);
    }

    @Override
    public CompletionStage<Long> performBatch(TxInvocationContext<AbstractCacheTransaction> ctx, TriPredicate<? super WriteCommand, Object, MVCCEntry<?, ?>> commandKeyPredicate) {
        Flowable mvccEntryFlowable = this.toMvccEntryFlowable(ctx, commandKeyPredicate);
        return this.batchOperation(mvccEntryFlowable, ctx, NonBlockingStore::batch);
    }

    private <K, V> CompletionStage<Long> batchOperation(Flowable<MVCCEntry<K, V>> mvccEntryFlowable, InvocationContext ctx, HandleFlowables<K, V> flowableHandler) {
        return Single.using(this::acquireReadLock, ignore -> {
            if (!this.checkStoreAvailability()) {
                return Single.just((Object)0L);
            }
            if (log.isTraceEnabled()) {
                log.trace("Writing batch to stores");
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.READ_ONLY)).flatMapSingle(storeStatus -> {
                Flowable flowableToUse;
                boolean shared = storeStatus.config.shared();
                if (shared) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Store %s is shared, checking skip shared stores and ignoring entries not primarily owned by this node", storeStatus.store);
                    }
                    flowableToUse = mvccEntryFlowable.filter(mvccEntry -> !mvccEntry.isSkipSharedStore());
                } else {
                    flowableToUse = mvccEntryFlowable;
                }
                boolean segmented = storeStatus.config.segmented();
                flowableToUse = flowableToUse.publish().autoConnect(2);
                Flowable<NonBlockingStore.SegmentedPublisher<Object>> removeFlowable = this.createRemoveFlowable((Flowable)flowableToUse, shared, segmented, (StoreStatus)storeStatus);
                ByRef.Long writeCount = new ByRef.Long(0L);
                Flowable writeFlowable = this.createWriteFlowable((Flowable)flowableToUse, ctx, shared, segmented, writeCount, (StoreStatus)storeStatus);
                CompletionStage<Void> storeBatchStage = flowableHandler.handleFlowables(storeStatus.store(), this.segmentCount(segmented), removeFlowable, writeFlowable);
                return Single.fromCompletionStage(storeBatchStage.thenApply(ignore2 -> writeCount.get()));
            }).last((Object)0L);
        }, this::releaseReadLock).toCompletionStage();
    }

    private <K, V> Flowable<NonBlockingStore.SegmentedPublisher<Object>> createRemoveFlowable(Flowable<MVCCEntry<K, V>> flowableToUse, boolean shared, boolean segmented, StoreStatus storeStatus) {
        Flowable flowable;
        Flowable keyRemoveFlowable = flowableToUse.filter(CacheEntry::isRemoved).map(CacheEntry::getKey);
        if (segmented) {
            flowable = keyRemoveFlowable.groupBy(this.keyPartitioner::getSegment).map(SegmentPublisherWrapper::wrap);
            flowable = this.filterSharedSegments(flowable, null, shared);
        } else {
            if (shared && !this.isInvalidationCache) {
                keyRemoveFlowable = keyRemoveFlowable.filter(k -> this.distributionManager.getCacheTopology().getDistribution(k).isPrimary());
            }
            flowable = Flowable.just(SingleSegmentPublisher.singleSegment(keyRemoveFlowable));
        }
        if (log.isTraceEnabled()) {
            flowable = flowable.doOnSubscribe(sub -> log.tracef("Store %s has subscribed to remove batch", storeStatus.store));
            flowable = flowable.map(sp -> {
                int segment = sp.getSegment();
                return SingleSegmentPublisher.singleSegment(segment, Flowable.fromPublisher((Publisher)sp).doOnNext(keyToRemove -> log.tracef("Emitting key %s for removal from segment %s", keyToRemove, segment)));
            });
        }
        return flowable;
    }

    private <K, V> Flowable<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> createWriteFlowable(Flowable<MVCCEntry<K, V>> flowableToUse, InvocationContext ctx, boolean shared, boolean segmented, ByRef.Long writeCount, StoreStatus storeStatus) {
        Flowable flowable;
        Flowable entryWriteFlowable = flowableToUse.filter(mvccEntry -> !mvccEntry.isRemoved()).map(mvcEntry -> {
            Object key = mvcEntry.getKey();
            InternalCacheValue sv = this.internalEntryFactory.getValueFromCtx(key, ctx);
            return this.marshallableEntryFactory.create(key, sv);
        });
        if (segmented) {
            entryWriteFlowable = entryWriteFlowable.doOnNext(obj -> writeCount.inc());
            flowable = entryWriteFlowable.groupBy(me -> this.keyPartitioner.getSegment(me.getKey())).map(SegmentPublisherWrapper::wrap);
            flowable = this.filterSharedSegments(flowable, writeCount, shared);
        } else {
            if (shared && !this.isInvalidationCache) {
                entryWriteFlowable = entryWriteFlowable.filter(me -> this.distributionManager.getCacheTopology().getDistribution(me.getKey()).isPrimary());
            }
            entryWriteFlowable = entryWriteFlowable.doOnNext(obj -> writeCount.inc());
            flowable = Flowable.just(SingleSegmentPublisher.singleSegment(entryWriteFlowable));
        }
        if (log.isTraceEnabled()) {
            flowable = flowable.doOnSubscribe(sub -> log.tracef("Store %s has subscribed to write batch", storeStatus.store));
            flowable = flowable.map(sp -> {
                int segment = sp.getSegment();
                return SingleSegmentPublisher.singleSegment(segment, Flowable.fromPublisher((Publisher)sp).doOnNext(me -> log.tracef("Emitting entry %s for write to segment %s", me.getKey(), segment)));
            });
        }
        return flowable;
    }

    private <I> Flowable<NonBlockingStore.SegmentedPublisher<I>> filterSharedSegments(Flowable<NonBlockingStore.SegmentedPublisher<I>> flowable, ByRef.Long writeCount, boolean shared) {
        if (!shared || this.isInvalidationCache) {
            return flowable;
        }
        return flowable.map(sp -> {
            if (this.distributionManager.getCacheTopology().getSegmentDistribution(sp.getSegment()).isPrimary()) {
                return sp;
            }
            Flowable emptyFlowable = Flowable.fromPublisher((Publisher)sp);
            emptyFlowable = writeCount != null ? emptyFlowable.doOnNext(ignore -> writeCount.dec()).ignoreElements().toFlowable() : emptyFlowable.take(0L);
            return SingleSegmentPublisher.singleSegment(sp.getSegment(), emptyFlowable);
        });
    }

    private <K, V> Flowable<MVCCEntry<K, V>> toMvccEntryFlowable(TxInvocationContext<AbstractCacheTransaction> ctx, TriPredicate<? super WriteCommand, Object, MVCCEntry<?, ?>> commandKeyPredicate) {
        return Flowable.fromIterable(ctx.getCacheTransaction().getAllModifications()).filter(writeCommand -> !writeCommand.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE | FlagBitSets.ROLLING_UPGRADE)).concatMap(writeCommand -> this.entriesFromCommand((WriteCommand)writeCommand, ctx, (TriPredicate)commandKeyPredicate));
    }

    private <K, V, WCT extends WriteCommand> Flowable<MVCCEntry<K, V>> entriesFromCommand(WCT writeCommand, InvocationContext ctx, TriPredicate<? super WCT, Object, MVCCEntry<?, ?>> commandKeyPredicate) {
        if (writeCommand instanceof DataWriteCommand) {
            Object key2 = ((DataWriteCommand)writeCommand).getKey();
            MVCCEntry<K, V> entry = this.acquireKeyFromContext(ctx, writeCommand, key2, commandKeyPredicate);
            return entry != null ? Flowable.just(entry) : Flowable.empty();
        }
        if (writeCommand instanceof InvalidateCommand) {
            return Flowable.empty();
        }
        return Flowable.fromIterable(writeCommand.getAffectedKeys()).concatMapMaybe(key -> {
            MVCCEntry entry = this.acquireKeyFromContext(ctx, writeCommand, key, commandKeyPredicate);
            return entry != null ? Maybe.just(entry) : Maybe.empty();
        });
    }

    private <K, V, WCT extends WriteCommand> MVCCEntry<K, V> acquireKeyFromContext(InvocationContext ctx, WCT command, Object key, TriPredicate<? super WCT, Object, MVCCEntry<?, ?>> commandKeyPredicate) {
        MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
        if (commandKeyPredicate != null && !commandKeyPredicate.test(command, key, entry) || entry == null || !entry.isChanged()) {
            return null;
        }
        return entry;
    }

    private <E> Function<E, Integer> groupingFunction(Function<E, Object> toKeyFunction) {
        return value -> this.keyPartitioner.getSegment(toKeyFunction.apply(value));
    }

    private int segmentCount(boolean segmented) {
        return segmented ? this.segmentCount : 1;
    }

    @Override
    public boolean isAvailable() {
        return this.unavailableExceptionMessage == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Boolean> addSegments(IntSet segments) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Boolean> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedFalse();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Adding segments %s to stores", segments);
            }
            AggregateCompletionStage<Boolean> stageBuilder = CompletionStages.aggregateCompletionStage(this.allSegmentedOrShared);
            for (StoreStatus storeStatus : this.stores) {
                if (!PersistenceManagerImpl.shouldInvokeSegmentMethods(storeStatus)) continue;
                stageBuilder.dependsOn(storeStatus.store.addSegments(segments));
            }
            CompletionStage<Boolean> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Boolean> removeSegments(IntSet segments) {
        long stamp = this.acquireReadLock();
        boolean release = true;
        try {
            CompletionStage<Boolean> completionStage;
            if (!this.checkStoreAvailability()) {
                CompletableFuture completableFuture = CompletableFutures.completedFalse();
                return completableFuture;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Removing segments %s from stores", segments);
            }
            AggregateCompletionStage<Boolean> stageBuilder = CompletionStages.aggregateCompletionStage(this.allSegmentedOrShared);
            for (StoreStatus storeStatus : this.stores) {
                if (!PersistenceManagerImpl.shouldInvokeSegmentMethods(storeStatus)) continue;
                stageBuilder.dependsOn(storeStatus.store.removeSegments(segments));
            }
            CompletionStage<Boolean> stage = stageBuilder.freeze();
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                completionStage = stage;
                return completionStage;
            }
            release = false;
            completionStage = stage.whenComplete((e, throwable) -> this.releaseReadLock(stamp));
            return completionStage;
        }
        finally {
            if (release) {
                this.releaseReadLock(stamp);
            }
        }
    }

    private static boolean shouldInvokeSegmentMethods(StoreStatus storeStatus) {
        return storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SEGMENTABLE) && !storeStatus.hasCharacteristic(NonBlockingStore.Characteristic.SHAREABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> List<NonBlockingStore<K, V>> getAllStores(Predicate<Set<NonBlockingStore.Characteristic>> predicate) {
        long stamp = this.acquireReadLock();
        try {
            if (!this.checkStoreAvailability()) {
                List<NonBlockingStore<K, V>> list = Collections.emptyList();
                return list;
            }
            List list = this.stores.stream().filter(storeStatus -> predicate.test(storeStatus.characteristics)).map(StoreStatus::store).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private long acquireReadLock() {
        return this.lock.readLock();
    }

    private long acquireWriteLock() {
        return this.lock.writeLock();
    }

    private void releaseReadLock(long stamp) {
        this.lock.unlockRead(stamp);
    }

    private void releaseWriteLock(long stamp) {
        this.lock.unlockWrite(stamp);
    }

    private boolean checkStoreAvailability() {
        if (!this.enabled) {
            return false;
        }
        String message = this.unavailableExceptionMessage;
        if (message != null) {
            throw new StoreUnavailableException(message);
        }
        if (this.stores == null) {
            throw new IllegalLifecycleStateException();
        }
        return true;
    }

    boolean anyLocksHeld() {
        return this.lock.isReadLocked() || this.lock.isWriteLocked();
    }

    static class StoreStatus {
        final NonBlockingStore<?, ?> store;
        final StoreConfiguration config;
        final Set<NonBlockingStore.Characteristic> characteristics;
        boolean availability = true;

        StoreStatus(NonBlockingStore<?, ?> store, StoreConfiguration config, Set<NonBlockingStore.Characteristic> characteristics) {
            this.store = store;
            this.config = config;
            this.characteristics = characteristics;
        }

        <K, V> NonBlockingStore<K, V> store() {
            return this.store;
        }

        private boolean hasCharacteristic(NonBlockingStore.Characteristic characteristic) {
            return this.characteristics.contains((Object)characteristic);
        }
    }

    static interface HandleFlowables<K, V> {
        public CompletionStage<Void> handleFlowables(NonBlockingStore<K, V> var1, int var2, Flowable<NonBlockingStore.SegmentedPublisher<Object>> var3, Flowable<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> var4);
    }
}

