/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.impl.Closer;

final class DependencyClosingBeanHolder<T>
implements BeanHolder<T> {
    private final BeanHolder<T> delegate;
    private final List<BeanHolder<?>> dependencies;

    DependencyClosingBeanHolder(BeanHolder<T> delegate, List<BeanHolder<?>> dependencies) {
        this.delegate = delegate;
        this.dependencies = dependencies;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegate=" + String.valueOf(this.delegate) + ", dependencies=" + String.valueOf(this.dependencies) + "]";
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.delegate);
            closer.pushAll(BeanHolder::close, this.dependencies);
        }
    }
}

