/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchDefaultWorkSequenceBuilder
implements ElasticsearchWorkSequenceBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchWorkExecutionContext context;
    private SequenceContext currentlyBuildingSequenceContext;

    ElasticsearchDefaultWorkSequenceBuilder(ElasticsearchWorkExecutionContext context) {
        this.context = context;
    }

    @Override
    public void init(CompletableFuture<?> previous) {
        this.currentlyBuildingSequenceContext = new SequenceContext(this.context, (CompletableFuture<?>)previous.handle((ignoredResult, ignoredThrowable) -> null));
    }

    @Override
    public <T> CompletableFuture<T> addNonBulkExecution(NonBulkableWork<T> work) {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        NonBulkedWorkExecutionState<T> workExecutionState = new NonBulkedWorkExecutionState<T>(sequenceContext, work);
        CompletionStage handledWorkExecutionFuture = sequenceContext.tail.thenCompose(Futures.safeComposer(workExecutionState::onPreviousWorkComplete));
        sequenceContext.updateTail((CompletableFuture<?>)handledWorkExecutionFuture);
        return workExecutionState.workFutureForCaller;
    }

    @Override
    public CompletableFuture<BulkResult> addBulkExecution(CompletableFuture<? extends NonBulkableWork<BulkResult>> workFuture) {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        CompletionStage bulkWorkResultFuture = ((CompletableFuture)sequenceContext.tail.thenCombine(workFuture, (ignored, work) -> work)).thenCompose(sequenceContext::execute);
        sequenceContext.updateTail((CompletableFuture<?>)bulkWorkResultFuture);
        return bulkWorkResultFuture;
    }

    @Override
    public <T> CompletableFuture<T> addBulkResultExtraction(CompletableFuture<BulkResult> bulkResultFuture, BulkableWork<T> bulkedWork, int index) {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        CompletionStage delayedBulkResultFuture = sequenceContext.tail.thenCombine(bulkResultFuture, (ignored, bulkResult) -> bulkResult);
        BulkedWorkExecutionState<T> workExecutionState = new BulkedWorkExecutionState<T>(sequenceContext, bulkedWork, index);
        CompletionStage handledWorkExecutionFuture = ((CompletableFuture)((CompletableFuture)delayedBulkResultFuture).whenComplete(Futures.handler(workExecutionState::onBulkWorkComplete))).thenCompose(workExecutionState::onBulkWorkSuccess);
        sequenceContext.updateTail(CompletableFuture.allOf(new CompletableFuture[]{sequenceContext.tail, handledWorkExecutionFuture}));
        return workExecutionState.workFutureForCaller;
    }

    @Override
    public CompletableFuture<Void> build() {
        return this.currentlyBuildingSequenceContext.tail;
    }

    private static final class SequenceContext {
        private final ElasticsearchWorkExecutionContext executionContext;
        private CompletableFuture<Void> tail;

        SequenceContext(ElasticsearchWorkExecutionContext executionContext, CompletableFuture<?> previous) {
            this.executionContext = executionContext;
            this.updateTail(previous);
        }

        <T> CompletionStage<T> execute(NonBulkableWork<T> work) {
            return work.execute(this.executionContext);
        }

        void updateTail(CompletableFuture<?> workFuture) {
            this.tail = workFuture.handle((ignoredResult, ignoredThrowable) -> null);
        }
    }

    private static final class NonBulkedWorkExecutionState<R>
    extends AbstractWorkExecutionState<R, NonBulkableWork<R>> {
        private NonBulkedWorkExecutionState(SequenceContext sequenceContext, NonBulkableWork<R> work) {
            super(sequenceContext, work);
        }

        CompletableFuture<R> onPreviousWorkComplete(Object ignored) {
            CompletableFuture workExecutionFuture = ((NonBulkableWork)this.work).execute(this.sequenceContext.executionContext);
            return this.addPostExecutionHandlers(workExecutionFuture);
        }
    }

    private static final class BulkedWorkExecutionState<R>
    extends AbstractWorkExecutionState<R, BulkableWork<R>> {
        private final BulkableWork<R> bulkedWork;
        private final int index;
        private BulkResult bulkResult;

        private BulkedWorkExecutionState(SequenceContext sequenceContext, BulkableWork<R> bulkedWork, int index) {
            super(sequenceContext, bulkedWork);
            this.bulkedWork = bulkedWork;
            this.index = index;
        }

        void onBulkWorkComplete(Object ignored, Throwable throwable) {
            if (throwable != null) {
                this.fail(log.elasticsearchFailedBecauseOfBulkFailure(throwable.getMessage(), throwable));
            }
        }

        CompletableFuture<R> onBulkWorkSuccess(BulkResult bulkResult) {
            this.bulkResult = bulkResult;
            CompletableFuture workExecutionFuture = Futures.create(this::extract);
            return this.addPostExecutionHandlers(workExecutionFuture);
        }

        private CompletableFuture<R> extract() {
            return CompletableFuture.completedFuture(this.bulkResult.extract(this.sequenceContext.executionContext, this.bulkedWork, this.index));
        }
    }

    private static abstract class AbstractWorkExecutionState<T, W extends ElasticsearchWork> {
        protected final SequenceContext sequenceContext;
        protected final W work;
        final CompletableFuture<T> workFutureForCaller = new CompletableFuture();

        private AbstractWorkExecutionState(SequenceContext sequenceContext, W work) {
            this.sequenceContext = sequenceContext;
            this.work = work;
        }

        protected CompletableFuture<T> addPostExecutionHandlers(CompletableFuture<T> workExecutionFuture) {
            workExecutionFuture.whenComplete(Futures.copyHandler(this.workFutureForCaller));
            return workExecutionFuture.exceptionally(Futures.handler(this::fail));
        }

        protected T fail(Throwable throwable) {
            this.workFutureForCaller.completeExceptionally(throwable);
            throw new PreviousWorkException(throwable);
        }
    }

    private static final class PreviousWorkException
    extends RuntimeException {
        public PreviousWorkException(Throwable cause) {
            super(cause);
        }
    }
}

