/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.configuration.global.PrincipalRoleMapperConfiguration;
import org.infinispan.configuration.global.RolePermissionMapperConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.audit.NullAuditLogger;

public class GlobalAuthorizationConfiguration {
    public static final Map<String, Role> DEFAULT_ROLES;
    public static final AttributeDefinition<Boolean> ENABLED;
    public static final AttributeDefinition<AuditLogger> AUDIT_LOGGER;
    public static final AttributeDefinition<Map<String, Role>> ROLES;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<AuditLogger> auditLogger;
    private final Map<String, Role> roles;
    private final PrincipalRoleMapperConfiguration roleMapperConfiguration;
    private final RolePermissionMapperConfiguration permissionMapperConfiguration;
    private final RolePermissionMapper rolePermissionMapper;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalAuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, AUDIT_LOGGER, ROLES});
    }

    public GlobalAuthorizationConfiguration(AttributeSet attributes, PrincipalRoleMapperConfiguration roleMapperConfiguration, RolePermissionMapperConfiguration permissionMapperConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.auditLogger = attributes.attribute(AUDIT_LOGGER);
        this.roles = (Map)attributes.attribute(ROLES).get();
        this.roleMapperConfiguration = roleMapperConfiguration;
        this.permissionMapperConfiguration = permissionMapperConfiguration;
        this.rolePermissionMapper = permissionMapperConfiguration.permissionMapper();
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public AuditLogger auditLogger() {
        return (AuditLogger)this.auditLogger.get();
    }

    public PrincipalRoleMapper principalRoleMapper() {
        return this.roleMapperConfiguration.roleMapper();
    }

    public RolePermissionMapper rolePermissionMapper() {
        return this.rolePermissionMapper;
    }

    public PrincipalRoleMapperConfiguration roleMapperConfiguration() {
        return this.roleMapperConfiguration;
    }

    public boolean isDefaultRoles() {
        return this.roles == DEFAULT_ROLES;
    }

    public RolePermissionMapperConfiguration permissionMapperConfiguration() {
        return this.permissionMapperConfiguration;
    }

    public Map<String, Role> roles() {
        HashMap<String, Role> all = new HashMap<String, Role>(this.roles);
        if (this.rolePermissionMapper != null) {
            all.putAll(this.rolePermissionMapper.getAllRoles());
        }
        return all;
    }

    public void addRole(Role role) {
        this.roles.put(role.getName(), role);
    }

    public boolean hasRole(String name) {
        return this.roles.containsKey(name) || this.rolePermissionMapper != null && this.rolePermissionMapper.hasRole(name);
    }

    public Role getRole(String name) {
        Role role = this.roles.get(name);
        if (role != null) {
            return role;
        }
        if (this.rolePermissionMapper != null) {
            return this.rolePermissionMapper.getRole(name);
        }
        return null;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAuthorizationConfiguration that = (GlobalAuthorizationConfiguration)o;
        return Objects.equals(this.roleMapperConfiguration, that.roleMapperConfiguration) && Objects.equals(this.permissionMapperConfiguration, that.permissionMapperConfiguration) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.roleMapperConfiguration, this.permissionMapperConfiguration, this.attributes);
    }

    public String toString() {
        return "GlobalAuthorizationConfiguration{roleMapperConfiguration=" + String.valueOf(this.roleMapperConfiguration) + "permissionMapperConfiguration=" + String.valueOf(this.permissionMapperConfiguration) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }

    static {
        ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).immutable().build();
        AUDIT_LOGGER = AttributeDefinition.builder((Enum)Attribute.AUDIT_LOGGER, (Object)new NullAuditLogger()).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
        ROLES = AttributeDefinition.builder((Enum)Attribute.ROLES, new HashMap()).initializer((AttributeInitializer)new AttributeInitializer<Map<String, Role>>(){

            public Map<String, Role> initialize() {
                return DEFAULT_ROLES;
            }
        }).build();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        roles.put("admin", Role.newRole("admin", true, AuthorizationPermission.ALL));
        roles.put("application", Role.newRole("application", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.MONITOR));
        roles.put("deployer", Role.newRole("deployer", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.CREATE, AuthorizationPermission.MONITOR));
        roles.put("observer", Role.newRole("observer", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.MONITOR));
        roles.put("monitor", Role.newRole("monitor", true, AuthorizationPermission.MONITOR));
        roles.put("___schema_manager", Role.newRole("___schema_manager", false, AuthorizationPermission.CREATE));
        roles.put("___script_manager", Role.newRole("___script_manager", false, AuthorizationPermission.CREATE));
        DEFAULT_ROLES = Collections.unmodifiableMap(roles);
    }
}

