/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.configuration.global.StackConfiguration;
import org.infinispan.configuration.global.StackConfigurationBuilder;
import org.infinispan.configuration.global.StackFileConfiguration;
import org.infinispan.configuration.global.StackFileConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;

public class JGroupsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<JGroupsConfiguration> {
    private final AttributeSet attributes;
    private List<StackConfigurationBuilder> stackConfigurationBuilders = new ArrayList<StackConfigurationBuilder>();
    private List<StackFileConfigurationBuilder> stackFileConfigurationBuilders = new ArrayList<StackFileConfigurationBuilder>();
    private Set<String> buildersByName = new HashSet<String>();

    JGroupsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.attributes = JGroupsConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
        this.stackConfigurationBuilders.forEach(s -> this.validate());
        this.stackFileConfigurationBuilders.forEach(s -> this.validate());
    }

    public StackConfigurationBuilder addStack(String name) {
        if (this.buildersByName.contains(name)) {
            throw Log.CONFIG.duplicateJGroupsStack(name);
        }
        StackConfigurationBuilder stackConfigurationBuilder = new StackConfigurationBuilder(name, this);
        this.buildersByName.add(name);
        this.stackConfigurationBuilders.add(stackConfigurationBuilder);
        return stackConfigurationBuilder;
    }

    public StackFileConfigurationBuilder addStackFile(String name) {
        if (this.buildersByName.contains(name)) {
            throw Log.CONFIG.duplicateJGroupsStack(name);
        }
        StackFileConfigurationBuilder stackFileConfigurationBuilder = new StackFileConfigurationBuilder(name, this);
        this.buildersByName.add(name);
        this.stackFileConfigurationBuilders.add(stackFileConfigurationBuilder);
        return stackFileConfigurationBuilder;
    }

    public JGroupsConfigurationBuilder transport(Transport transport) {
        this.attributes.attribute(JGroupsConfiguration.TRANSPORT).set((Object)transport);
        return this;
    }

    public JGroupsConfigurationBuilder clear() {
        this.stackConfigurationBuilders = new ArrayList<StackConfigurationBuilder>();
        this.stackFileConfigurationBuilders = new ArrayList<StackFileConfigurationBuilder>();
        return this;
    }

    Transport jgroupsTransport() {
        return (Transport)this.attributes.attribute(JGroupsConfiguration.TRANSPORT).get();
    }

    public JGroupsConfiguration create() {
        List<StackFileConfiguration> stackFileConfigurations = this.stackFileConfigurationBuilders.stream().map(StackFileConfigurationBuilder::create).collect(Collectors.toList());
        List<StackConfiguration> stackConfigurations = this.stackConfigurationBuilders.stream().map(StackConfigurationBuilder::create).collect(Collectors.toList());
        return new JGroupsConfiguration(this.attributes.protect(), stackFileConfigurations, stackConfigurations);
    }

    public JGroupsConfigurationBuilder read(JGroupsConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.buildersByName.clear();
        template.stackFiles().forEach(s -> this.addStackFile(s.name()).read((StackFileConfiguration)s, combine));
        template.stacks().forEach(s -> this.addStack(s.name()).read((StackConfiguration)s, combine));
        for (StackFileConfigurationBuilder stackFileConfigurationBuilder : this.stackFileConfigurationBuilders) {
            this.buildersByName.add(stackFileConfigurationBuilder.getConfigurator().getName());
        }
        for (StackConfigurationBuilder stackConfigurationBuilder : this.stackConfigurationBuilders) {
            this.buildersByName.add(stackConfigurationBuilder.getConfigurator().getName());
        }
        return this;
    }

    public boolean hasStack(String name) {
        return this.buildersByName.contains(name);
    }

    public String toString() {
        return "JGroupsConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + ", stackConfigurationBuilders=" + String.valueOf(this.stackConfigurationBuilders) + ", stackFileConfigurationBuilders=" + String.valueOf(this.stackFileConfigurationBuilders) + "}";
    }
}

