/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst11.client;

import com.arjuna.mw.wst11.client.JaxBaseHeaderContextProcessor;
import com.arjuna.mw.wstx.logging.wstxLogger;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class JaxWSHeaderContextProcessor
extends JaxBaseHeaderContextProcessor
implements SOAPHandler<SOAPMessageContext> {
    public boolean handleMessage(SOAPMessageContext msgContext) {
        return this.handleMessage(msgContext, true);
    }

    public boolean handleMessage(SOAPMessageContext msgContext, boolean mustUnderstand) {
        Boolean outbound = (Boolean)msgContext.get((Object)"jakarta.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: jakarta.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext, mustUnderstand) : this.handleInbound(msgContext);
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"client/JaxWSHeaderContextProcessor.handleFault()");
            wstxLogger.traceMessage(messageContext);
        }
        SOAPMessageContext soapMessageContext = messageContext;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        this.resumeTransaction(soapMessage);
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headerSet = new HashSet<QName>();
        headerSet.add(new QName("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext"));
        return headerSet;
    }

    public void setHeaders(Set headers) {
    }

    protected boolean handleInbound(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"client/JaxWSHeaderContextProcessor.handleInbound()");
            wstxLogger.traceMessage(messageContext);
        }
        SOAPMessage soapMessage = messageContext.getMessage();
        this.resumeTransaction(soapMessage);
        return true;
    }

    protected boolean handleOutbound(SOAPMessageContext messageContext, boolean mustUnderstand) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"client/JaxWSHeaderContextProcessor.handleOutbound()");
            wstxLogger.traceMessage(messageContext);
        }
        SOAPMessage soapMessage = messageContext.getMessage();
        return this.handleOutboundMessage(soapMessage, mustUnderstand);
    }
}

