/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.HandlerOperations;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.handlers.ClientSocketFactory;
import org.jboss.logmanager.handlers.DelayedHandler;
import org.jboss.logmanager.handlers.SocketHandler;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.Functions;

public class SocketHandlerResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "socket-handler";
    private static final PathElement PATH = PathElement.pathElement((String)"socket-handler");
    public static final SimpleAttributeDefinition BLOCK_ON_RECONNECT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-reconnect", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    public static final SimpleAttributeDefinition FILTER_SPEC = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)AbstractHandlerDefinition.FILTER_SPEC).setAlternatives(new String[0])).build();
    public static final SimpleAttributeDefinition NAMED_FORMATTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)AbstractHandlerDefinition.NAMED_FORMATTER).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).setAlternatives(new String[0])).setRequired(true)).build();
    public static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"outbound-socket-binding-ref", (ModelType)ModelType.STRING, (boolean)false).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setAllowExpression(true)).setCapabilityReference(OutboundSocketBinding.SERVICE_DESCRIPTOR.getName())).addFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    public static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"protocol", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(SocketHandler.Protocol.TCP.name()))).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setValidator((ParameterValidator)new EnumValidator(SocketHandler.Protocol.class, (Enum[])SocketHandler.Protocol.values()))).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ssl-context", (ModelType)ModelType.STRING, (boolean)true).addFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).setAllowExpression(true)).setCapabilityReference("org.wildfly.security.ssl-context")).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.AUTOFLUSH, BLOCK_ON_RECONNECT, CommonAttributes.LEVEL, CommonAttributes.ENABLED, CommonAttributes.ENCODING, NAMED_FORMATTER, FILTER_SPEC, PROTOCOL, OUTBOUND_SOCKET_BINDING_REF, SSL_CONTEXT};
    private static final LoggingOperations.LoggingAddOperationStepHandler ADD_HANDLER = new LoggingOperations.LoggingAddOperationStepHandler(){

        @Override
        protected OperationStepHandler additionalModelStep(final LogContextConfiguration logContextConfiguration) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HandlerConfiguration configuration;
                    if (!this.requiresRuntime(context) && (configuration = logContextConfiguration.getHandlerConfiguration(context.getCurrentAddressValue())) != null) {
                        if (!(configuration.getInstance() instanceof DelayedHandler)) {
                            throw LoggingLogger.ROOT_LOGGER.invalidType(DelayedHandler.class, ((Handler)configuration.getInstance()).getClass());
                        }
                        DelayedHandler delayedHandler = (DelayedHandler)configuration.getInstance();
                        Handler[] current = delayedHandler.setHandlers(new Handler[]{new DiscardingHandler()});
                        if (current != null) {
                            for (Handler handler : current) {
                                handler.close();
                            }
                        }
                    }
                }
            };
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                configuration = logContextConfiguration.addHandlerConfiguration(null, DelayedHandler.class.getName(), name, new String[0]);
            } else if (!(configuration.getInstance() instanceof DelayedHandler)) {
                throw LoggingLogger.ROOT_LOGGER.invalidType(DelayedHandler.class, ((Handler)configuration.getInstance()).getClass());
            }
            CommonAttributes.ENABLED.setPropertyValue(context, model, (PropertyConfigurable)configuration);
            ModelNode filter = FILTER_SPEC.resolveModelAttribute(context, model);
            if (filter.isDefined()) {
                configuration.setFilter(filter.asString());
            }
            configuration.setLevel(CommonAttributes.LEVEL.resolvePropertyValue(context, model));
            configuration.setFormatterName(NAMED_FORMATTER.resolveModelAttribute(context, model).asString());
        }

        @Override
        protected OperationStepHandler afterPrepare(final LogContextConfiguration logContextConfiguration, final ModelNode model) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    Supplier sslContext;
                    final String name = context.getCurrentAddressValue();
                    final HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
                    final SocketHandler.Protocol protocol = SocketHandler.Protocol.valueOf((String)PROTOCOL.resolveModelAttribute(context, model).asString());
                    final boolean autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model).asBoolean();
                    final boolean blockOnReconnect = BLOCK_ON_RECONNECT.resolveModelAttribute(context, model).asBoolean();
                    final boolean enabled = CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
                    String socketBindingName = OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(context, model).asString();
                    ModelNode sslContextRef = SSL_CONTEXT.resolveModelAttribute(context, model);
                    ServiceName serviceName = Capabilities.HANDLER_CAPABILITY.getCapabilityServiceName(new String[]{Capabilities.HANDLER_CAPABILITY.getDynamicName(context.getCurrentAddress())});
                    ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName);
                    final Supplier outboundSocketBinding = serviceBuilder.requires(context.getCapabilityServiceName(OutboundSocketBinding.SERVICE_DESCRIPTOR, socketBindingName));
                    final Supplier socketBindingManager = serviceBuilder.requires(context.getCapabilityServiceName(SocketBindingManager.SERVICE_DESCRIPTOR));
                    if (sslContextRef.isDefined()) {
                        sslContext = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.ssl-context", sslContextRef.asString(), SSLContext.class));
                    } else if (protocol == SocketHandler.Protocol.SSL_TCP) {
                        try {
                            sslContext = Functions.constantSupplier((Object)SSLContext.getDefault());
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw LoggingLogger.ROOT_LOGGER.failedToConfigureSslContext(e, SocketHandlerResourceDefinition.NAME, context.getCurrentAddressValue());
                        }
                    } else {
                        sslContext = Functions.constantSupplier(null);
                    }
                    serviceBuilder.setInstance(new Service(){

                        public synchronized void start(StartContext context) {
                            WildFlyClientSocketFactory clientSocketFactory = new WildFlyClientSocketFactory((SocketBindingManager)socketBindingManager.get(), (OutboundSocketBinding)outboundSocketBinding.get(), (SSLContext)sslContext.get(), name);
                            DelayedHandler delayedHandler = (DelayedHandler)configuration.getInstance();
                            delayedHandler.setCloseChildren(true);
                            SocketHandler socketHandler = new SocketHandler((ClientSocketFactory)clientSocketFactory, protocol);
                            socketHandler.setAutoFlush(autoflush);
                            socketHandler.setBlockOnReconnect(blockOnReconnect);
                            socketHandler.setEnabled(enabled);
                            socketHandler.setFilter(delayedHandler.getFilter());
                            socketHandler.setFormatter(delayedHandler.getFormatter());
                            socketHandler.setLevel(delayedHandler.getLevel());
                            Handler[] current = delayedHandler.setHandlers(new Handler[]{socketHandler});
                            if (current != null) {
                                for (Handler handler : current) {
                                    handler.close();
                                }
                            }
                        }

                        public void stop(StopContext context) {
                        }
                    }).install();
                }
            };
        }
    };
    private static final OperationStepHandler REMOVE_HANDLER = new HandlerOperations.LogHandlerRemoveHandler(){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            super.performRuntime(context, operation, model, logContextConfiguration);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName serviceName = Capabilities.HANDLER_CAPABILITY.getCapabilityServiceName(new String[]{Capabilities.HANDLER_CAPABILITY.getDynamicName(context.getCurrentAddress())});
                    context.removeService(serviceName);
                }
            }, OperationContext.Stage.RUNTIME);
        }

        @Override
        protected void revertRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            ADD_HANDLER.performRuntime(context, operation, model, logContextConfiguration);
        }
    };
    public static final SocketHandlerResourceDefinition INSTANCE = new SocketHandlerResourceDefinition();

    private SocketHandlerResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setAddHandler((OperationStepHandler)ADD_HANDLER).setRemoveHandler(REMOVE_HANDLER).setCapabilities(new RuntimeCapability[]{Capabilities.HANDLER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)WriteAttributeHandler.INSTANCE);
        }
    }

    private static class DiscardingHandler
    extends Handler {
        private DiscardingHandler() {
        }

        @Override
        public void publish(LogRecord record) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class WildFlyClientSocketFactory
    implements ClientSocketFactory {
        private final SocketBindingManager socketBinding;
        private final OutboundSocketBinding outboundSocketBinding;
        private final String name;
        private final SSLContext sslContext;

        private WildFlyClientSocketFactory(SocketBindingManager socketBinding, OutboundSocketBinding outboundSocketBinding, SSLContext sslContext, String name) {
            this.socketBinding = socketBinding;
            this.outboundSocketBinding = outboundSocketBinding;
            this.sslContext = sslContext;
            this.name = name;
        }

        public DatagramSocket createDatagramSocket() throws SocketException {
            return this.socketBinding.createDatagramSocket(this.name);
        }

        public Socket createSocket() throws IOException {
            if (this.sslContext != null) {
                return this.sslContext.getSocketFactory().createSocket(this.getAddress(), this.getPort());
            }
            return this.outboundSocketBinding.connect();
        }

        public InetAddress getAddress() {
            try {
                return this.outboundSocketBinding.getResolvedDestinationAddress();
            }
            catch (UnknownHostException e) {
                throw new UncheckedIOException(e);
            }
        }

        public int getPort() {
            return this.outboundSocketBinding.getDestinationPort();
        }
    }

    private static class WriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        static final WriteAttributeHandler INSTANCE = new WriteAttributeHandler();

        private WriteAttributeHandler() {
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(addressName));
            }
            if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                configuration.setLevel(value.asString());
            } else if (NAMED_FORMATTER.getName().equals(attributeName)) {
                if (value.isDefined()) {
                    configuration.setFormatterName(value.asString());
                } else {
                    configuration.setFormatterName(null);
                }
            } else if (FILTER_SPEC.getName().equals(attributeName)) {
                if (value.isDefined()) {
                    configuration.setFilter(value.asString());
                } else {
                    configuration.setFilter(null);
                }
            }
            return Logging.requiresReload(context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getFlags());
        }

        @Override
        protected OperationStepHandler afterPrepare(final LogContextConfiguration logContextConfiguration, final String attributeName, final ModelNode resolvedValue, ModelNode currentValue) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String addressName = context.getCurrentAddressValue();
                    HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
                    if (configuration == null) {
                        throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(addressName));
                    }
                    Handler instance = (Handler)configuration.getInstance();
                    if (!(instance instanceof DelayedHandler)) {
                        throw LoggingLogger.ROOT_LOGGER.invalidType(DelayedHandler.class, instance.getClass());
                    }
                    final DelayedHandler delayedHandler = (DelayedHandler)instance;
                    Handler[] children = delayedHandler.getHandlers();
                    if (children == null || children.length == 0) {
                        throw LoggingLogger.ROOT_LOGGER.invalidType(SocketHandler.class, null);
                    }
                    instance = children[0];
                    if (!(instance instanceof SocketHandler)) {
                        throw LoggingLogger.ROOT_LOGGER.invalidType(SocketHandler.class, instance.getClass());
                    }
                    final SocketHandler socketHandler = (SocketHandler)instance;
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                                    socketHandler.setLevel(delayedHandler.getLevel());
                                } else if (NAMED_FORMATTER.getName().equals(attributeName)) {
                                    socketHandler.setFormatter(delayedHandler.getFormatter());
                                } else if (FILTER_SPEC.getName().equals(attributeName)) {
                                    socketHandler.setFilter(delayedHandler.getFilter());
                                } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
                                    socketHandler.setAutoFlush(resolvedValue.asBoolean());
                                } else if (BLOCK_ON_RECONNECT.getName().equals(attributeName)) {
                                    socketHandler.setBlockOnReconnect(resolvedValue.asBoolean());
                                } else if (CommonAttributes.ENABLED.getName().equals(attributeName)) {
                                    socketHandler.setEnabled(resolvedValue.asBoolean());
                                } else if (PROTOCOL.getName().equals(attributeName)) {
                                    socketHandler.setProtocol(SocketHandler.Protocol.valueOf((String)resolvedValue.asString()));
                                }
                            }
                        }
                    });
                }
            };
        }
    }

    public static final class TransformerDefinition
    extends TransformerResourceDefinition {
        public TransformerDefinition() {
            super(PATH);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
            switch (modelVersion) {
                case VERSION_6_0_0: {
                    rootResourceBuilder.rejectChildResource(this.getPathElement());
                    loggingProfileBuilder.rejectChildResource(this.getPathElement());
                }
            }
        }
    }
}

