/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.util.Locale;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.GenerationTime;

@Deprecated(since="6.2", forRemoval=true)
public enum GenerationTiming {
    NEVER,
    INSERT,
    UPDATE,
    ALWAYS;


    public boolean includesInsert() {
        return this == INSERT || this == ALWAYS;
    }

    public boolean includesUpdate() {
        return this == UPDATE || this == ALWAYS;
    }

    public boolean includes(GenerationTiming timing) {
        switch (this) {
            case NEVER: {
                return timing == NEVER;
            }
            case INSERT: {
                return timing.includesInsert();
            }
            case UPDATE: {
                return timing.includesUpdate();
            }
            case ALWAYS: {
                return true;
            }
        }
        throw new AssertionFailure("unknown timing");
    }

    public static GenerationTiming parseFromName(String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "insert": {
                return INSERT;
            }
            case "update": {
                return UPDATE;
            }
            case "always": {
                return ALWAYS;
            }
        }
        return NEVER;
    }

    public GenerationTime getEquivalent() {
        switch (this) {
            case ALWAYS: {
                return GenerationTime.ALWAYS;
            }
            case INSERT: {
                return GenerationTime.INSERT;
            }
            case UPDATE: {
                return GenerationTime.UPDATE;
            }
            case NEVER: {
                return GenerationTime.NEVER;
            }
        }
        throw new AssertionFailure("unknown timing");
    }
}

