/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.Keyable;
import org.hibernate.envers.boot.model.ManyToOneAttribute;
import org.hibernate.envers.configuration.internal.metadata.ColumnNameIterator;
import org.hibernate.mapping.Selectable;

public class IdentifierRelation
implements AttributeContainer {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<Attribute> getAttributesPrefixed(String prefix, Iterator<Selectable> iterator, boolean makeKey, boolean insertable) {
        return this.getAttributesPrefixed(prefix, ColumnNameIterator.from(iterator), makeKey, insertable);
    }

    public List<Attribute> getAttributesPrefixed(String prefix, ColumnNameIterator columnNameIterator, boolean makeKey, boolean insertable) {
        ArrayList<Attribute> prefixedAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : this.attributes) {
            Attribute prefixedAttribute = (Attribute)attribute.deepCopy();
            String name = prefixedAttribute.getName();
            if (name != null) {
                prefixedAttribute.setName(prefix + prefixedAttribute.getName());
            }
            IdentifierRelation.changeNamesInColumns(prefixedAttribute, columnNameIterator);
            if (makeKey) {
                if (prefixedAttribute instanceof Keyable) {
                    ((Keyable)((Object)prefixedAttribute)).setKey(true);
                }
                if (prefixedAttribute instanceof ManyToOneAttribute) {
                    ManyToOneAttribute manyToOne = (ManyToOneAttribute)prefixedAttribute;
                    manyToOne.setForeignKey("none");
                }
            }
            if (prefixedAttribute instanceof BasicAttribute) {
                ((BasicAttribute)prefixedAttribute).setInsertable(insertable);
            }
            prefixedAttributes.add(prefixedAttribute);
        }
        return prefixedAttributes;
    }

    private static void changeNamesInColumns(Attribute attribute, ColumnNameIterator columnNameIterator) {
        for (Column column : attribute.getColumns()) {
            if (column.getName() == null) continue;
            column.setName((String)columnNameIterator.next());
        }
    }
}

