/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import jakarta.servlet.jsp.tagext.VariableInfo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperLogger;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ELInterpreter;
import org.apache.jasper.compiler.ELInterpreterFactory;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

class Generator {
    private static final Class<?>[] OBJECT_CLASS = new Class[]{Object.class};
    private static final String VAR_EXPRESSIONFACTORY = System.getProperty("org.apache.jasper.compiler.Generator.VAR_EXPRESSIONFACTORY", "_el_expressionfactory");
    private static final String VAR_INSTANCEMANAGER = System.getProperty("org.apache.jasper.compiler.Generator.VAR_INSTANCEMANAGER", "_jsp_instancemanager");
    private static final boolean POOL_TAGS_WITH_EXTENDS = Boolean.getBoolean("org.apache.jasper.compiler.Generator.POOL_TAGS_WITH_EXTENDS");
    private static final boolean STRICT_GET_PROPERTY = Boolean.valueOf(System.getProperty("org.apache.jasper.compiler.Generator.STRICT_GET_PROPERTY", "true"));
    private final ServletWriter out;
    private final ArrayList<GenBuffer> methodsBuffered;
    private final FragmentHelperClass fragmentHelperClass;
    private final ErrorDispatcher err;
    private final BeanRepository beanInfo;
    private final Set<String> varInfoNames;
    private final JspCompilationContext ctxt;
    private final boolean isPoolingEnabled;
    private final boolean breakAtLF;
    private String jspIdPrefix;
    private int jspId;
    private final PageInfo pageInfo;
    private final Vector<String> tagHandlerPoolNames;
    private GenBuffer charArrayBuffer;
    private final DateFormat timestampFormat;
    private final ELInterpreter elInterpreter;

    static String quote(String s) {
        if (s == null) {
            return "null";
        }
        return "\"" + Generator.escape(s) + "\"";
    }

    static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    static String quote(char c) {
        StringBuilder b = new StringBuilder();
        b.append('\'');
        if (c == '\'') {
            b.append('\\').append('\'');
        } else if (c == '\\') {
            b.append('\\').append('\\');
        } else if (c == '\n') {
            b.append('\\').append('n');
        } else if (c == '\r') {
            b.append('\\').append('r');
        } else {
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }

    private String createJspId() {
        if (this.jspIdPrefix == null) {
            StringBuilder sb = new StringBuilder(32);
            String name = this.ctxt.getServletJavaFileName();
            sb.append("jsp_");
            sb.append(Math.abs((long)name.hashCode()));
            sb.append('_');
            this.jspIdPrefix = sb.toString();
        }
        return this.jspIdPrefix + this.jspId++;
    }

    private void generateDeclarations(Node.Nodes page) throws JasperException {
        this.out.println();
        class DeclarationVisitor
        extends Node.Visitor {
            private boolean getServletInfoGenerated = false;

            DeclarationVisitor() {
            }

            @Override
            public void visit(Node.PageDirective n) throws JasperException {
                if (this.getServletInfoGenerated) {
                    return;
                }
                String info = n.getAttributeValue("info");
                if (info == null) {
                    return;
                }
                this.getServletInfoGenerated = true;
                Generator.this.out.printil("public java.lang.String getServletInfo() {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin("return ");
                Generator.this.out.print(Generator.quote(info));
                Generator.this.out.println(";");
                Generator.this.out.popIndent();
                Generator.this.out.printil("}");
                Generator.this.out.println();
            }

            @Override
            public void visit(Node.Declaration n) throws JasperException {
                n.setBeginJavaLine(Generator.this.out.getJavaLine());
                Generator.this.out.printMultiLn(n.getText());
                Generator.this.out.println();
                n.setEndJavaLine(Generator.this.out.getJavaLine());
            }

            @Override
            public void visit(Node.CustomTag n) throws JasperException {
                if (n.useTagPlugin()) {
                    if (n.getAtSTag() != null) {
                        n.getAtSTag().visit(this);
                    }
                    this.visitBody(n);
                    if (n.getAtETag() != null) {
                        n.getAtETag().visit(this);
                    }
                } else {
                    this.visitBody(n);
                }
            }
        }
        page.visit(new DeclarationVisitor());
    }

    private void compileTagHandlerPoolList(Node.Nodes page) throws JasperException {
        class TagHandlerPoolVisitor
        extends Node.Visitor {
            private final Vector<String> names;

            TagHandlerPoolVisitor(Vector<String> v) {
                this.names = v;
            }

            @Override
            public void visit(Node.CustomTag n) throws JasperException {
                if (!n.implementsSimpleTag()) {
                    String name = this.createTagHandlerPoolName(n.getPrefix(), n.getLocalName(), n.getAttributes(), n.getNamedAttributeNodes(), n.hasEmptyBody());
                    n.setTagHandlerPoolName(name);
                    if (!this.names.contains(name)) {
                        this.names.add(name);
                    }
                }
                this.visitBody(n);
            }

            private String createTagHandlerPoolName(String prefix, String shortName, Attributes attrs, Node.Nodes namedAttrs, boolean hasEmptyBody) {
                StringBuilder poolName = new StringBuilder(64);
                poolName.append("_jspx_tagPool_").append(prefix).append('_').append(shortName);
                if (attrs != null) {
                    int i;
                    String[] attrNames = new String[attrs.getLength() + namedAttrs.size()];
                    for (i = 0; i < attrNames.length; ++i) {
                        attrNames[i] = attrs.getQName(i);
                    }
                    for (i = 0; i < namedAttrs.size(); ++i) {
                        attrNames[attrs.getLength() + i] = ((Node.NamedAttribute)namedAttrs.getNode(i)).getQName();
                    }
                    Arrays.sort(attrNames, Collections.reverseOrder());
                    if (attrNames.length > 0) {
                        poolName.append('&');
                    }
                    for (i = 0; i < attrNames.length; ++i) {
                        poolName.append('_');
                        poolName.append(attrNames[i]);
                    }
                }
                if (hasEmptyBody) {
                    poolName.append("_nobody");
                }
                return JspUtil.makeJavaIdentifier(poolName.toString());
            }
        }
        page.visit(new TagHandlerPoolVisitor(this.tagHandlerPoolNames));
    }

    private void declareTemporaryScriptingVars(Node.Nodes page) throws JasperException {
        class ScriptingVarVisitor
        extends Node.Visitor {
            private final Vector<String> vars = new Vector();

            ScriptingVarVisitor() {
            }

            @Override
            public void visit(Node.CustomTag n) throws JasperException {
                if (n.getCustomNestingLevel() > 0) {
                    TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
                    VariableInfo[] varInfos = n.getVariableInfos();
                    if (varInfos.length > 0) {
                        for (int i = 0; i < varInfos.length; ++i) {
                            String varName = varInfos[i].getVarName();
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            if (this.vars.contains(tmpVarName)) continue;
                            this.vars.add(tmpVarName);
                            Generator.this.out.printin(varInfos[i].getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(tmpVarName);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    } else {
                        for (int i = 0; i < tagVarInfos.length; ++i) {
                            String varName = tagVarInfos[i].getNameGiven();
                            if (varName == null) {
                                varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                            } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            if (this.vars.contains(tmpVarName)) continue;
                            this.vars.add(tmpVarName);
                            Generator.this.out.printin(tagVarInfos[i].getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(tmpVarName);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    }
                }
                this.visitBody(n);
            }
        }
        page.visit(new ScriptingVarVisitor());
    }

    private void generateInit() {
        if (this.ctxt.isTagFile()) {
            Generator.printilThreePart(this.out, "private void _jspInit(", "jakarta.servlet.ServletConfig", " config) {");
        } else {
            this.out.printil("public void _jspInit() {");
        }
        this.out.pushIndent();
        if (this.isPoolingEnabled) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printin(this.tagHandlerPoolNames.elementAt(i));
                this.out.print(" = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(");
                if (this.ctxt.isTagFile()) {
                    this.out.print("config");
                } else {
                    this.out.print("getServletConfig()");
                }
                this.out.println(");");
            }
        }
        this.out.printin(VAR_EXPRESSIONFACTORY);
        this.out.print(" = _jspxFactory.getJspApplicationContext(");
        if (this.ctxt.isTagFile()) {
            this.out.print("config");
        } else {
            this.out.print("getServletConfig()");
        }
        this.out.println(".getServletContext()).getExpressionFactory();");
        this.out.printin(VAR_INSTANCEMANAGER);
        this.out.print(" = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(");
        if (this.ctxt.isTagFile()) {
            this.out.print("config");
        } else {
            this.out.print("getServletConfig()");
        }
        this.out.println(");");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generateDestroy() {
        this.out.printil("public void _jspDestroy() {");
        this.out.pushIndent();
        if (this.isPoolingEnabled) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printin(this.tagHandlerPoolNames.elementAt(i));
                this.out.println(".release();");
            }
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void genPreamblePackage(String packageName) {
        if (!"".equals(packageName) && packageName != null) {
            this.out.printil("package " + packageName + ";");
            this.out.println();
        }
    }

    private void genPreambleImports() {
        Iterator<String> iter = this.pageInfo.getImports().iterator();
        while (iter.hasNext()) {
            this.out.printin("import ");
            this.out.print(iter.next());
            this.out.println(";");
        }
        this.out.println();
    }

    private void genPreambleStaticInitializers() {
        Generator.printilThreePart(this.out, "private static final ", "jakarta.servlet.jsp.JspFactory", " _jspxFactory =");
        Generator.printilThreePart(this.out, "        ", "jakarta.servlet.jsp.JspFactory", ".getDefaultFactory();");
        this.out.println();
        this.out.printil("private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;");
        this.out.println();
        Map<String, Long> dependants = this.pageInfo.getDependants();
        if (!dependants.isEmpty()) {
            this.out.printil("static {");
            this.out.pushIndent();
            this.out.printin("_jspx_dependants = new java.util.HashMap<java.lang.String,java.lang.Long>(");
            this.out.print("" + dependants.size());
            this.out.println(");");
            for (Map.Entry<String, Long> entry : dependants.entrySet()) {
                this.out.printin("_jspx_dependants.put(\"");
                this.out.print(entry.getKey());
                this.out.print("\", Long.valueOf(");
                this.out.print(entry.getValue().toString());
                this.out.println("L));");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
        List<String> imports = this.pageInfo.getImports();
        HashSet<String> packages = new HashSet<String>();
        HashSet<String> classes = new HashSet<String>();
        for (String importName : imports) {
            if (importName == null) continue;
            String trimmed = importName.trim();
            if (trimmed.endsWith(".*")) {
                packages.add(trimmed.substring(0, trimmed.length() - 2));
                continue;
            }
            classes.add(trimmed);
        }
        this.out.printil("private static final java.util.Set<java.lang.String> _jspx_imports_packages;");
        this.out.println();
        this.out.printil("private static final java.util.Set<java.lang.String> _jspx_imports_classes;");
        this.out.println();
        this.out.printil("static {");
        this.out.pushIndent();
        if (packages.size() == 0) {
            this.out.printin("_jspx_imports_packages = null;");
            this.out.println();
        } else {
            this.out.printin("_jspx_imports_packages = new java.util.HashSet<>();");
            this.out.println();
            for (String packageName : packages) {
                this.out.printin("_jspx_imports_packages.add(\"");
                this.out.print(packageName);
                this.out.println("\");");
            }
        }
        if (classes.size() == 0) {
            this.out.printin("_jspx_imports_classes = null;");
            this.out.println();
        } else {
            this.out.printin("_jspx_imports_classes = new java.util.HashSet<>();");
            this.out.println();
            for (String className : classes) {
                this.out.printin("_jspx_imports_classes.add(\"");
                this.out.print(className);
                this.out.println("\");");
            }
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void genPreambleClassVariableDeclarations() {
        if (this.isPoolingEnabled && !this.tagHandlerPoolNames.isEmpty()) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printil("private org.apache.jasper.runtime.TagHandlerPool " + this.tagHandlerPoolNames.elementAt(i) + ";");
            }
            this.out.println();
        }
        Generator.printinThreePart(this.out, "private ", "jakarta.el.ExpressionFactory", " ");
        this.out.print(VAR_EXPRESSIONFACTORY);
        this.out.println(";");
        this.out.printin("private org.apache.tomcat.InstanceManager ");
        this.out.print(VAR_INSTANCEMANAGER);
        this.out.println(";");
        this.out.println();
    }

    private void genPreambleMethods() {
        this.out.printil("public java.util.Map<java.lang.String,java.lang.Long> getDependants() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_dependants;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public java.util.Set<java.lang.String> getPackageImports() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_imports_packages;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public java.util.Set<java.lang.String> getClassImports() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_imports_classes;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public boolean getErrorOnELNotFound() {");
        this.out.pushIndent();
        if (this.pageInfo.isErrorOnELNotFound()) {
            this.out.printil("return true;");
        } else {
            this.out.printil("return false;");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.generateInit();
        this.generateDestroy();
    }

    private void generatePreamble(Node.Nodes page) throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        String serviceMethodName = Constants.SERVICE_METHOD_NAME;
        this.genPreamblePackage(servletPackageName);
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.print(servletClassName);
        this.out.print(" extends ");
        this.out.println(this.pageInfo.getExtends());
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent,");
        this.out.println();
        this.out.printin("                 org.apache.jasper.runtime.JspSourceImports,");
        this.out.println();
        this.out.printin("                 org.apache.jasper.runtime.JspSourceDirectives");
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(page);
        this.genPreambleStaticInitializers();
        this.genPreambleClassVariableDeclarations();
        this.genPreambleMethods();
        if (this.pageInfo.isThreadSafe()) {
            this.out.printin("public void ");
        } else {
            this.out.printin("public synchronized void ");
            JasperLogger.ROOT_LOGGER.deprecatedIsThreadSafe(this.ctxt.getJspFile());
        }
        this.out.print(serviceMethodName);
        Generator.printlnMultiPart(this.out, "(final ", "jakarta.servlet.http.HttpServletRequest", " request, final ", "jakarta.servlet.http.HttpServletResponse", " response)");
        Generator.printlnThreePart(this.out, "        throws java.io.IOException, ", "jakarta.servlet.ServletException", " {");
        this.out.pushIndent();
        this.out.println();
        if (!this.pageInfo.isErrorPage()) {
            this.out.println("final java.lang.String _jspx_method = request.getMethod();");
            this.out.print("if (!\"GET\".equals(_jspx_method) && !\"POST\".equals(_jspx_method) && !\"HEAD\".equals(_jspx_method) && ");
            Generator.printlnThreePart(this.out, "!", "jakarta.servlet.DispatcherType", ".ERROR.equals(request.getDispatcherType())) {");
            this.out.pushIndent();
            this.out.print("response.sendError(jakarta.servlet.http.HttpServletResponse.SC_METHOD_NOT_ALLOWED, ");
            this.out.println("\"" + JasperMessages.MESSAGES.forbiddenHttpMethod() + "\");");
            this.out.println("return;");
            this.out.popIndent();
            this.out.println("}");
            this.out.println();
        }
        Generator.printilThreePart(this.out, "final ", "jakarta.servlet.jsp.PageContext", " pageContext;");
        if (this.pageInfo.isSession()) {
            Generator.printilTwoPart(this.out, "jakarta.servlet.http.HttpSession", " session = null;");
        }
        if (this.pageInfo.isErrorPage()) {
            this.out.printil("java.lang.Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
            this.out.printil("if (exception != null) {");
            this.out.pushIndent();
            Generator.printilThreePart(this.out, "response.setStatus(", "jakarta.servlet.http.HttpServletResponse", ".SC_INTERNAL_SERVER_ERROR);");
            this.out.popIndent();
            this.out.printil("}");
        }
        Generator.printilThreePart(this.out, "final ", "jakarta.servlet.ServletContext", " application;");
        Generator.printilThreePart(this.out, "final ", "jakarta.servlet.ServletConfig", " config;");
        Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.JspWriter", " out = null;");
        this.out.printil("final java.lang.Object page = this;");
        Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.JspWriter", " _jspx_out = null;");
        Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.PageContext", " _jspx_page_context = null;");
        this.out.println();
        this.declareTemporaryScriptingVars(page);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printin("response.setContentType(");
        this.out.print(Generator.quote(this.pageInfo.getContentType()));
        this.out.println(");");
        if (this.ctxt.getOptions().isXpoweredBy()) {
            this.out.printil("response.addHeader(\"X-Powered-By\", \"JSP/3.1\");");
        }
        this.out.printil("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.out.printin("\t\t\t");
        this.out.print(Generator.quote(this.pageInfo.getErrorPage()));
        this.out.print(", " + this.pageInfo.isSession());
        this.out.print(", " + this.pageInfo.getBuffer());
        this.out.print(", " + this.pageInfo.isAutoFlush());
        this.out.println(");");
        this.out.printil("_jspx_page_context = pageContext;");
        this.out.printil("application = pageContext.getServletContext();");
        this.out.printil("config = pageContext.getServletConfig();");
        if (this.pageInfo.isSession()) {
            this.out.printil("session = pageContext.getSession();");
        }
        this.out.printil("out = pageContext.getOut();");
        this.out.printil("_jspx_out = out;");
        this.out.println();
    }

    private void generateXmlProlog(Node.Nodes page) {
        String doctypeName;
        String omitXmlDecl = this.pageInfo.getOmitXmlDecl();
        if (omitXmlDecl != null && !JspUtil.booleanValue(omitXmlDecl) || omitXmlDecl == null && page.getRoot().isXmlSyntax() && !this.pageInfo.hasJspRoot() && !this.ctxt.isTagFile()) {
            String cType = this.pageInfo.getContentType();
            String charSet = cType.substring(cType.indexOf("charset=") + 8);
            this.out.printil("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + charSet + "\\\"?>\\n\");");
        }
        if ((doctypeName = this.pageInfo.getDoctypeName()) != null) {
            String doctypePublic = this.pageInfo.getDoctypePublic();
            String doctypeSystem = this.pageInfo.getDoctypeSystem();
            this.out.printin("out.write(\"<!DOCTYPE ");
            this.out.print(doctypeName);
            if (doctypePublic == null) {
                this.out.print(" SYSTEM \\\"");
            } else {
                this.out.print(" PUBLIC \\\"");
                this.out.print(doctypePublic);
                this.out.print("\\\" \\\"");
            }
            this.out.print(doctypeSystem);
            this.out.println("\\\">\\n\");");
        }
    }

    private static void generateLocalVariables(ServletWriter out, Node n) throws JasperException {
        Node.ChildInfo ci;
        if (n instanceof Node.CustomTag) {
            ci = ((Node.CustomTag)n).getChildInfo();
        } else if (n instanceof Node.JspBody) {
            ci = ((Node.JspBody)n).getChildInfo();
        } else if (n instanceof Node.NamedAttribute) {
            ci = ((Node.NamedAttribute)n).getChildInfo();
        } else {
            throw new JasperException("Unexpected Node Type");
        }
        if (ci.hasUseBean()) {
            Generator.printilTwoPart(out, "jakarta.servlet.http.HttpSession", " session = _jspx_page_context.getSession();");
            Generator.printilTwoPart(out, "jakarta.servlet.ServletContext", " application = _jspx_page_context.getServletContext();");
        }
        if (ci.hasUseBean() || ci.hasIncludeAction() || ci.hasSetProperty() || ci.hasParamAction()) {
            Generator.printilMultiPart(out, "jakarta.servlet.http.HttpServletRequest", " request = (", "jakarta.servlet.http.HttpServletRequest", ")_jspx_page_context.getRequest();");
        }
        if (ci.hasIncludeAction()) {
            Generator.printilMultiPart(out, "jakarta.servlet.http.HttpServletResponse", " response = (", "jakarta.servlet.http.HttpServletResponse", ")_jspx_page_context.getResponse();");
        }
    }

    private void genCommonPostamble() {
        for (int i = 0; i < this.methodsBuffered.size(); ++i) {
            GenBuffer methodBuffer = this.methodsBuffered.get(i);
            methodBuffer.adjustJavaLines(this.out.getJavaLine() - 1);
            this.out.printMultiLn(methodBuffer.toString());
        }
        if (this.fragmentHelperClass.isUsed()) {
            this.fragmentHelperClass.generatePostamble();
            this.fragmentHelperClass.adjustJavaLines(this.out.getJavaLine() - 1);
            this.out.printMultiLn(this.fragmentHelperClass.toString());
        }
        if (this.charArrayBuffer != null) {
            this.out.printMultiLn(this.charArrayBuffer.toString());
        }
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePostamble() {
        this.out.popIndent();
        this.out.printil("} catch (java.lang.Throwable t) {");
        this.out.pushIndent();
        Generator.printilThreePart(this.out, "if (!(t instanceof ", "jakarta.servlet.jsp.SkipPageException", ")){");
        this.out.pushIndent();
        this.out.printil("out = _jspx_out;");
        this.out.printil("if (out != null && out.getBufferSize() != 0)");
        this.out.pushIndent();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("if (response.isCommitted()) {");
        this.out.pushIndent();
        this.out.printil("out.flush();");
        this.out.popIndent();
        this.out.printil("} else {");
        this.out.pushIndent();
        this.out.printil("out.clearBuffer();");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("} catch (java.io.IOException e) {}");
        this.out.popIndent();
        this.out.printil("if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);");
        this.out.printil("else throw new jakarta.servlet.ServletException(t);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("_jspxFactory.releasePageContext(_jspx_page_context);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    Generator(ServletWriter out, Compiler compiler) throws JasperException {
        this.out = out;
        this.methodsBuffered = new ArrayList();
        this.charArrayBuffer = null;
        this.err = compiler.getErrorDispatcher();
        this.ctxt = compiler.getCompilationContext();
        this.fragmentHelperClass = new FragmentHelperClass("Helper");
        this.pageInfo = compiler.getPageInfo();
        ELInterpreter elInterpreter = null;
        try {
            elInterpreter = ELInterpreterFactory.getELInterpreter(compiler.getCompilationContext().getServletContext());
        }
        catch (Exception e) {
            this.err.jspError("jsp.error.el_interpreter_class.instantiation", e.getMessage());
        }
        this.elInterpreter = elInterpreter;
        this.isPoolingEnabled = this.pageInfo.getExtends(false) == null || POOL_TAGS_WITH_EXTENDS ? this.ctxt.getOptions().isPoolingEnabled() : false;
        this.beanInfo = this.pageInfo.getBeanRepository();
        this.varInfoNames = this.pageInfo.getVarInfoNames();
        this.breakAtLF = this.ctxt.getOptions().getMappedFile();
        this.tagHandlerPoolNames = this.isPoolingEnabled ? new Vector() : null;
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static void generate(ServletWriter out, Compiler compiler, Node.Nodes page) throws JasperException {
        Generator gen = new Generator(out, compiler);
        if (gen.isPoolingEnabled) {
            gen.compileTagHandlerPoolList(page);
        }
        gen.generateCommentHeader();
        if (gen.ctxt.isTagFile()) {
            JasperTagInfo tagInfo = (JasperTagInfo)gen.ctxt.getTagInfo();
            gen.generateTagHandlerPreamble(tagInfo, page);
            if (gen.ctxt.isPrototypeMode()) {
                return;
            }
            gen.generateXmlProlog(page);
            gen.fragmentHelperClass.generatePreamble();
            Generator generator = gen;
            Objects.requireNonNull(generator);
            page.visit(generator.new GenerateVisitor(gen.ctxt.isTagFile(), out, gen.methodsBuffered, gen.fragmentHelperClass));
            gen.generateTagHandlerPostamble(tagInfo);
        } else {
            gen.generatePreamble(page);
            gen.generateXmlProlog(page);
            gen.fragmentHelperClass.generatePreamble();
            Generator generator = gen;
            Objects.requireNonNull(generator);
            page.visit(generator.new GenerateVisitor(gen.ctxt.isTagFile(), out, gen.methodsBuffered, gen.fragmentHelperClass));
            gen.generatePostamble();
        }
    }

    private void generateCommentHeader() {
        this.out.println("/*");
        this.out.println(" * Generated by the Jasper component of Apache Tomcat");
        this.out.println(" * Version: " + this.ctxt.getServletContext().getServerInfo());
        this.out.println(" * Generated at: " + this.timestampFormat.format(new Date()) + " UTC");
        this.out.println(" * Note: The last modified time of this file was set to");
        this.out.println(" *       the last modified time of the source file after");
        this.out.println(" *       generation to assist with modification tracking.");
        this.out.println(" */");
    }

    private void generateTagHandlerPreamble(JasperTagInfo tagInfo, Node.Nodes tag) throws JasperException {
        String className = tagInfo.getTagClassName();
        int lastIndex = className.lastIndexOf(46);
        if (lastIndex != -1) {
            String pkgName = className.substring(0, lastIndex);
            this.genPreamblePackage(pkgName);
            className = className.substring(lastIndex + 1);
        }
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.println(className);
        Generator.printilTwoPart(this.out, "    extends ", "jakarta.servlet.jsp.tagext.SimpleTagSupport");
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent");
        if (tagInfo.hasDynamicAttributes()) {
            this.out.println(",");
            Generator.printinTwoPart(this.out, "               ", "jakarta.servlet.jsp.tagext.DynamicAttributes");
        }
        this.out.println(",");
        this.out.printin("    org.apache.jasper.runtime.JspSourceDirectives");
        this.out.println(" {");
        this.out.println();
        this.out.pushIndent();
        this.generateDeclarations(tag);
        this.genPreambleStaticInitializers();
        Generator.printilThreePart(this.out, "private ", "jakarta.servlet.jsp.JspContext", " jspContext;");
        this.out.printil("private java.io.Writer _jspx_sout;");
        this.genPreambleClassVariableDeclarations();
        this.generateSetJspContext(tagInfo);
        this.generateTagHandlerAttributes(tagInfo);
        if (tagInfo.hasDynamicAttributes()) {
            this.generateSetDynamicAttribute();
        }
        this.genPreambleMethods();
        Generator.printilThreePart(this.out, "public void doTag() throws ", "jakarta.servlet.jsp.JspException", ", java.io.IOException {");
        if (this.ctxt.isPrototypeMode()) {
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            return;
        }
        this.out.pushIndent();
        Generator.printilMultiPart(this.out, "jakarta.servlet.jsp.PageContext", " _jspx_page_context = (", "jakarta.servlet.jsp.PageContext", ")jspContext;");
        Generator.printilMultiPart(this.out, "jakarta.servlet.http.HttpServletRequest", " request = ", "(", "jakarta.servlet.http.HttpServletRequest", ") _jspx_page_context.getRequest();");
        Generator.printilMultiPart(this.out, "jakarta.servlet.http.HttpServletResponse", " response = ", "(", "jakarta.servlet.http.HttpServletResponse", ") _jspx_page_context.getResponse();");
        Generator.printilTwoPart(this.out, "jakarta.servlet.http.HttpSession", " session = _jspx_page_context.getSession();");
        Generator.printilTwoPart(this.out, "jakarta.servlet.ServletContext", " application = _jspx_page_context.getServletContext();");
        Generator.printilTwoPart(this.out, "jakarta.servlet.ServletConfig", " config = _jspx_page_context.getServletConfig();");
        Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.JspWriter", " out = jspContext.getOut();");
        this.out.printil("_jspInit(config);");
        Generator.printilThreePart(this.out, "jspContext.getELContext().putContext(", "jakarta.servlet.jsp.JspContext", ".class,jspContext);");
        this.generatePageScopedVariables(tagInfo);
        this.declareTemporaryScriptingVars(tag);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
    }

    private void generateTagHandlerPostamble(TagInfo tagInfo) {
        this.out.popIndent();
        this.out.printil("} catch( java.lang.Throwable t ) {");
        this.out.pushIndent();
        Generator.printilThreePart(this.out, "if( t instanceof ", "jakarta.servlet.jsp.SkipPageException", " )");
        Generator.printilThreePart(this.out, "    throw (", "jakarta.servlet.jsp.SkipPageException", ") t;");
        this.out.printil("if( t instanceof java.io.IOException )");
        this.out.printil("    throw (java.io.IOException) t;");
        this.out.printil("if( t instanceof java.lang.IllegalStateException )");
        this.out.printil("    throw (java.lang.IllegalStateException) t;");
        Generator.printilThreePart(this.out, "if( t instanceof ", "jakarta.servlet.jsp.JspException", " )");
        Generator.printilThreePart(this.out, "    throw (", "jakarta.servlet.jsp.JspException", ") t;");
        Generator.printilThreePart(this.out, "throw new ", "jakarta.servlet.jsp.JspException", "(t);");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        TagAttributeInfo[] attrInfos = tagInfo.getAttributes();
        for (int i = 0; i < attrInfos.length; ++i) {
            if (!attrInfos[i].isDeferredMethod() && !attrInfos[i].isDeferredValue()) continue;
            this.out.printin("_el_variablemapper.setVariable(");
            this.out.print(Generator.quote(attrInfos[i].getName()));
            this.out.print(",_el_ve");
            this.out.print(i);
            this.out.println(");");
        }
        Generator.printilThreePart(this.out, "jspContext.getELContext().putContext(", "jakarta.servlet.jsp.JspContext", ".class,super.getJspContext());");
        this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) jspContext).syncEndTagFile();");
        if (this.isPoolingEnabled && !this.tagHandlerPoolNames.isEmpty()) {
            this.out.printil("_jspDestroy();");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    private void generateTagHandlerAttributes(TagInfo tagInfo) {
        int i;
        if (tagInfo.hasDynamicAttributes()) {
            this.out.printil("private java.util.HashMap _jspx_dynamic_attrs = new java.util.HashMap();");
        }
        TagAttributeInfo[] attrInfos = tagInfo.getAttributes();
        for (i = 0; i < attrInfos.length; ++i) {
            this.out.printin("private ");
            if (attrInfos[i].isFragment()) {
                this.out.print("jakarta.servlet.jsp.tagext.JspFragment");
                this.out.print(" ");
            } else {
                this.out.print(JspUtil.toJavaSourceType(attrInfos[i].getTypeName()));
                this.out.print(" ");
            }
            this.out.print(JspUtil.makeJavaIdentifierForAttribute(attrInfos[i].getName()));
            this.out.println(";");
        }
        this.out.println();
        for (i = 0; i < attrInfos.length; ++i) {
            String javaName = JspUtil.makeJavaIdentifierForAttribute(attrInfos[i].getName());
            this.out.printin("public ");
            if (attrInfos[i].isFragment()) {
                this.out.print("jakarta.servlet.jsp.tagext.JspFragment");
                this.out.print(" ");
            } else {
                this.out.print(JspUtil.toJavaSourceType(attrInfos[i].getTypeName()));
                this.out.print(" ");
            }
            this.out.print(this.toGetterMethod(attrInfos[i].getName()));
            this.out.println(" {");
            this.out.pushIndent();
            this.out.printin("return this.");
            this.out.print(javaName);
            this.out.println(";");
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
            this.out.printin("public void ");
            this.out.print(this.toSetterMethodName(attrInfos[i].getName()));
            if (attrInfos[i].isFragment()) {
                this.out.print("(");
                this.out.print("jakarta.servlet.jsp.tagext.JspFragment");
                this.out.print(" ");
            } else {
                this.out.print("(");
                this.out.print(JspUtil.toJavaSourceType(attrInfos[i].getTypeName()));
                this.out.print(" ");
            }
            this.out.print(javaName);
            this.out.println(") {");
            this.out.pushIndent();
            this.out.printin("this.");
            this.out.print(javaName);
            this.out.print(" = ");
            this.out.print(javaName);
            this.out.println(";");
            if (this.ctxt.isTagFile()) {
                this.out.printin("jspContext.setAttribute(\"");
                this.out.print(attrInfos[i].getName());
                this.out.print("\", ");
                this.out.print(javaName);
                this.out.println(");");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
    }

    private void generateSetJspContext(TagInfo tagInfo) {
        int i;
        boolean nestedSeen = false;
        boolean atBeginSeen = false;
        boolean atEndSeen = false;
        boolean aliasSeen = false;
        TagVariableInfo[] tagVars = tagInfo.getTagVariableInfos();
        for (i = 0; i < tagVars.length; ++i) {
            if (tagVars[i].getNameFromAttribute() == null || tagVars[i].getNameGiven() == null) continue;
            aliasSeen = true;
            break;
        }
        if (aliasSeen) {
            Generator.printilThreePart(this.out, "public void setJspContext(", "jakarta.servlet.jsp.JspContext", " ctx, java.util.Map aliasMap) {");
        } else {
            Generator.printilThreePart(this.out, "public void setJspContext(", "jakarta.servlet.jsp.JspContext", " ctx) {");
        }
        this.out.pushIndent();
        this.out.printil("super.setJspContext(ctx);");
        this.out.printil("java.util.ArrayList _jspx_nested = null;");
        this.out.printil("java.util.ArrayList _jspx_at_begin = null;");
        this.out.printil("java.util.ArrayList _jspx_at_end = null;");
        for (i = 0; i < tagVars.length; ++i) {
            switch (tagVars[i].getScope()) {
                case 0: {
                    if (!nestedSeen) {
                        this.out.printil("_jspx_nested = new java.util.ArrayList();");
                        nestedSeen = true;
                    }
                    this.out.printin("_jspx_nested.add(");
                    break;
                }
                case 1: {
                    if (!atBeginSeen) {
                        this.out.printil("_jspx_at_begin = new java.util.ArrayList();");
                        atBeginSeen = true;
                    }
                    this.out.printin("_jspx_at_begin.add(");
                    break;
                }
                case 2: {
                    if (!atEndSeen) {
                        this.out.printil("_jspx_at_end = new java.util.ArrayList();");
                        atEndSeen = true;
                    }
                    this.out.printin("_jspx_at_end.add(");
                }
            }
            this.out.print(Generator.quote(tagVars[i].getNameGiven()));
            this.out.println(");");
        }
        if (aliasSeen) {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(this, ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, aliasMap);");
        } else {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(this, ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, null);");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        Generator.printilThreePart(this.out, "public ", "jakarta.servlet.jsp.JspContext", " getJspContext() {");
        this.out.pushIndent();
        this.out.printil("return this.jspContext;");
        this.out.popIndent();
        this.out.printil("}");
    }

    public void generateSetDynamicAttribute() {
        Generator.printilThreePart(this.out, "public void setDynamicAttribute(java.lang.String uri, java.lang.String localName, java.lang.Object value) throws ", "jakarta.servlet.jsp.JspException", " {");
        this.out.pushIndent();
        this.out.printil("if (uri == null)");
        this.out.pushIndent();
        this.out.printil("_jspx_dynamic_attrs.put(localName, value);");
        this.out.popIndent();
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePageScopedVariables(JasperTagInfo tagInfo) {
        TagAttributeInfo[] attrInfos = tagInfo.getAttributes();
        boolean variableMapperVar = false;
        for (int i = 0; i < attrInfos.length; ++i) {
            String attrName = attrInfos[i].getName();
            if (attrInfos[i].isDeferredValue() || attrInfos[i].isDeferredMethod()) {
                if (!variableMapperVar) {
                    Generator.printilTwoPart(this.out, "jakarta.el.VariableMapper", " _el_variablemapper = jspContext.getELContext().getVariableMapper();");
                    variableMapperVar = true;
                }
                Generator.printinTwoPart(this.out, "jakarta.el.ValueExpression", " _el_ve");
                this.out.print(i);
                this.out.print(" = _el_variablemapper.setVariable(");
                this.out.print(Generator.quote(attrName));
                this.out.print(',');
                if (attrInfos[i].isDeferredMethod()) {
                    this.out.print(VAR_EXPRESSIONFACTORY);
                    this.out.print(".createValueExpression(");
                    this.out.print(this.toGetterMethod(attrName));
                    Generator.printThreePart(this.out, ",", "jakarta.el.MethodExpression", ".class)");
                } else {
                    this.out.print(this.toGetterMethod(attrName));
                }
                this.out.println(");");
                continue;
            }
            this.out.printil("if( " + this.toGetterMethod(attrName) + " != null ) ");
            this.out.pushIndent();
            this.out.printin("_jspx_page_context.setAttribute(");
            this.out.print(Generator.quote(attrName));
            this.out.print(", ");
            this.out.print(this.toGetterMethod(attrName));
            this.out.println(");");
            this.out.popIndent();
        }
        if (tagInfo.hasDynamicAttributes()) {
            this.out.printin("_jspx_page_context.setAttribute(\"");
            this.out.print(tagInfo.getDynamicAttributesMapName());
            this.out.print("\", _jspx_dynamic_attrs);");
        }
    }

    private String toGetterMethod(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "get" + new String(attrChars) + "()";
    }

    private String toSetterMethodName(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "set" + new String(attrChars);
    }

    private static void printilTwoPart(ServletWriter out, String one, String two) {
        out.printin(one);
        out.println(two);
    }

    private static void printinTwoPart(ServletWriter out, String one, String two) {
        out.printin(one);
        out.print(two);
    }

    private static void printThreePart(ServletWriter out, String one, String two, String three) {
        out.print(one);
        out.print(two);
        out.print(three);
    }

    private static void printilThreePart(ServletWriter out, String one, String two, String three) {
        out.printin(one);
        out.print(two);
        out.println(three);
    }

    private static void printinThreePart(ServletWriter out, String one, String two, String three) {
        out.printin(one);
        out.print(two);
        out.print(three);
    }

    private static void printlnThreePart(ServletWriter out, String one, String two, String three) {
        out.print(one);
        out.print(two);
        out.println(three);
    }

    private static void printilMultiPart(ServletWriter out, String ... parts) {
        Generator.printMultiPart(out, true, true, parts);
    }

    private static void printinMultiPart(ServletWriter out, String ... parts) {
        Generator.printMultiPart(out, true, false, parts);
    }

    private static void printlnMultiPart(ServletWriter out, String ... parts) {
        Generator.printMultiPart(out, false, true, parts);
    }

    private static void printMultiPart(ServletWriter out, boolean indent, boolean newLine, String ... parts) {
        assert (parts.length > 1);
        int last = parts.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (indent && i == 0) {
                out.printin(parts[i]);
                continue;
            }
            if (newLine && i == last) {
                out.println(parts[i]);
                continue;
            }
            out.print(parts[i]);
        }
    }

    private static class FragmentHelperClass {
        private boolean used = false;
        private ArrayList<Fragment> fragments = new ArrayList();
        private String className;
        private GenBuffer classBuffer = new GenBuffer();

        public FragmentHelperClass(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void generatePreamble() {
            ServletWriter out = this.classBuffer.getOut();
            out.println();
            out.pushIndent();
            out.printil("private class " + this.className);
            out.printil("    extends org.apache.jasper.runtime.JspFragmentHelper");
            out.printil("{");
            out.pushIndent();
            Generator.printilThreePart(out, "private ", "jakarta.servlet.jsp.tagext.JspTag", " _jspx_parent;");
            out.printil("private int[] _jspx_push_body_count;");
            out.println();
            Generator.printilMultiPart(out, "public ", this.className, "( int discriminator, ", "jakarta.servlet.jsp.JspContext", " jspContext, ", "jakarta.servlet.jsp.tagext.JspTag", " _jspx_parent, ", "int[] _jspx_push_body_count ) {");
            out.pushIndent();
            out.printil("super( discriminator, jspContext, _jspx_parent );");
            out.printil("this._jspx_parent = _jspx_parent;");
            out.printil("this._jspx_push_body_count = _jspx_push_body_count;");
            out.popIndent();
            out.printil("}");
        }

        public Fragment openFragment(Node parent, int methodNesting) throws JasperException {
            Fragment result = new Fragment(this.fragments.size(), parent);
            this.fragments.add(result);
            this.used = true;
            parent.setInnerClassName(this.className);
            ServletWriter out = result.getGenBuffer().getOut();
            out.pushIndent();
            out.pushIndent();
            if (methodNesting > 0) {
                out.printin("public boolean invoke");
            } else {
                out.printin("public void invoke");
            }
            Generator.printlnMultiPart(out, result.getId() + "( ", "jakarta.servlet.jsp.JspWriter", " out ) ");
            out.pushIndent();
            out.printil("throws java.lang.Throwable");
            out.popIndent();
            out.printil("{");
            out.pushIndent();
            Generator.generateLocalVariables(out, parent);
            return result;
        }

        public void closeFragment(Fragment fragment, int methodNesting) {
            ServletWriter out = fragment.getGenBuffer().getOut();
            if (methodNesting > 0) {
                out.printil("return false;");
            } else {
                out.printil("return;");
            }
            out.popIndent();
            out.printil("}");
        }

        public void generatePostamble() {
            int i;
            ServletWriter out = this.classBuffer.getOut();
            for (i = 0; i < this.fragments.size(); ++i) {
                Fragment fragment = this.fragments.get(i);
                fragment.getGenBuffer().adjustJavaLines(out.getJavaLine() - 1);
                out.printMultiLn(fragment.getGenBuffer().toString());
            }
            out.printil("public void invoke( java.io.Writer writer )");
            out.pushIndent();
            Generator.printilTwoPart(out, "throws ", "jakarta.servlet.jsp.JspException");
            out.popIndent();
            out.printil("{");
            out.pushIndent();
            Generator.printilTwoPart(out, "jakarta.servlet.jsp.JspWriter", " out = null;");
            out.printil("if( writer != null ) {");
            out.pushIndent();
            out.printil("out = this.jspContext.pushBody(writer);");
            out.popIndent();
            out.printil("} else {");
            out.pushIndent();
            out.printil("out = this.jspContext.getOut();");
            out.popIndent();
            out.printil("}");
            out.printil("try {");
            out.pushIndent();
            Generator.printilThreePart(out, "Object _jspx_saved_JspContext = this.jspContext.getELContext().getContext(", "jakarta.servlet.jsp.JspContext", ".class);");
            Generator.printilThreePart(out, "this.jspContext.getELContext().putContext(", "jakarta.servlet.jsp.JspContext", ".class,this.jspContext);");
            out.printil("switch( this.discriminator ) {");
            out.pushIndent();
            for (i = 0; i < this.fragments.size(); ++i) {
                out.printil("case " + i + ":");
                out.pushIndent();
                out.printil("invoke" + i + "( out );");
                out.printil("break;");
                out.popIndent();
            }
            out.popIndent();
            out.printil("}");
            Generator.printilThreePart(out, "jspContext.getELContext().putContext(", "jakarta.servlet.jsp.JspContext", ".class,_jspx_saved_JspContext);");
            out.popIndent();
            out.printil("}");
            out.printil("catch( java.lang.Throwable e ) {");
            out.pushIndent();
            Generator.printilThreePart(out, "if (e instanceof ", "jakarta.servlet.jsp.SkipPageException", ")");
            Generator.printilThreePart(out, "    throw (", "jakarta.servlet.jsp.SkipPageException", ") e;");
            Generator.printilThreePart(out, "throw new ", "jakarta.servlet.jsp.JspException", "( e );");
            out.popIndent();
            out.printil("}");
            out.printil("finally {");
            out.pushIndent();
            out.printil("if( writer != null ) {");
            out.pushIndent();
            out.printil("this.jspContext.popBody();");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
        }

        public String toString() {
            return this.classBuffer.toString();
        }

        public void adjustJavaLines(int offset) {
            for (int i = 0; i < this.fragments.size(); ++i) {
                Fragment fragment = this.fragments.get(i);
                fragment.getGenBuffer().adjustJavaLines(offset);
            }
        }

        private static class Fragment {
            private GenBuffer genBuffer;
            private int id;

            public Fragment(int id, Node node) {
                this.id = id;
                this.genBuffer = new GenBuffer(null, node.getBody());
            }

            public GenBuffer getGenBuffer() {
                return this.genBuffer;
            }

            public int getId() {
                return this.id;
            }
        }
    }

    private static class GenBuffer {
        private Node node;
        private Node.Nodes body;
        private CharArrayWriter charWriter;
        protected ServletWriter out;

        GenBuffer() {
            this(null, null);
        }

        GenBuffer(Node n, Node.Nodes b) {
            this.node = n;
            this.body = b;
            if (this.body != null) {
                this.body.setGeneratedInBuffer(true);
            }
            this.charWriter = new CharArrayWriter();
            this.out = new ServletWriter(new PrintWriter(this.charWriter));
        }

        public ServletWriter getOut() {
            return this.out;
        }

        public String toString() {
            return this.charWriter.toString();
        }

        public void adjustJavaLines(final int offset) {
            if (this.node != null) {
                GenBuffer.adjustJavaLine(this.node, offset);
            }
            if (this.body != null) {
                try {
                    this.body.visit(new Node.Visitor(){

                        @Override
                        public void doVisit(Node n) {
                            GenBuffer.adjustJavaLine(n, offset);
                        }

                        @Override
                        public void visit(Node.CustomTag n) throws JasperException {
                            Node.Nodes b = n.getBody();
                            if (b != null && !b.isGeneratedInBuffer()) {
                                b.visit(this);
                            }
                        }
                    });
                }
                catch (JasperException jasperException) {
                    // empty catch block
                }
            }
        }

        private static void adjustJavaLine(Node n, int offset) {
            if (n.getBeginJavaLine() > 0) {
                n.setBeginJavaLine(n.getBeginJavaLine() + offset);
                n.setEndJavaLine(n.getEndJavaLine() + offset);
            }
        }
    }

    private static class TagHandlerInfo {
        private Hashtable<String, Method> methodMaps;
        private Hashtable<String, Class<?>> propertyEditorMaps;
        private Class<?> tagHandlerClass;

        TagHandlerInfo(Node n, Class<?> tagHandlerClass, ErrorDispatcher err) throws JasperException {
            this.tagHandlerClass = tagHandlerClass;
            this.methodMaps = new Hashtable();
            this.propertyEditorMaps = new Hashtable();
            try {
                BeanInfo tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
                PropertyDescriptor[] pd = tagClassInfo.getPropertyDescriptors();
                for (int i = 0; i < pd.length; ++i) {
                    if (pd[i].getWriteMethod() != null) {
                        this.methodMaps.put(pd[i].getName(), pd[i].getWriteMethod());
                    }
                    if (pd[i].getPropertyEditorClass() == null) continue;
                    this.propertyEditorMaps.put(pd[i].getName(), pd[i].getPropertyEditorClass());
                }
            }
            catch (IntrospectionException ie) {
                err.jspError(n, (Exception)ie, JasperMessages.MESSAGES.errorIntrospectingTagHandler(tagHandlerClass.getName()), new String[0]);
            }
        }

        public Method getSetterMethod(String attrName) {
            return this.methodMaps.get(attrName);
        }

        public Class<?> getPropertyEditorClass(String attrName) {
            return this.propertyEditorMaps.get(attrName);
        }

        public Class<?> getTagHandlerClass() {
            return this.tagHandlerClass;
        }
    }

    private class GenerateVisitor
    extends Node.Visitor {
        private final Hashtable<String, Hashtable<String, TagHandlerInfo>> handlerInfos;
        private final Hashtable<String, Integer> tagVarNumbers;
        private String parent;
        private boolean isSimpleTagParent;
        private String pushBodyCountVar;
        private String simpleTagHandlerVar;
        private boolean isSimpleTagHandler;
        private boolean isFragment;
        private final boolean isTagFile;
        private ServletWriter out;
        private final ArrayList<GenBuffer> methodsBuffered;
        private final FragmentHelperClass fragmentHelperClass;
        private int methodNesting;
        private int charArrayCount;
        private HashMap<String, String> textMap;
        private static final String DOUBLE_QUOTE = "\\\"";

        public GenerateVisitor(boolean isTagFile, ServletWriter out, ArrayList<GenBuffer> methodsBuffered, FragmentHelperClass fragmentHelperClass) {
            this.isTagFile = isTagFile;
            this.out = out;
            this.methodsBuffered = methodsBuffered;
            this.fragmentHelperClass = fragmentHelperClass;
            this.methodNesting = 0;
            this.handlerInfos = new Hashtable();
            this.tagVarNumbers = new Hashtable();
            this.textMap = new HashMap();
        }

        private String attributeValue(Node.JspAttribute attr, boolean encode, Class<?> expectedType) {
            String v = attr.getValue();
            if (!attr.isNamedAttribute() && v == null) {
                return "";
            }
            if (attr.isExpression()) {
                if (encode) {
                    return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(String.valueOf(" + v + "), org.apache.jasper.runtime.JspRuntimeLibrary.getURLCharacterEncoding(request))";
                }
                return v;
            }
            if (attr.isELInterpreterInput()) {
                v = Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, v, expectedType, attr.getEL().getMapName());
                if (encode) {
                    return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + v + ", org.apache.jasper.runtime.JspRuntimeLibrary.getURLCharacterEncoding(request))";
                }
                return v;
            }
            if (attr.isNamedAttribute()) {
                return attr.getNamedAttributeNode().getTemporaryVariableName();
            }
            if (encode) {
                return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(v) + ", org.apache.jasper.runtime.JspRuntimeLibrary.getURLCharacterEncoding(request))";
            }
            return Generator.quote(v);
        }

        private void printParams(Node n, String pageParam, boolean literal) throws JasperException {
            Object sep = literal ? (pageParam.indexOf(63) > 0 ? "\"&\"" : "\"?\"") : "((" + pageParam + ").indexOf('?')>0? '&': '?')";
            if (n.getBody() != null) {
                class ParamVisitor
                extends Node.Visitor {
                    private String separator;

                    ParamVisitor(String separator) {
                        this.separator = separator;
                    }

                    @Override
                    public void visit(Node.ParamAction n) throws JasperException {
                        GenerateVisitor.this.out.print(" + ");
                        GenerateVisitor.this.out.print(this.separator);
                        GenerateVisitor.this.out.print(" + ");
                        GenerateVisitor.this.out.print("org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(n.getTextAttribute("name")) + ", org.apache.jasper.runtime.JspRuntimeLibrary.getURLCharacterEncoding(request))");
                        GenerateVisitor.this.out.print("+ \"=\" + ");
                        GenerateVisitor.this.out.print(GenerateVisitor.this.attributeValue(n.getValue(), true, String.class));
                        this.separator = "\"&\"";
                    }
                }
                n.getBody().visit(new ParamVisitor((String)sep));
            }
        }

        @Override
        public void visit(Node.Expression n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("out.print(");
            this.out.printMultiLn(n.getText());
            this.out.println(");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.Scriptlet n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printMultiLn(n.getText());
            this.out.println();
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.ELExpression n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            if (!Generator.this.pageInfo.isELIgnored() && n.getEL() != null) {
                this.out.printil("out.write(" + Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, n.getType() + "{" + n.getText() + "}", String.class, n.getEL().getMapName()) + ");");
            } else {
                this.out.printil("out.write(" + Generator.quote(n.getType() + "{" + n.getText() + "}") + ");");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.IncludeAction n) throws JasperException {
            String flush = n.getTextAttribute("flush");
            Node.JspAttribute page = n.getPage();
            boolean isFlush = false;
            if ("true".equals(flush)) {
                isFlush = true;
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            String pageParam = page.isNamedAttribute() ? this.generateNamedAttributeValue(page.getNamedAttributeNode()) : this.attributeValue(page, false, String.class);
            Node.JspBody jspBody = this.findJspBody(n);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(n);
            }
            this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, " + pageParam);
            this.printParams(n, pageParam, page.isLiteral());
            this.out.println(", out, " + isFlush + ");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void prepareParams(Node parent) throws JasperException {
            if (parent == null) {
                return;
            }
            Node.Nodes subelements = parent.getBody();
            if (subelements != null) {
                for (int i = 0; i < subelements.size(); ++i) {
                    Node n = subelements.getNode(i);
                    if (!(n instanceof Node.ParamAction)) continue;
                    Node.Nodes paramSubElements = n.getBody();
                    for (int j = 0; paramSubElements != null && j < paramSubElements.size(); ++j) {
                        Node m = paramSubElements.getNode(j);
                        if (!(m instanceof Node.NamedAttribute)) continue;
                        this.generateNamedAttributeValue((Node.NamedAttribute)m);
                    }
                }
            }
        }

        private Node.JspBody findJspBody(Node parent) {
            Node.JspBody result = null;
            Node.Nodes subelements = parent.getBody();
            for (int i = 0; subelements != null && i < subelements.size(); ++i) {
                Node n = subelements.getNode(i);
                if (!(n instanceof Node.JspBody)) continue;
                result = (Node.JspBody)n;
                break;
            }
            return result;
        }

        @Override
        public void visit(Node.ForwardAction n) throws JasperException {
            Node.JspAttribute page = n.getPage();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("if (true) {");
            this.out.pushIndent();
            String pageParam = page.isNamedAttribute() ? this.generateNamedAttributeValue(page.getNamedAttributeNode()) : this.attributeValue(page, false, String.class);
            Node.JspBody jspBody = this.findJspBody(n);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(n);
            }
            this.out.printin("_jspx_page_context.forward(");
            this.out.print(pageParam);
            this.printParams(n, pageParam, page.isLiteral());
            this.out.println(");");
            if (this.isTagFile || this.isFragment) {
                Generator.printilThreePart(this.out, "throw new ", "jakarta.servlet.jsp.SkipPageException", "();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.out.printil("}");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.GetProperty n) throws JasperException {
            String name = n.getTextAttribute("name");
            String property = n.getTextAttribute("property");
            n.setBeginJavaLine(this.out.getJavaLine());
            if (Generator.this.beanInfo.checkVariable(name)) {
                Class<?> bean = Generator.this.beanInfo.getBeanType(name);
                String beanName = bean.getCanonicalName();
                Method meth = JspRuntimeLibrary.getReadMethod(bean, property);
                String methodName = meth.getName();
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString((((" + beanName + ")_jspx_page_context.findAttribute(\"" + name + "\"))." + methodName + "())));");
            } else if (!STRICT_GET_PROPERTY || Generator.this.varInfoNames.contains(name)) {
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString(org.apache.jasper.runtime.JspRuntimeLibrary.handleGetProperty(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\")));");
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("file:");
                msg.append(n.getStart());
                msg.append(" jsp:getProperty for bean with name '");
                msg.append(name);
                msg.append("'. Name was not previously introduced as per JSP.5.3");
                throw new JasperException(msg.toString());
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.SetProperty n) throws JasperException {
            String name = n.getTextAttribute("name");
            String property = n.getTextAttribute("property");
            String param = n.getTextAttribute("param");
            Node.JspAttribute value = n.getValue();
            n.setBeginJavaLine(this.out.getJavaLine());
            if ("*".equals(property)) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspect(_jspx_page_context.findAttribute(\"" + name + "\"), request);");
            } else if (value == null) {
                if (param == null) {
                    param = property;
                }
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\", request.getParameter(\"" + param + "\"), request, \"" + param + "\", false);");
            } else if (value.isExpression()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetProperty(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\",");
                this.out.print(this.attributeValue(value, false, null));
                this.out.println(");");
            } else if (value.isELInterpreterInput()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetPropertyExpression(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\", " + Generator.quote(value.getValue()) + ", _jspx_page_context, " + value.getEL().getMapName() + ");");
            } else if (value.isNamedAttribute()) {
                String valueVarName = this.generateNamedAttributeValue(value.getNamedAttributeNode());
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\", " + valueVarName + ", null, null, false);");
            } else {
                this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + name + "\"), \"" + property + "\", ");
                this.out.print(this.attributeValue(value, false, null));
                this.out.println(", null, null, false);");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.UseBean n) throws JasperException {
            String name = n.getTextAttribute("id");
            String scope = n.getTextAttribute("scope");
            String klass = n.getTextAttribute("class");
            String type = n.getTextAttribute("type");
            Node.JspAttribute beanName = n.getBeanName();
            boolean generateNew = false;
            String canonicalName = null;
            if (klass != null) {
                block17: {
                    try {
                        Class<?> bean = Generator.this.ctxt.getClassLoader().loadClass(klass);
                        canonicalName = klass.indexOf(36) >= 0 ? bean.getCanonicalName() : klass;
                        int modifiers = bean.getModifiers();
                        if (!Modifier.isPublic(modifiers) || Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
                            throw new Exception("Invalid bean class modifier");
                        }
                        bean.getConstructor(new Class[0]);
                        generateNew = true;
                    }
                    catch (Exception e) {
                        if (Generator.this.ctxt.getOptions().getErrorOnUseBeanInvalidClassAttribute()) {
                            Generator.this.err.jspError((Node)n, JasperMessages.MESSAGES.invalidUseBeanAttributeClass(klass), new String[0]);
                        }
                        if (canonicalName != null) break block17;
                        canonicalName = klass.replace('$', '.');
                    }
                }
                if (type == null) {
                    type = canonicalName;
                }
            }
            String scopename = "jakarta.servlet.jsp.PageContext.PAGE_SCOPE";
            String lock = null;
            if ("request".equals(scope)) {
                scopename = "jakarta.servlet.jsp.PageContext.REQUEST_SCOPE";
            } else if ("session".equals(scope)) {
                scopename = "jakarta.servlet.jsp.PageContext.SESSION_SCOPE";
                lock = "session";
            } else if ("application".equals(scope)) {
                scopename = "jakarta.servlet.jsp.PageContext.APPLICATION_SCOPE";
                lock = "application";
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin(type);
            this.out.print(' ');
            this.out.print(name);
            this.out.println(" = null;");
            if (lock != null) {
                this.out.printin("synchronized (");
                this.out.print(lock);
                this.out.println(") {");
                this.out.pushIndent();
            }
            this.out.printin(name);
            this.out.print(" = (");
            this.out.print(type);
            this.out.print(") _jspx_page_context.getAttribute(");
            this.out.print(Generator.quote(name));
            this.out.print(", ");
            this.out.print(scopename);
            this.out.println(");");
            this.out.printin("if (");
            this.out.print(name);
            this.out.println(" == null){");
            this.out.pushIndent();
            if (klass == null && beanName == null) {
                this.out.printin("throw new java.lang.InstantiationException(\"bean ");
                this.out.print(name);
                this.out.println(" not found within scope\");");
            } else {
                if (!generateNew) {
                    String binaryName = beanName != null ? (beanName.isNamedAttribute() ? this.generateNamedAttributeValue(beanName.getNamedAttributeNode()) : this.attributeValue(beanName, false, String.class)) : Generator.quote(klass);
                    this.out.printil("try {");
                    this.out.pushIndent();
                    this.out.printin(name);
                    this.out.print(" = (");
                    this.out.print(type);
                    this.out.print(") java.beans.Beans.instantiate(");
                    this.out.print("this.getClass().getClassLoader(), ");
                    this.out.print(binaryName);
                    this.out.println(");");
                    this.out.popIndent();
                    this.out.printil("} catch (java.lang.ClassNotFoundException exc) {");
                    this.out.pushIndent();
                    this.out.printil("throw new java.lang.InstantiationException(exc.getMessage());");
                    this.out.popIndent();
                    this.out.printil("} catch (java.lang.Exception exc) {");
                    this.out.pushIndent();
                    Generator.printinThreePart(this.out, "throw new ", "jakarta.servlet.ServletException", "(");
                    this.out.print("\"Cannot create bean of class \" + ");
                    this.out.print(binaryName);
                    this.out.println(", exc);");
                    this.out.popIndent();
                    this.out.printil("}");
                } else {
                    this.out.printin(name);
                    this.out.print(" = new ");
                    this.out.print(canonicalName);
                    this.out.println("();");
                }
                this.out.printin("_jspx_page_context.setAttribute(");
                this.out.print(Generator.quote(name));
                this.out.print(", ");
                this.out.print(name);
                this.out.print(", ");
                this.out.print(scopename);
                this.out.println(");");
                this.visitBody(n);
            }
            this.out.popIndent();
            this.out.printil("}");
            if (lock != null) {
                this.out.popIndent();
                this.out.printil("}");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.PlugIn n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.NamedAttribute n) throws JasperException {
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            TagVariableInfo[] tagInfos;
            VariableInfo[] infos;
            if (n.useTagPlugin()) {
                this.generateTagPlugin(n);
                return;
            }
            TagHandlerInfo handlerInfo = this.getTagHandlerInfo(n);
            String baseVar = this.createTagVarName(n.getQName(), n.getPrefix(), n.getLocalName());
            String tagEvalVar = "_jspx_eval_" + baseVar;
            String tagHandlerVar = "_jspx_th_" + baseVar;
            String tagPushBodyCountVar = "_jspx_push_body_count_" + baseVar;
            ServletWriter outSave = null;
            Node.ChildInfo ci = n.getChildInfo();
            if (ci.isScriptless() && !ci.hasScriptingVars()) {
                String tagMethod = "_jspx_meth_" + baseVar;
                this.out.printin("if (");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("_jspx_page_context");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println("))");
                this.out.pushIndent();
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
                this.out.popIndent();
                outSave = this.out;
                GenBuffer genBuffer = new GenBuffer(n, n.implementsSimpleTag() ? null : n.getBody());
                this.methodsBuffered.add(genBuffer);
                this.out = genBuffer.getOut();
                ++this.methodNesting;
                this.out.println();
                this.out.pushIndent();
                this.out.printin("private boolean ");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print("jakarta.servlet.jsp.tagext.JspTag");
                    this.out.print(" ");
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("jakarta.servlet.jsp.PageContext");
                this.out.print(" _jspx_page_context");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", int[] ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println(")");
                this.out.printil("        throws java.lang.Throwable {");
                this.out.pushIndent();
                if (!this.isTagFile) {
                    Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.PageContext", " pageContext = _jspx_page_context;");
                }
                Generator.printilTwoPart(this.out, "jakarta.servlet.jsp.JspWriter", " out = _jspx_page_context.getOut();");
                Generator.generateLocalVariables(this.out, n);
            }
            if ((infos = n.getVariableInfos()) != null && infos.length > 0) {
                for (int i = 0; i < infos.length; ++i) {
                    VariableInfo info = infos[i];
                    if (info == null || info.getVarName() == null) continue;
                    Generator.this.pageInfo.getVarInfoNames().add(info.getVarName());
                }
            }
            if ((tagInfos = n.getTagVariableInfos()) != null && tagInfos.length > 0) {
                for (int i = 0; i < tagInfos.length; ++i) {
                    TagVariableInfo tagInfo = tagInfos[i];
                    if (tagInfo == null) continue;
                    String name = tagInfo.getNameGiven();
                    if (name == null) {
                        String nameFromAttribute = tagInfo.getNameFromAttribute();
                        name = n.getAttributeValue(nameFromAttribute);
                    }
                    Generator.this.pageInfo.getVarInfoNames().add(name);
                }
            }
            if (n.implementsSimpleTag()) {
                this.generateCustomDoTag(n, handlerInfo, tagHandlerVar);
            } else {
                this.generateCustomStart(n, handlerInfo, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
                String tmpParent = this.parent;
                this.parent = tagHandlerVar;
                boolean isSimpleTagParentSave = this.isSimpleTagParent;
                this.isSimpleTagParent = false;
                String tmpPushBodyCountVar = null;
                if (n.implementsTryCatchFinally()) {
                    tmpPushBodyCountVar = this.pushBodyCountVar;
                    this.pushBodyCountVar = tagPushBodyCountVar;
                }
                boolean tmpIsSimpleTagHandler = this.isSimpleTagHandler;
                this.isSimpleTagHandler = false;
                this.visitBody(n);
                this.parent = tmpParent;
                this.isSimpleTagParent = isSimpleTagParentSave;
                if (n.implementsTryCatchFinally()) {
                    this.pushBodyCountVar = tmpPushBodyCountVar;
                }
                this.isSimpleTagHandler = tmpIsSimpleTagHandler;
                this.generateCustomEnd(n, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
            }
            if (ci.isScriptless() && !ci.hasScriptingVars()) {
                if (this.methodNesting > 0) {
                    this.out.printil("return false;");
                }
                this.out.popIndent();
                this.out.printil("}");
                this.out.popIndent();
                --this.methodNesting;
                this.out = outSave;
            }
        }

        @Override
        public void visit(Node.UninterpretedTag n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("out.write(\"<");
            this.out.print(n.getQName());
            Attributes attrs = n.getNonTaglibXmlnsAttributes();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.out.print(" ");
                    this.out.print(attrs.getQName(i));
                    this.out.print("=");
                    this.out.print(DOUBLE_QUOTE);
                    this.out.print(Generator.escape(attrs.getValue(i).replace("\"", "&quot;")));
                    this.out.print(DOUBLE_QUOTE);
                }
            }
            if ((attrs = n.getAttributes()) != null) {
                Node.JspAttribute[] jspAttrs = n.getJspAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.out.print(" ");
                    this.out.print(attrs.getQName(i));
                    this.out.print("=");
                    if (jspAttrs[i].isELInterpreterInput()) {
                        this.out.print("\\\"\" + ");
                        String debug = this.attributeValue(jspAttrs[i], false, String.class);
                        this.out.print(debug);
                        this.out.print(" + \"\\\"");
                        continue;
                    }
                    this.out.print(DOUBLE_QUOTE);
                    this.out.print(Generator.escape(jspAttrs[i].getValue().replace("\"", "&quot;")));
                    this.out.print(DOUBLE_QUOTE);
                }
            }
            if (n.getBody() != null) {
                this.out.println(">\");");
                this.visitBody(n);
                this.out.printin("out.write(\"</");
                this.out.print(n.getQName());
                this.out.println(">\");");
            } else {
                this.out.println("/>\");");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.JspElement n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            Hashtable<String, CallSite> map = new Hashtable<String, CallSite>();
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                String value = null;
                String nvp = null;
                if (attrs[i].isNamedAttribute()) {
                    String omit;
                    Node.NamedAttribute attr = attrs[i].getNamedAttributeNode();
                    Node.JspAttribute omitAttr = attr.getOmit();
                    if (omitAttr == null) {
                        omit = "false";
                    } else {
                        omit = this.attributeValue(omitAttr, false, Boolean.TYPE);
                        if ("true".equals(omit)) continue;
                    }
                    value = this.generateNamedAttributeValue(attrs[i].getNamedAttributeNode());
                    nvp = "false".equals(omit) ? " + \" " + attrs[i].getName() + "=\\\"\" + " + value + " + \"\\\"\"" : " + (java.lang.Boolean.valueOf(" + omit + ")?\"\":\" " + attrs[i].getName() + "=\\\"\" + " + value + " + \"\\\"\")";
                } else {
                    value = this.attributeValue(attrs[i], false, Object.class);
                    nvp = " + \" " + attrs[i].getName() + "=\\\"\" + " + value + " + \"\\\"\"";
                }
                map.put(attrs[i].getName(), (CallSite)((Object)nvp));
            }
            String elemName = this.attributeValue(n.getNameAttribute(), false, String.class);
            this.out.printin("out.write(\"<\"");
            this.out.print(" + " + elemName);
            Enumeration enumeration = map.keys();
            while (enumeration.hasMoreElements()) {
                String attrName = (String)enumeration.nextElement();
                this.out.print((String)map.get(attrName));
            }
            boolean hasBody = false;
            Node.Nodes subelements = n.getBody();
            if (subelements != null) {
                for (int i = 0; i < subelements.size(); ++i) {
                    Node subelem = subelements.getNode(i);
                    if (subelem instanceof Node.NamedAttribute) continue;
                    hasBody = true;
                    break;
                }
            }
            if (hasBody) {
                this.out.println(" + \">\");");
                n.setEndJavaLine(this.out.getJavaLine());
                this.visitBody(n);
                this.out.printin("out.write(\"</\"");
                this.out.print(" + " + elemName);
                this.out.println(" + \">\");");
            } else {
                this.out.println(" + \"/>\");");
                n.setEndJavaLine(this.out.getJavaLine());
            }
        }

        @Override
        public void visit(Node.TemplateText n) throws JasperException {
            String text = n.getText();
            int textSize = text.length();
            if (textSize == 0) {
                return;
            }
            if (textSize <= 3) {
                n.setBeginJavaLine(this.out.getJavaLine());
                int lineInc = 0;
                for (int i = 0; i < textSize; ++i) {
                    char ch = text.charAt(i);
                    this.out.printil("out.write(" + Generator.quote(ch) + ");");
                    if (i > 0) {
                        n.addSmap(lineInc);
                    }
                    if (ch != '\n') continue;
                    ++lineInc;
                }
                n.setEndJavaLine(this.out.getJavaLine());
                return;
            }
            if (Generator.this.ctxt.getOptions().genStringAsCharArray()) {
                int len;
                ServletWriter caOut;
                if (Generator.this.charArrayBuffer == null) {
                    Generator.this.charArrayBuffer = new GenBuffer();
                    caOut = Generator.this.charArrayBuffer.getOut();
                    caOut.pushIndent();
                    this.textMap = new HashMap();
                } else {
                    caOut = Generator.this.charArrayBuffer.getOut();
                }
                int textLength = text.length();
                for (int textIndex = 0; textIndex < textLength; textIndex += len) {
                    len = 0;
                    len = textLength - textIndex > 16384 ? 16384 : textLength - textIndex;
                    String output = text.substring(textIndex, textIndex + len);
                    Object charArrayName = this.textMap.get(output);
                    if (charArrayName == null) {
                        charArrayName = "_jspx_char_array_" + this.charArrayCount++;
                        this.textMap.put(output, (String)charArrayName);
                        caOut.printin("static char[] ");
                        caOut.print((String)charArrayName);
                        caOut.print(" = ");
                        caOut.print(Generator.quote(output));
                        caOut.println(".toCharArray();");
                    }
                    n.setBeginJavaLine(this.out.getJavaLine());
                    this.out.printil("out.write(" + (String)charArrayName + ");");
                    n.setEndJavaLine(this.out.getJavaLine());
                }
                return;
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin();
            StringBuilder sb = new StringBuilder("out.write(\"");
            int initLength = sb.length();
            int count = 1024;
            int srcLine = 0;
            block9: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                --count;
                switch (ch) {
                    case '\"': {
                        sb.append('\\').append('\"');
                        continue block9;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        continue block9;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        continue block9;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        ++srcLine;
                        if (Generator.this.breakAtLF || count < 0) {
                            sb.append("\");");
                            this.out.println(sb.toString());
                            if (i < text.length() - 1) {
                                this.out.printin();
                            }
                            sb.setLength(initLength);
                            count = 1024;
                        }
                        n.addSmap(srcLine);
                        continue block9;
                    }
                    case '\t': {
                        sb.append('\\').append('t');
                        continue block9;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            if (sb.length() > initLength) {
                sb.append("\");");
                this.out.println(sb.toString());
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.JspBody n) throws JasperException {
            if (n.getBody() != null) {
                if (this.isSimpleTagHandler) {
                    this.out.printin(this.simpleTagHandlerVar);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(n, this.simpleTagHandlerVar);
                    this.out.println(");");
                } else {
                    this.visitBody(n);
                }
            }
        }

        @Override
        public void visit(Node.InvokeAction n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String varReaderAttr = n.getTextAttribute("varReader");
            String varAttr = n.getTextAttribute("var");
            if (varReaderAttr != null || varAttr != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printin("if (");
            this.out.print(Generator.this.toGetterMethod(n.getTextAttribute("fragment")));
            this.out.println(" != null) {");
            this.out.pushIndent();
            this.out.printin(Generator.this.toGetterMethod(n.getTextAttribute("fragment")));
            this.out.println(".invoke(_jspx_sout);");
            this.out.popIndent();
            this.out.printil("}");
            if (varReaderAttr != null || varAttr != null) {
                String scopeName = n.getTextAttribute("scope");
                this.out.printin("_jspx_page_context.setAttribute(");
                if (varReaderAttr != null) {
                    this.out.print(Generator.quote(varReaderAttr));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(varAttr));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (scopeName != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(scopeName));
                }
                this.out.println(");");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.DoBodyAction n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String varReaderAttr = n.getTextAttribute("varReader");
            String varAttr = n.getTextAttribute("var");
            if (varReaderAttr != null || varAttr != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printil("if (getJspBody() != null)");
            this.out.pushIndent();
            this.out.printil("getJspBody().invoke(_jspx_sout);");
            this.out.popIndent();
            if (varReaderAttr != null || varAttr != null) {
                String scopeName = n.getTextAttribute("scope");
                this.out.printin("_jspx_page_context.setAttribute(");
                if (varReaderAttr != null) {
                    this.out.print(Generator.quote(varReaderAttr));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(varAttr));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (scopeName != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(scopeName));
                }
                this.out.println(");");
            }
            Generator.printilThreePart(this.out, "jspContext.getELContext().putContext(", "jakarta.servlet.jsp.JspContext", ".class,getJspContext());");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.AttributeGenerator n) throws JasperException {
            Node.CustomTag tag = n.getTag();
            Node.JspAttribute[] attrs = tag.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(n.getName())) continue;
                this.out.print(this.evaluateAttribute(this.getTagHandlerInfo(tag), attrs[i], tag, null));
                break;
            }
        }

        private TagHandlerInfo getTagHandlerInfo(Node.CustomTag n) throws JasperException {
            TagHandlerInfo handlerInfo;
            Hashtable<String, TagHandlerInfo> handlerInfosByShortName = this.handlerInfos.get(n.getPrefix());
            if (handlerInfosByShortName == null) {
                handlerInfosByShortName = new Hashtable();
                this.handlerInfos.put(n.getPrefix(), handlerInfosByShortName);
            }
            if ((handlerInfo = handlerInfosByShortName.get(n.getLocalName())) == null) {
                handlerInfo = new TagHandlerInfo(n, n.getTagHandlerClass(), Generator.this.err);
                handlerInfosByShortName.put(n.getLocalName(), handlerInfo);
            }
            return handlerInfo;
        }

        private void generateTagPlugin(Node.CustomTag n) throws JasperException {
            if (n.getAtSTag() != null) {
                n.getAtSTag().visit(this);
            }
            this.visitBody(n);
            if (n.getAtETag() != null) {
                n.getAtETag().visit(this);
            }
        }

        private void generateCustomStart(Node.CustomTag n, TagHandlerInfo handlerInfo, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) throws JasperException {
            Class<?> tagHandlerClass = handlerInfo.getTagHandlerClass();
            this.out.printin("//  ");
            this.out.println(n.getQName());
            n.setBeginJavaLine(this.out.getJavaLine());
            this.declareScriptingVars(n, 1);
            this.saveScriptingVars(n, 1);
            String tagHandlerClassName = tagHandlerClass.getCanonicalName();
            if (Generator.this.isPoolingEnabled && !n.implementsJspIdConsumer()) {
                this.out.printin(tagHandlerClassName);
                this.out.print(" ");
                this.out.print(tagHandlerVar);
                this.out.print(" = ");
                this.out.print("(");
                this.out.print(tagHandlerClassName);
                this.out.print(") ");
                this.out.print(n.getTagHandlerPoolName());
                this.out.print(".get(");
                this.out.print(tagHandlerClassName);
                this.out.println(".class);");
            } else {
                this.writeNewInstance(tagHandlerVar, tagHandlerClassName);
            }
            this.out.printil("try {");
            this.out.pushIndent();
            this.generateSetters(n, tagHandlerVar, handlerInfo, false);
            if (n.implementsJspIdConsumer()) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setJspId(\"");
                this.out.print(Generator.this.createJspId());
                this.out.println("\");");
            }
            if (n.implementsTryCatchFinally()) {
                this.out.printin("int[] ");
                this.out.print(tagPushBodyCountVar);
                this.out.println(" = new int[] { 0 };");
                this.out.printil("try {");
                this.out.pushIndent();
            }
            this.out.printin("int ");
            this.out.print(tagEvalVar);
            this.out.print(" = ");
            this.out.print(tagHandlerVar);
            this.out.println(".doStartTag();");
            if (!n.implementsBodyTag()) {
                this.syncScriptingVars(n, 1);
            }
            if (!n.hasEmptyBody()) {
                this.out.printin("if (");
                this.out.print(tagEvalVar);
                Generator.printlnThreePart(this.out, " != ", "jakarta.servlet.jsp.tagext.Tag", ".SKIP_BODY) {");
                this.out.pushIndent();
                this.declareScriptingVars(n, 0);
                this.saveScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    Generator.printlnThreePart(this.out, " != ", "jakarta.servlet.jsp.tagext.Tag", ".EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    this.out.printil("out = _jspx_page_context.pushBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("[0]++;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]++;");
                    }
                    this.out.printin(tagHandlerVar);
                    Generator.printilThreePart(this.out, ".setBodyContent((", "jakarta.servlet.jsp.tagext.BodyContent", ") out);");
                    this.out.printin(tagHandlerVar);
                    this.out.println(".doInitBody();");
                    this.out.popIndent();
                    this.out.printil("}");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                } else {
                    this.syncScriptingVars(n, 0);
                }
                if (n.implementsIterationTag()) {
                    this.out.printil("do {");
                    this.out.pushIndent();
                }
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void writeNewInstance(String tagHandlerVar, String tagHandlerClassName) {
            if (Constants.USE_INSTANCE_MANAGER_FOR_TAGS) {
                this.out.printin(tagHandlerClassName);
                this.out.print(" ");
                this.out.print(tagHandlerVar);
                this.out.print(" = (");
                this.out.print(tagHandlerClassName);
                this.out.print(")");
                this.out.print(VAR_INSTANCEMANAGER);
                this.out.print(".newInstance(\"");
                this.out.print(tagHandlerClassName);
                this.out.println("\", this.getClass().getClassLoader());");
            } else {
                this.out.printin(tagHandlerClassName);
                this.out.print(" ");
                this.out.print(tagHandlerVar);
                this.out.print(" = (");
                this.out.print("new ");
                this.out.print(tagHandlerClassName);
                this.out.println("());");
                this.out.printin(VAR_INSTANCEMANAGER);
                this.out.print(".newInstance(");
                this.out.print(tagHandlerVar);
                this.out.println(");");
            }
        }

        private void writeDestroyInstance(String tagHandlerVar) {
            this.out.printin(VAR_INSTANCEMANAGER);
            this.out.print(".destroyInstance(");
            this.out.print(tagHandlerVar);
            this.out.println(");");
        }

        private void generateCustomEnd(Node.CustomTag n, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) {
            if (!n.hasEmptyBody()) {
                if (n.implementsIterationTag()) {
                    this.out.printin("int evalDoAfterBody = ");
                    this.out.print(tagHandlerVar);
                    this.out.println(".doAfterBody();");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                    Generator.printilThreePart(this.out, "if (evalDoAfterBody != ", "jakarta.servlet.jsp.tagext.BodyTag", ".EVAL_BODY_AGAIN)");
                    this.out.pushIndent();
                    this.out.printil("break;");
                    this.out.popIndent();
                    this.out.popIndent();
                    this.out.printil("} while (true);");
                }
                this.restoreScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    Generator.printlnThreePart(this.out, " != ", "jakarta.servlet.jsp.tagext.Tag", ".EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    this.out.printil("out = _jspx_page_context.popBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("[0]--;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]--;");
                    }
                    this.out.popIndent();
                    this.out.printil("}");
                }
                this.out.popIndent();
                this.out.printil("}");
            }
            this.out.printin("if (");
            this.out.print(tagHandlerVar);
            Generator.printlnThreePart(this.out, ".doEndTag() == ", "jakarta.servlet.jsp.tagext.Tag", ".SKIP_PAGE) {");
            this.out.pushIndent();
            if (this.isTagFile || this.isFragment) {
                Generator.printilThreePart(this.out, "throw new ", "jakarta.servlet.jsp.SkipPageException", "();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.syncScriptingVars(n, 1);
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("} catch (java.lang.Throwable _jspx_exception) {");
                this.out.pushIndent();
                this.out.printin("while (");
                this.out.print(tagPushBodyCountVar);
                this.out.println("[0]-- > 0)");
                this.out.pushIndent();
                this.out.printil("out = _jspx_page_context.popBody();");
                this.out.popIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doCatch(_jspx_exception);");
                this.out.popIndent();
                this.out.printil("} finally {");
                this.out.pushIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doFinally();");
            }
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("}");
            }
            this.out.popIndent();
            this.out.printil("} finally {");
            this.out.pushIndent();
            if (Generator.this.isPoolingEnabled && !n.implementsJspIdConsumer()) {
                this.out.printin(n.getTagHandlerPoolName());
                this.out.print(".reuse(");
                this.out.print(tagHandlerVar);
                this.out.println(");");
            } else {
                this.out.printin(tagHandlerVar);
                this.out.println(".release();");
                this.writeDestroyInstance(tagHandlerVar);
            }
            this.out.popIndent();
            this.out.printil("}");
            this.declareScriptingVars(n, 2);
            this.syncScriptingVars(n, 2);
            this.restoreScriptingVars(n, 1);
        }

        private void generateCustomDoTag(Node.CustomTag n, TagHandlerInfo handlerInfo, String tagHandlerVar) throws JasperException {
            Class<?> tagHandlerClass = handlerInfo.getTagHandlerClass();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("//  ");
            this.out.println(n.getQName());
            this.declareScriptingVars(n, 1);
            this.saveScriptingVars(n, 1);
            String tagHandlerClassName = tagHandlerClass.getCanonicalName();
            this.writeNewInstance(tagHandlerVar, tagHandlerClassName);
            this.generateSetters(n, tagHandlerVar, handlerInfo, true);
            if (n.implementsJspIdConsumer()) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setJspId(\"");
                this.out.print(Generator.this.createJspId());
                this.out.println("\");");
            }
            if (this.findJspBody(n) == null) {
                if (!n.hasEmptyBody()) {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(n, tagHandlerVar);
                    this.out.println(");");
                }
            } else {
                String tmpTagHandlerVar = this.simpleTagHandlerVar;
                this.simpleTagHandlerVar = tagHandlerVar;
                boolean tmpIsSimpleTagHandler = this.isSimpleTagHandler;
                this.isSimpleTagHandler = true;
                this.visitBody(n);
                this.simpleTagHandlerVar = tmpTagHandlerVar;
                this.isSimpleTagHandler = tmpIsSimpleTagHandler;
            }
            this.out.printin(tagHandlerVar);
            this.out.println(".doTag();");
            this.restoreScriptingVars(n, 1);
            this.syncScriptingVars(n, 1);
            this.declareScriptingVars(n, 2);
            this.syncScriptingVars(n, 2);
            this.writeDestroyInstance(tagHandlerVar);
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void declareScriptingVars(Node.CustomTag n, int scope) {
            if (this.isFragment) {
                return;
            }
            List<Object> vec = n.getScriptingVars(scope);
            if (vec != null) {
                for (int i = 0; i < vec.size(); ++i) {
                    Object elem = vec.get(i);
                    if (elem instanceof VariableInfo) {
                        VariableInfo varInfo = (VariableInfo)elem;
                        if (!varInfo.getDeclare()) continue;
                        this.out.printin(varInfo.getClassName());
                        this.out.print(" ");
                        this.out.print(varInfo.getVarName());
                        this.out.println(" = null;");
                        continue;
                    }
                    TagVariableInfo tagVarInfo = (TagVariableInfo)elem;
                    if (!tagVarInfo.getDeclare()) continue;
                    String varName = tagVarInfo.getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfo.getNameFromAttribute());
                    } else if (tagVarInfo.getNameFromAttribute() != null) continue;
                    this.out.printin(tagVarInfo.getClassName());
                    this.out.print(" ");
                    this.out.print(varName);
                    this.out.println(" = null;");
                }
            }
        }

        private void saveScriptingVars(Node.CustomTag n, int scope) {
            if (n.getCustomNestingLevel() == 0) {
                return;
            }
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos.length == 0 && tagVarInfos.length == 0) {
                return;
            }
            List<Object> declaredVariables = n.getScriptingVars(scope);
            if (varInfos.length > 0) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope || declaredVariables.contains(varInfos[i])) continue;
                    String varName = varInfos[i].getVarName();
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(tmpVarName);
                    this.out.print(" = ");
                    this.out.print(varName);
                    this.out.println(";");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope || declaredVariables.contains(tagVarInfos[i])) continue;
                    String varName = tagVarInfos[i].getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(tmpVarName);
                    this.out.print(" = ");
                    this.out.print(varName);
                    this.out.println(";");
                }
            }
        }

        private void restoreScriptingVars(Node.CustomTag n, int scope) {
            if (n.getCustomNestingLevel() == 0) {
                return;
            }
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos.length == 0 && tagVarInfos.length == 0) {
                return;
            }
            List<Object> declaredVariables = n.getScriptingVars(scope);
            if (varInfos.length > 0) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope || declaredVariables.contains(varInfos[i])) continue;
                    String varName = varInfos[i].getVarName();
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(varName);
                    this.out.print(" = ");
                    this.out.print(tmpVarName);
                    this.out.println(";");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope || declaredVariables.contains(tagVarInfos[i])) continue;
                    String varName = tagVarInfos[i].getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(varName);
                    this.out.print(" = ");
                    this.out.print(tmpVarName);
                    this.out.println(";");
                }
            }
        }

        private void syncScriptingVars(Node.CustomTag n, int scope) {
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos.length == 0 && tagVarInfos.length == 0) {
                return;
            }
            if (varInfos.length > 0) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope) continue;
                    this.out.printin(varInfos[i].getVarName());
                    this.out.print(" = (");
                    this.out.print(varInfos[i].getClassName());
                    this.out.print(") _jspx_page_context.findAttribute(");
                    this.out.print(Generator.quote(varInfos[i].getVarName()));
                    this.out.println(");");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope) continue;
                    String name = tagVarInfos[i].getNameGiven();
                    if (name == null) {
                        name = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                    this.out.printin(name);
                    this.out.print(" = (");
                    this.out.print(tagVarInfos[i].getClassName());
                    this.out.print(") _jspx_page_context.findAttribute(");
                    this.out.print(Generator.quote(name));
                    this.out.println(");");
                }
            }
        }

        private String getJspContextVar() {
            if (this.isTagFile) {
                return "this.getJspContext()";
            }
            return "_jspx_page_context";
        }

        private String getExpressionFactoryVar() {
            return VAR_EXPRESSIONFACTORY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createTagVarName(String fullName, String prefix, String shortName) {
            String varName;
            Hashtable<String, Integer> hashtable = this.tagVarNumbers;
            synchronized (hashtable) {
                varName = prefix + "_" + shortName + "_";
                if (this.tagVarNumbers.get(fullName) != null) {
                    Integer i = this.tagVarNumbers.get(fullName);
                    varName = varName + i;
                    this.tagVarNumbers.put(fullName, i + 1);
                } else {
                    this.tagVarNumbers.put(fullName, 1);
                    varName = varName + "0";
                }
            }
            return JspUtil.makeJavaIdentifier(varName);
        }

        private String evaluateAttribute(TagHandlerInfo handlerInfo, Node.JspAttribute attr, Node.CustomTag n, String tagHandlerVar) throws JasperException {
            String attrValue = attr.getValue();
            if (attrValue == null) {
                if (attr.isNamedAttribute()) {
                    attrValue = n.checkIfAttributeIsJspFragment(attr.getName()) ? this.generateNamedAttributeJspFragment(attr.getNamedAttributeNode(), tagHandlerVar) : this.generateNamedAttributeValue(attr.getNamedAttributeNode());
                } else {
                    return null;
                }
            }
            String localName = attr.getLocalName();
            Method m = null;
            Class<?>[] c = null;
            if (attr.isDynamic()) {
                c = OBJECT_CLASS;
            } else {
                m = handlerInfo.getSetterMethod(localName);
                if (m == null) {
                    Generator.this.err.jspError((Node)n, JasperMessages.MESSAGES.cannotFindSetterMethod(attr.getName()), new String[0]);
                }
                c = m.getParameterTypes();
            }
            if (!attr.isExpression()) {
                if (attr.isNamedAttribute()) {
                    if (!n.checkIfAttributeIsJspFragment(attr.getName()) && !attr.isDynamic()) {
                        attrValue = this.convertString(c[0], attrValue, localName, handlerInfo.getPropertyEditorClass(localName), true);
                    }
                } else if (attr.isELInterpreterInput()) {
                    StringBuilder sb = new StringBuilder(64);
                    TagAttributeInfo tai = attr.getTagAttributeInfo();
                    sb.append(this.getJspContextVar());
                    sb.append(".getELContext()");
                    String elContext = sb.toString();
                    if (attr.getEL() != null && attr.getEL().getMapName() != null) {
                        sb.setLength(0);
                        sb.append("new org.apache.jasper.el.ELContextWrapper(");
                        sb.append(elContext);
                        sb.append(',');
                        sb.append(attr.getEL().getMapName());
                        sb.append(')');
                        elContext = sb.toString();
                    }
                    sb.setLength(0);
                    sb.append(n.getStart().toString());
                    sb.append(" '");
                    sb.append(attrValue);
                    sb.append('\'');
                    String mark = sb.toString();
                    sb.setLength(0);
                    if (attr.isDeferredInput() || tai != null && ValueExpression.class.getName().equals(tai.getTypeName())) {
                        sb.append("new org.apache.jasper.el.JspValueExpression(");
                        sb.append(Generator.quote(mark));
                        sb.append(',');
                        sb.append(this.getExpressionFactoryVar());
                        sb.append(".createValueExpression(");
                        if (attr.getEL() != null) {
                            sb.append(elContext);
                            sb.append(',');
                        }
                        sb.append(Generator.quote(attrValue));
                        sb.append(',');
                        sb.append(JspUtil.toJavaSourceTypeFromTld(attr.getExpectedTypeName()));
                        sb.append("))");
                        boolean evaluate = false;
                        if (tai != null && tai.canBeRequestTime()) {
                            evaluate = true;
                        }
                        if (attr.isDeferredInput()) {
                            evaluate = false;
                        }
                        if (attr.isDeferredInput() && tai != null && tai.canBeRequestTime()) {
                            boolean bl = evaluate = !attrValue.contains("#{");
                        }
                        if (evaluate) {
                            sb.append(".getValue(");
                            sb.append(this.getJspContextVar());
                            sb.append(".getELContext()");
                            sb.append(")");
                        }
                        attrValue = sb.toString();
                    } else if (attr.isDeferredMethodInput() || tai != null && MethodExpression.class.getName().equals(tai.getTypeName())) {
                        sb.append("new org.apache.jasper.el.JspMethodExpression(");
                        sb.append(Generator.quote(mark));
                        sb.append(',');
                        sb.append(this.getExpressionFactoryVar());
                        sb.append(".createMethodExpression(");
                        sb.append(elContext);
                        sb.append(',');
                        sb.append(Generator.quote(attrValue));
                        sb.append(',');
                        sb.append(JspUtil.toJavaSourceTypeFromTld(attr.getExpectedTypeName()));
                        sb.append(',');
                        sb.append("new java.lang.Class[] {");
                        String[] p = attr.getParameterTypeNames();
                        for (int i = 0; i < p.length; ++i) {
                            sb.append(JspUtil.toJavaSourceTypeFromTld(p[i]));
                            sb.append(',');
                        }
                        if (p.length > 0) {
                            sb.setLength(sb.length() - 1);
                        }
                        sb.append("}))");
                        attrValue = sb.toString();
                    } else {
                        String mapName = attr.getEL() != null ? attr.getEL().getMapName() : null;
                        attrValue = Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, attrValue, c[0], mapName);
                    }
                } else {
                    attrValue = this.convertString(c[0], attrValue, localName, handlerInfo.getPropertyEditorClass(localName), false);
                }
            }
            return attrValue;
        }

        private String generateAliasMap(Node.CustomTag n, String tagHandlerVar) {
            TagVariableInfo[] tagVars = n.getTagVariableInfos();
            String aliasMapVar = null;
            boolean aliasSeen = false;
            for (int i = 0; i < tagVars.length; ++i) {
                String aliasedName;
                String nameFrom = tagVars[i].getNameFromAttribute();
                if (nameFrom == null || (aliasedName = n.getAttributeValue(nameFrom)) == null) continue;
                if (!aliasSeen) {
                    this.out.printin("java.util.HashMap ");
                    aliasMapVar = tagHandlerVar + "_aliasMap";
                    this.out.print(aliasMapVar);
                    this.out.println(" = new java.util.HashMap();");
                    aliasSeen = true;
                }
                this.out.printin(aliasMapVar);
                this.out.print(".put(");
                this.out.print(Generator.quote(tagVars[i].getNameGiven()));
                this.out.print(", ");
                this.out.print(Generator.quote(aliasedName));
                this.out.println(");");
            }
            return aliasMapVar;
        }

        private void generateSetters(Node.CustomTag n, String tagHandlerVar, TagHandlerInfo handlerInfo, boolean simpleTag) throws JasperException {
            if (simpleTag) {
                String aliasMapVar = null;
                if (n.isTagFile()) {
                    aliasMapVar = this.generateAliasMap(n, tagHandlerVar);
                }
                this.out.printin(tagHandlerVar);
                if (aliasMapVar == null) {
                    this.out.println(".setJspContext(_jspx_page_context);");
                } else {
                    this.out.print(".setJspContext(_jspx_page_context, ");
                    this.out.print(aliasMapVar);
                    this.out.println(");");
                }
            } else {
                this.out.printin(tagHandlerVar);
                this.out.println(".setPageContext(_jspx_page_context);");
            }
            if (this.isTagFile && this.parent == null) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setParent(");
                Generator.printThreePart(this.out, "new ", "jakarta.servlet.jsp.tagext.TagAdapter", "(");
                Generator.printThreePart(this.out, "(", "jakarta.servlet.jsp.tagext.SimpleTag", ") this ));");
            } else if (!simpleTag) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setParent(");
                if (this.parent != null) {
                    if (this.isSimpleTagParent) {
                        Generator.printThreePart(this.out, "new ", "jakarta.servlet.jsp.tagext.TagAdapter", "(");
                        Generator.printThreePart(this.out, "(", "jakarta.servlet.jsp.tagext.SimpleTag", ") ");
                        this.out.print(this.parent);
                        this.out.println("));");
                    } else {
                        Generator.printThreePart(this.out, "(", "jakarta.servlet.jsp.tagext.Tag", ") ");
                        this.out.print(this.parent);
                        this.out.println(");");
                    }
                } else {
                    this.out.println("null);");
                }
            } else if (this.parent != null) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setParent(");
                this.out.print(this.parent);
                this.out.println(");");
            }
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                String attrValue = this.evaluateAttribute(handlerInfo, attrs[i], n, tagHandlerVar);
                Mark m = n.getStart();
                this.out.printil("// " + m.getFile() + "(" + m.getLineNumber() + "," + m.getColumnNumber() + ") " + attrs[i].getTagAttributeInfo());
                if (attrs[i].isDynamic()) {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".");
                    this.out.print("setDynamicAttribute(");
                    String uri = attrs[i].getURI();
                    if ("".equals(uri) || uri == null) {
                        this.out.print("null");
                    } else {
                        this.out.print("\"" + attrs[i].getURI() + "\"");
                    }
                    this.out.print(", \"");
                    this.out.print(attrs[i].getLocalName());
                    this.out.print("\", ");
                    this.out.print(attrValue);
                    this.out.println(");");
                    continue;
                }
                this.out.printin(tagHandlerVar);
                this.out.print(".");
                this.out.print(handlerInfo.getSetterMethod(attrs[i].getLocalName()).getName());
                this.out.print("(");
                this.out.print(attrValue);
                this.out.println(");");
            }
        }

        private String convertString(Class<?> c, String s, String attrName, Class<?> propEditorClass, boolean isNamedAttribute) {
            String quoted = s;
            if (!isNamedAttribute) {
                quoted = Generator.quote(s);
            }
            if (propEditorClass != null) {
                String className = c.getCanonicalName();
                return "(" + className + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + className + ".class, \"" + attrName + "\", " + quoted + ", " + propEditorClass.getCanonicalName() + ".class)";
            }
            if (c == String.class) {
                return quoted;
            }
            if (c == Boolean.TYPE) {
                return JspUtil.coerceToPrimitiveBoolean(s, isNamedAttribute);
            }
            if (c == Boolean.class) {
                return JspUtil.coerceToBoolean(s, isNamedAttribute);
            }
            if (c == Byte.TYPE) {
                return JspUtil.coerceToPrimitiveByte(s, isNamedAttribute);
            }
            if (c == Byte.class) {
                return JspUtil.coerceToByte(s, isNamedAttribute);
            }
            if (c == Character.TYPE) {
                return JspUtil.coerceToChar(s, isNamedAttribute);
            }
            if (c == Character.class) {
                return JspUtil.coerceToCharacter(s, isNamedAttribute);
            }
            if (c == Double.TYPE) {
                return JspUtil.coerceToPrimitiveDouble(s, isNamedAttribute);
            }
            if (c == Double.class) {
                return JspUtil.coerceToDouble(s, isNamedAttribute);
            }
            if (c == Float.TYPE) {
                return JspUtil.coerceToPrimitiveFloat(s, isNamedAttribute);
            }
            if (c == Float.class) {
                return JspUtil.coerceToFloat(s, isNamedAttribute);
            }
            if (c == Integer.TYPE) {
                return JspUtil.coerceToInt(s, isNamedAttribute);
            }
            if (c == Integer.class) {
                return JspUtil.coerceToInteger(s, isNamedAttribute);
            }
            if (c == Short.TYPE) {
                return JspUtil.coerceToPrimitiveShort(s, isNamedAttribute);
            }
            if (c == Short.class) {
                return JspUtil.coerceToShort(s, isNamedAttribute);
            }
            if (c == Long.TYPE) {
                return JspUtil.coerceToPrimitiveLong(s, isNamedAttribute);
            }
            if (c == Long.class) {
                return JspUtil.coerceToLong(s, isNamedAttribute);
            }
            if (c == Object.class) {
                return quoted;
            }
            String className = c.getCanonicalName();
            return "(" + className + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromPropertyEditorManager(" + className + ".class, \"" + attrName + "\", " + quoted + ")";
        }

        private String getScopeConstant(String scope) {
            String scopeName = "jakarta.servlet.jsp.PageContext.PAGE_SCOPE";
            if ("request".equals(scope)) {
                scopeName = "jakarta.servlet.jsp.PageContext.REQUEST_SCOPE";
            } else if ("session".equals(scope)) {
                scopeName = "jakarta.servlet.jsp.PageContext.SESSION_SCOPE";
            } else if ("application".equals(scope)) {
                scopeName = "jakarta.servlet.jsp.PageContext.APPLICATION_SCOPE";
            }
            return scopeName;
        }

        private void generateJspFragment(Node n, String tagHandlerVar) throws JasperException {
            FragmentHelperClass.Fragment fragment = this.fragmentHelperClass.openFragment(n, this.methodNesting);
            ServletWriter outSave = this.out;
            this.out = fragment.getGenBuffer().getOut();
            String tmpParent = this.parent;
            this.parent = "_jspx_parent";
            boolean isSimpleTagParentSave = this.isSimpleTagParent;
            this.isSimpleTagParent = true;
            boolean tmpIsFragment = this.isFragment;
            this.isFragment = true;
            String pushBodyCountVarSave = this.pushBodyCountVar;
            if (this.pushBodyCountVar != null) {
                this.pushBodyCountVar = "_jspx_push_body_count";
            }
            this.visitBody(n);
            this.out = outSave;
            this.parent = tmpParent;
            this.isSimpleTagParent = isSimpleTagParentSave;
            this.isFragment = tmpIsFragment;
            this.pushBodyCountVar = pushBodyCountVarSave;
            this.fragmentHelperClass.closeFragment(fragment, this.methodNesting);
            this.out.print("new " + this.fragmentHelperClass.getClassName() + "( " + fragment.getId() + ", _jspx_page_context, " + tagHandlerVar + ", " + this.pushBodyCountVar + ")");
        }

        public String generateNamedAttributeValue(Node.NamedAttribute n) throws JasperException {
            String varName = n.getTemporaryVariableName();
            Node.Nodes body = n.getBody();
            if (body != null) {
                Node bodyElement;
                boolean templateTextOptimization = false;
                if (body.size() == 1 && (bodyElement = body.getNode(0)) instanceof Node.TemplateText) {
                    templateTextOptimization = true;
                    this.out.printil("java.lang.String " + varName + " = " + Generator.quote(((Node.TemplateText)bodyElement).getText()) + ";");
                }
                if (!templateTextOptimization) {
                    this.out.printil("out = _jspx_page_context.pushBody();");
                    this.visitBody(n);
                    Generator.printilMultiPart(this.out, "java.lang.String ", varName, " = ", "((", "jakarta.servlet.jsp.tagext.BodyContent", ")", "out).getString();");
                    this.out.printil("out = _jspx_page_context.popBody();");
                }
            } else {
                this.out.printil("java.lang.String " + varName + " = \"\";");
            }
            return varName;
        }

        public String generateNamedAttributeJspFragment(Node.NamedAttribute n, String tagHandlerVar) throws JasperException {
            String varName = n.getTemporaryVariableName();
            Generator.printinMultiPart(this.out, "jakarta.servlet.jsp.tagext.JspFragment", " ", varName, " = ");
            this.generateJspFragment(n, tagHandlerVar);
            this.out.println(";");
            return varName;
        }
    }
}

