/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.AggregateComponentService;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.DoohickeyAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;

class AggregateComponentDefinition<T>
extends SimpleResourceDefinition {
    private final ListAttributeDefinition aggregateReferences;
    private final OperationStepHandler attributeWriteHandler;

    private AggregateComponentDefinition(Class<T> classType, String pathKey, OperationStepHandler addHandler, OperationStepHandler removeHandler, ListAttributeDefinition aggregateReferences, OperationStepHandler attributeWriteHandler, RuntimeCapability<?> runtimeCapability) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler(addHandler).setRemoveHandler(removeHandler).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{runtimeCapability}));
        this.aggregateReferences = aggregateReferences;
        this.attributeWriteHandler = attributeWriteHandler;
    }

    ListAttributeDefinition getReferencesAttribute() {
        return this.aggregateReferences;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)this.aggregateReferences, null, this.attributeWriteHandler);
    }

    static <T> AggregateComponentDefinition<T> create(Class<T> aggregationType, String componentName, String referencesName, RuntimeCapability<?> runtimeCapability, Function<T[], T> aggregator) {
        return AggregateComponentDefinition.create(aggregationType, componentName, referencesName, runtimeCapability, aggregator, true);
    }

    static <T> AggregateComponentDefinition<T> create(Class<T> aggregationType, String componentName, String referencesName, RuntimeCapability<?> runtimeCapability, Function<T[], T> aggregator, boolean dependOnProviderRegistration) {
        String capabilityName = runtimeCapability.getName();
        StringListAttributeDefinition aggregateReferences = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(referencesName).setMinSize(2)).setRequired(true)).setCapabilityReference(capabilityName, capabilityName)).setRestartAllServices()).build();
        AggregateComponentAddHandler<T> add = new AggregateComponentAddHandler<T>(aggregationType, aggregator, aggregateReferences, runtimeCapability, dependOnProviderRegistration);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapability);
        return new AggregateComponentDefinition<T>(aggregationType, componentName, add, remove, (ListAttributeDefinition)aggregateReferences, ElytronReloadRequiredWriteAttributeHandler.INSTANCE, runtimeCapability);
    }

    static <T> AggregateComponentDefinition<T> create(Class<T> aggregationType, String componentName, String referencesName, RuntimeCapability<?> runtimeCapability, String apiCapabilityName, Function<T[], T> aggregator, boolean dependOnProviderRegistration) {
        String capabilityName = runtimeCapability.getName();
        StringListAttributeDefinition aggregateReferences = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(referencesName).setMinSize(2)).setRequired(true)).setCapabilityReference(capabilityName, capabilityName)).setRestartAllServices()).build();
        AggregateApiComponentAddHandler<T> add = new AggregateApiComponentAddHandler<T>(aggregationType, aggregator, aggregateReferences, runtimeCapability, apiCapabilityName, dependOnProviderRegistration);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapability);
        return new AggregateComponentDefinition<T>(aggregationType, componentName, add, remove, (ListAttributeDefinition)aggregateReferences, ElytronReloadRequiredWriteAttributeHandler.INSTANCE, runtimeCapability);
    }

    private static class AggregateApiComponentAddHandler<T>
    extends DoohickeyAddHandler<T> {
        private final Class<T> aggregationType;
        private final Function<T[], T> aggregator;
        private final StringListAttributeDefinition aggregateReferences;
        private final RuntimeCapability<?> runtimeCapability;
        private final boolean dependOnProviderRegistration;
        private final String apiCapabilityName;

        private AggregateApiComponentAddHandler(Class<T> aggregationType, Function<T[], T> aggregator, StringListAttributeDefinition aggregateReferences, RuntimeCapability<?> runtimeCapability, String apiCapabilityName, boolean dependOnProviderRegistration) {
            super(runtimeCapability, apiCapabilityName);
            this.aggregationType = aggregationType;
            this.aggregator = aggregator;
            this.aggregateReferences = aggregateReferences;
            this.runtimeCapability = runtimeCapability;
            this.dependOnProviderRegistration = dependOnProviderRegistration;
            this.apiCapabilityName = apiCapabilityName;
        }

        @Override
        protected ElytronDoohickey<T> createDoohickey(PathAddress resourceAddress) {
            return new ElytronDoohickey<T>(resourceAddress){
                private volatile List<String> aggregates;

                @Override
                protected void resolveRuntime(ModelNode model, OperationContext context) throws OperationFailedException {
                    this.aggregates = aggregateReferences.unwrap((ExpressionResolver)context, model);
                }

                @Override
                protected ExceptionSupplier<T, StartException> prepareServiceSupplier(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder) throws OperationFailedException {
                    final ArrayList<Supplier> typeSuppliers = new ArrayList<Supplier>(this.aggregates.size());
                    for (String current : this.aggregates) {
                        String capabilityName = RuntimeCapability.buildDynamicCapabilityName((String)runtimeCapability.getName(), (String)current);
                        ServiceName serviceName = context.getCapabilityServiceName(capabilityName, aggregationType);
                        typeSuppliers.add(serviceBuilder.requires(serviceName));
                    }
                    return new ExceptionSupplier<T, StartException>(){

                        public T get() throws StartException {
                            ArrayList loadedTypes = new ArrayList(typeSuppliers.size());
                            for (Supplier current : typeSuppliers) {
                                loadedTypes.add(current.get());
                            }
                            return aggregator.apply((Object[][])loadedTypes.toArray((Object[])Array.newInstance(aggregationType, loadedTypes.size())));
                        }
                    };
                }

                @Override
                protected T createImmediately(OperationContext foreignContext) throws OperationFailedException {
                    ArrayList<Object> loadedTypes = new ArrayList<Object>(this.aggregates.size());
                    for (String current : this.aggregates) {
                        ExceptionFunction typeApi = (ExceptionFunction)foreignContext.getCapabilityRuntimeAPI(apiCapabilityName, current, ExceptionFunction.class);
                        loadedTypes.add(typeApi.apply((Object)foreignContext));
                    }
                    return aggregator.apply((Object[][])loadedTypes.toArray((Object[])Array.newInstance(aggregationType, loadedTypes.size())));
                }
            };
        }

        @Override
        protected boolean dependOnProviderRegistration() {
            return this.dependOnProviderRegistration;
        }

        @Override
        protected ServiceController.Mode getInitialMode() {
            return ServiceController.Mode.LAZY;
        }
    }

    private static class AggregateComponentAddHandler<T>
    extends BaseAddHandler {
        private final Class<T> aggregationType;
        private final Function<T[], T> aggregator;
        private final StringListAttributeDefinition aggregateReferences;
        private final RuntimeCapability<?> runtimeCapability;
        private final boolean dependOnProviderRegistration;

        private AggregateComponentAddHandler(Class<T> aggregationType, Function<T[], T> aggregator, StringListAttributeDefinition aggregateReferences, RuntimeCapability<?> runtimeCapability, boolean dependOnProviderRegistration) {
            super(runtimeCapability);
            this.aggregationType = aggregationType;
            this.aggregator = aggregator;
            this.aggregateReferences = aggregateReferences;
            this.runtimeCapability = runtimeCapability;
            this.dependOnProviderRegistration = dependOnProviderRegistration;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability instanceRuntimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName componentName = instanceRuntimeCapability.getCapabilityServiceName(this.aggregationType);
            AggregateComponentService<T> aggregateComponentService = new AggregateComponentService<T>(this.aggregationType, this.aggregator);
            ServiceBuilder serviceBuilder = serviceTarget.addService(componentName, aggregateComponentService);
            List aggregates = this.aggregateReferences.unwrap((ExpressionResolver)context, model);
            String baseCapabilityName = this.runtimeCapability.getName();
            for (String current : aggregates) {
                String runtimeCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)baseCapabilityName, (String)current);
                ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapabilityName, this.aggregationType);
                serviceBuilder.addDependency(realmServiceName, this.aggregationType, aggregateComponentService.newInjector());
            }
            ElytronDefinition.commonDependencies(serviceBuilder, true, this.dependOnProviderRegistration).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }
}

