/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.CacheableSession;
import org.wildfly.clustering.session.cache.CachedSession;
import org.wildfly.common.function.Functions;

public class CachedSessionManager<C>
implements SessionManager<C> {
    private final SessionManager<C> manager;
    private final Cache<String, CompletionStage<CacheableSession<C>>> sessionCache;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionFinder;
    private final UnaryOperator<Session<C>> validator = new UnaryOperator<Session<C>>(){

        @Override
        public Session<C> apply(Session<C> session) {
            if (session != null && !session.isValid()) {
                session.close();
                return null;
            }
            return session;
        }
    };

    public CachedSessionManager(final SessionManager<C> manager, CacheFactory cacheFactory) {
        this.manager = manager;
        this.sessionCreator = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, Runnable closeTask) {
                return manager.createSessionAsync(id).thenApply(session -> new CachedSession(session, closeTask));
            }
        };
        final Function<Runnable, CacheableSession> empty = closeTask -> {
            closeTask.run();
            return null;
        };
        this.sessionFinder = new BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>(){

            @Override
            public CompletionStage<CacheableSession<C>> apply(String id, Runnable closeTask) {
                return manager.findSessionAsync(id).thenApply(session -> session != null ? new CachedSession(session, closeTask) : (CacheableSession)empty.apply(closeTask));
            }
        };
        this.sessionCache = cacheFactory.createCache(Functions.discardingConsumer(), new Consumer<CompletionStage<CacheableSession<C>>>(){

            @Override
            public void accept(CompletionStage<CacheableSession<C>> future) {
                future.thenAccept(session -> Optional.ofNullable(session).map(Supplier::get).ifPresent(Session::close));
            }
        });
    }

    public CompletionStage<Session<C>> createSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionCreator)).thenApply(Function.identity());
    }

    public CompletionStage<Session<C>> findSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionFinder)).thenApply(this.validator);
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String id) {
        return this.manager.findImmutableSessionAsync(id);
    }

    public Session<C> getDetachedSession(String id) {
        return this.manager.getDetachedSession(id);
    }

    public Supplier<String> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public Supplier<Batch> getBatchFactory() {
        return this.manager.getBatchFactory();
    }

    public SessionStatistics getStatistics() {
        return this.manager.getStatistics();
    }
}

