/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorTransaction
extends TransactionImpl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    boolean allowPageTransaction;
    MirrorController controlInUse = AMQPMirrorControllerTarget.getControllerInUse();

    public MirrorTransaction(StorageManager storageManager) {
        super(storageManager);
        logger.debug("controlTarget = {} transactionID = {}", (Object)this.controlInUse, (Object)this.getID());
    }

    protected synchronized void afterCommit(List<TransactionOperation> operationsToComplete) {
        MirrorController beforeController = AMQPMirrorControllerTarget.getControllerInUse();
        AMQPMirrorControllerTarget.setControllerInUse(this.controlInUse);
        try {
            super.afterCommit(operationsToComplete);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(beforeController);
        }
    }

    public boolean isAllowPageTransaction() {
        return this.allowPageTransaction;
    }

    public MirrorTransaction setAllowPageTransaction(boolean allowPageTransaction) {
        this.allowPageTransaction = allowPageTransaction;
        return this;
    }
}

