/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.dispatcher;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;

public class EmbeddedCacheManagerCommandDispatcher<A extends Comparable<A>, M extends org.wildfly.clustering.server.group.GroupMember<A>, C>
implements CommandDispatcher<CacheContainerGroupMember, C> {
    private final CommandDispatcher<M, C> dispatcher;
    private final Function<CacheContainerGroupMember, M> unwrapper;
    private final Function<M, CacheContainerGroupMember> wrapper;

    public EmbeddedCacheManagerCommandDispatcher(CommandDispatcher<M, C> dispatcher, Function<CacheContainerGroupMember, M> unwrapper, Function<M, CacheContainerGroupMember> wrapper) {
        this.dispatcher = dispatcher;
        this.wrapper = wrapper;
        this.unwrapper = unwrapper;
    }

    public C getContext() {
        return (C)this.dispatcher.getContext();
    }

    public <R, E extends Exception> CompletionStage<R> dispatchToMember(Command<R, ? super C, E> command, CacheContainerGroupMember member) throws IOException {
        return this.dispatcher.dispatchToMember(command, (GroupMember)((org.wildfly.clustering.server.group.GroupMember)this.unwrapper.apply(member)));
    }

    public <R, E extends Exception> Map<CacheContainerGroupMember, CompletionStage<R>> dispatchToGroup(Command<R, ? super C, E> command) throws IOException {
        return this.map(this.dispatcher.dispatchToGroup(command));
    }

    public <R, E extends Exception> Map<CacheContainerGroupMember, CompletionStage<R>> dispatchToGroup(Command<R, ? super C, E> command, Set<CacheContainerGroupMember> excluding) throws IOException {
        return this.map(this.dispatcher.dispatchToGroup(command, excluding.stream().map(this.unwrapper).collect(Collectors.toSet())));
    }

    private <R> Map<CacheContainerGroupMember, CompletionStage<R>> map(Map<M, CompletionStage<R>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(this.wrapper.compose(Map.Entry::getKey), Map.Entry::getValue));
    }

    public void close() {
        this.dispatcher.close();
    }
}

