/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.io.File;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.HeadersCompleter;
import org.jboss.as.cli.impl.aesh.cmd.HeadersConverter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.InstMgrPrepareRevertHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="revert", description="Reverts to a previous installation state.", activator=InstMgrActivator.class)
public class RevertCommand
extends AbstractInstMgrCommand {
    @OptionList(name="repositories")
    private List<String> repositories;
    @Option(name="local-cache")
    private File localCache;
    @Option(name="no-resolve-local-cache", hasValue=false, activator=AbstractInstMgrCommand.NoResolveLocalCacheActivator.class)
    private boolean noResolveLocalCache;
    @Option(name="use-default-local-cache", hasValue=false, activator=AbstractInstMgrCommand.UseDefaultLocalCacheActivator.class)
    private boolean useDefaultLocalCache;
    @Option(name="offline", hasValue=false)
    private boolean offline;
    @OptionList(name="maven-repo-files")
    private List<File> mavenRepoFiles;
    @Option(name="revision")
    private String revision;
    @Option(converter=HeadersConverter.class, completer=HeadersCompleter.class)
    public ModelNode headers;
    private Boolean optNoResolveLocalCache;
    private Boolean optUseDefaultLocalCache;

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        ParsedCommandLine cmdParser = ctx.getParsedCommandLine();
        this.optNoResolveLocalCache = cmdParser.hasProperty("--no-resolve-local-cache") ? Boolean.valueOf(this.noResolveLocalCache) : null;
        Boolean bl = this.optUseDefaultLocalCache = cmdParser.hasProperty("--use-default-local-cache") ? Boolean.valueOf(this.useDefaultLocalCache) : null;
        if (this.optNoResolveLocalCache != null && this.optUseDefaultLocalCache != null) {
            throw new CommandException(String.format("%s and %s cannot be used at the same time.", "no-resolve-local-cache", "use-default-local-cache"));
        }
        commandInvocation.println("\nThe new installation is being prepared ...\n");
        this.executeOp(ctx, this.host);
        ctx.printLine("The candidate server has been generated. To apply it, restart the server with 'shutdown --perform-installation' command.");
        return CommandResult.SUCCESS;
    }

    @Override
    protected Operation buildOperation() throws CommandException {
        ModelNode op = new ModelNode();
        OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)op);
        op.get("operation").set(InstMgrPrepareRevertHandler.DEFINITION.getName());
        if (this.mavenRepoFiles != null && !this.mavenRepoFiles.isEmpty()) {
            ModelNode filesMn = new ModelNode().addEmptyList();
            for (int i = 0; i < this.mavenRepoFiles.size(); ++i) {
                filesMn.add(i);
                operationBuilder.addFileAsAttachment(this.mavenRepoFiles.get(i));
            }
            op.get("maven-repo-files").set(filesMn);
        }
        RevertCommand.addRepositoriesToModelNode(op, this.repositories);
        if (this.localCache != null) {
            op.get("local-cache").set(this.localCache.toPath().normalize().toAbsolutePath().toString());
        }
        if (this.optNoResolveLocalCache != null) {
            op.get("no-resolve-local-cache").set(this.noResolveLocalCache);
        }
        if (this.optUseDefaultLocalCache != null) {
            op.get("use-default-local-cache").set(this.useDefaultLocalCache);
        }
        op.get("offline").set(this.offline);
        if (this.revision != null) {
            op.get("revision").set(this.revision);
        }
        if (this.headers != null && this.headers.isDefined()) {
            op.get("operation-headers").set(this.headers);
        }
        return operationBuilder.build();
    }
}

