/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.List;
import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;

class HibernateOrmQueryLoaderImpl<E, I>
implements HibernateOrmQueryLoader<E, I> {
    private final TypeQueryFactory<E, I> queryFactory;
    private final Set<Class<? extends E>> includedTypesFilter;
    private final EntityDomainType<?> entityDomainType;
    private final List<ConditionalExpression> conditionalExpressions;
    private final String order;

    public HibernateOrmQueryLoaderImpl(TypeQueryFactory<E, I> queryFactory, Set<Class<? extends E>> includedTypesFilter) {
        this.queryFactory = queryFactory;
        this.includedTypesFilter = includedTypesFilter;
        this.entityDomainType = null;
        this.conditionalExpressions = List.of();
        this.order = null;
    }

    public HibernateOrmQueryLoaderImpl(TypeQueryFactory<E, I> queryFactory, EntityDomainType<?> entityDomainType, Set<Class<? extends E>> includedTypesFilter, List<ConditionalExpression> conditionalExpressions, String order) {
        this.queryFactory = queryFactory;
        this.includedTypesFilter = includedTypesFilter;
        this.entityDomainType = entityDomainType;
        this.conditionalExpressions = conditionalExpressions;
        this.order = order;
    }

    @Override
    public Query<Long> createCountQuery(SharedSessionContractImplementor session) {
        return this.conditionalExpressions.isEmpty() ? this.queryFactory.createQueryForCount(session, this.includedTypesFilter) : this.queryFactory.createQueryForCount(session, this.entityDomainType, this.includedTypesFilter, this.conditionalExpressions);
    }

    @Override
    public Query<I> createIdentifiersQuery(SharedSessionContractImplementor session) {
        return this.conditionalExpressions.isEmpty() && this.order == null ? this.queryFactory.createQueryForIdentifierListing(session, this.includedTypesFilter) : this.queryFactory.createQueryForIdentifierListing(session, this.entityDomainType, this.includedTypesFilter, this.conditionalExpressions, this.order);
    }

    @Override
    public Query<E> createLoadingQuery(SessionImplementor session, String idParameterName) {
        return this.queryFactory.createQueryForLoadByUniqueProperty(session, idParameterName);
    }

    @Override
    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return this.queryFactory.createMultiIdentifierLoadAccess(session);
    }

    @Override
    public boolean uniquePropertyIsTheEntityId() {
        return this.queryFactory.uniquePropertyIsTheEntityId();
    }
}

